/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a~\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032`\u0010\u0005\u001a\\\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00010\u0006H\u0080\b\u00f8\u0001\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u001aH\u0010\u0012\u001a\u00020\u0001*\u00020\u001326\u0010\u0014\u001a2\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00010\u0015H\u0087\b\u00f8\u0001\u0000\u001aH\u0010\u0019\u001a\u00020\u0001*\u00020\u001326\u0010\u0014\u001a2\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00010\u0015H\u0087\b\u00f8\u0001\u0000\u001a\u001a\u0010\u001a\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u000f\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"findCommonPrefixAndSuffix", "", "a", "", "b", "onFound", "Lkotlin/Function4;", "", "Lkotlin/ParameterName;", "name", "aPrefixStart", "aSuffixStart", "bPrefixStart", "bSuffixStart", "delete", "Landroidx/compose/foundation/text/input/TextFieldBuffer;", "start", "end", "forEachChange", "Landroidx/compose/foundation/text/input/TextFieldBuffer$ChangeList;", "block", "Lkotlin/Function2;", "Landroidx/compose/ui/text/TextRange;", "range", "originalRange", "forEachChangeReversed", "insert", "index", "text", "", "placeCursorAtEnd", "selectAll", "foundation"})
public final class TextFieldBufferKt {
    public static final void insert(@NotNull TextFieldBuffer $this$insert, int index2, @NotNull String text2) {
        Intrinsics.checkNotNullParameter($this$insert, "<this>");
        Intrinsics.checkNotNullParameter(text2, "text");
        $this$insert.replace(index2, index2, text2);
    }

    public static final void delete(@NotNull TextFieldBuffer $this$delete, int start2, int end2) {
        Intrinsics.checkNotNullParameter($this$delete, "<this>");
        $this$delete.replace(start2, end2, "");
    }

    public static final void placeCursorAtEnd(@NotNull TextFieldBuffer $this$placeCursorAtEnd) {
        Intrinsics.checkNotNullParameter($this$placeCursorAtEnd, "<this>");
        $this$placeCursorAtEnd.placeCursorBeforeCharAt($this$placeCursorAtEnd.getLength());
    }

    public static final void selectAll(@NotNull TextFieldBuffer $this$selectAll) {
        Intrinsics.checkNotNullParameter($this$selectAll, "<this>");
        $this$selectAll.setSelection-5zc-tL8(TextRangeKt.TextRange(0, $this$selectAll.getLength()));
    }

    @ExperimentalFoundationApi
    public static final void forEachChange(@NotNull TextFieldBuffer.ChangeList $this$forEachChange, @NotNull Function2<? super TextRange, ? super TextRange, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$forEachChange, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachChange = false;
        for (int i = 0; i < $this$forEachChange.getChangeCount(); ++i) {
            block2.invoke(TextRange.box-impl($this$forEachChange.getRange--jx7JFs(i)), TextRange.box-impl($this$forEachChange.getOriginalRange--jx7JFs(i)));
        }
    }

    @ExperimentalFoundationApi
    public static final void forEachChangeReversed(@NotNull TextFieldBuffer.ChangeList $this$forEachChangeReversed, @NotNull Function2<? super TextRange, ? super TextRange, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$forEachChangeReversed, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachChangeReversed = false;
        for (int i = $this$forEachChangeReversed.getChangeCount() - 1; i >= 0; --i) {
            block2.invoke(TextRange.box-impl($this$forEachChangeReversed.getRange--jx7JFs(i)), TextRange.box-impl($this$forEachChangeReversed.getOriginalRange--jx7JFs(i)));
        }
    }

    public static final void findCommonPrefixAndSuffix(@NotNull CharSequence a, @NotNull CharSequence b, @NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super Integer, Unit> onFound) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(onFound, "onFound");
        boolean $i$f$findCommonPrefixAndSuffix = false;
        int aStart = 0;
        int aEnd = a.length();
        int bStart = 0;
        int bEnd = b.length();
        if (a.length() > 0 && b.length() > 0) {
            boolean prefixFound = false;
            boolean suffixFound = false;
            do {
                if (!prefixFound) {
                    if (a.charAt(aStart) == b.charAt(bStart)) {
                        ++aStart;
                        ++bStart;
                    } else {
                        prefixFound = true;
                    }
                }
                if (suffixFound) continue;
                if (a.charAt(aEnd - 1) == b.charAt(bEnd - 1)) {
                    --aEnd;
                    --bEnd;
                    continue;
                }
                suffixFound = true;
            } while (aStart < aEnd && bStart < bEnd && (!prefixFound || !suffixFound));
        }
        if (aStart >= aEnd && bStart >= bEnd) {
            return;
        }
        onFound.invoke((Integer)aStart, (Integer)aEnd, (Integer)bStart, (Integer)bEnd);
    }
}

