/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.undo;

import androidx.compose.foundation.text.UndoManager_jvmKt;
import androidx.compose.foundation.text.input.internal.undo.TextDeleteType;
import androidx.compose.foundation.text.input.internal.undo.TextEditType;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\t\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006$"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "", "index", "", "preText", "", "postText", "preSelection", "Landroidx/compose/ui/text/TextRange;", "postSelection", "timeInMillis", "", "canMerge", "", "(ILjava/lang/String;Ljava/lang/String;JJJZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCanMerge", "()Z", "deletionType", "Landroidx/compose/foundation/text/input/internal/undo/TextDeleteType;", "getDeletionType", "()Landroidx/compose/foundation/text/input/internal/undo/TextDeleteType;", "getIndex", "()I", "getPostSelection-d9O1mEE", "()J", "J", "getPostText", "()Ljava/lang/String;", "getPreSelection-d9O1mEE", "getPreText", "textEditType", "Landroidx/compose/foundation/text/input/internal/undo/TextEditType;", "getTextEditType", "()Landroidx/compose/foundation/text/input/internal/undo/TextEditType;", "getTimeInMillis", "Companion", "foundation"})
@StabilityInferred(parameters=1)
public final class TextUndoOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int index;
    @NotNull
    private final String preText;
    @NotNull
    private final String postText;
    private final long preSelection;
    private final long postSelection;
    private final long timeInMillis;
    private final boolean canMerge;
    @NotNull
    private final TextEditType textEditType;
    public static final int $stable;
    @NotNull
    private static final Saver<TextUndoOperation, Object> Saver;

    private TextUndoOperation(int index2, String preText, String postText, long preSelection, long postSelection, long timeInMillis, boolean canMerge) {
        Intrinsics.checkNotNullParameter(preText, "preText");
        Intrinsics.checkNotNullParameter(postText, "postText");
        this.index = index2;
        this.preText = preText;
        this.postText = postText;
        this.preSelection = preSelection;
        this.postSelection = postSelection;
        this.timeInMillis = timeInMillis;
        this.canMerge = canMerge;
        if (((CharSequence)this.preText).length() == 0 && ((CharSequence)this.postText).length() == 0) {
            throw new IllegalArgumentException("Either pre or post text must not be empty");
        }
        this.textEditType = ((CharSequence)this.preText).length() == 0 && ((CharSequence)this.postText).length() > 0 ? TextEditType.Insert : (((CharSequence)this.preText).length() > 0 && ((CharSequence)this.postText).length() == 0 ? TextEditType.Delete : TextEditType.Replace);
    }

    public /* synthetic */ TextUndoOperation(int n, String string, String string2, long l, long l2, long l3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            l3 = UndoManager_jvmKt.timeNowMillis();
        }
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        this(n, string, string2, l, l2, l3, bl, null);
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final String getPreText() {
        return this.preText;
    }

    @NotNull
    public final String getPostText() {
        return this.postText;
    }

    public final long getPreSelection-d9O1mEE() {
        return this.preSelection;
    }

    public final long getPostSelection-d9O1mEE() {
        return this.postSelection;
    }

    public final long getTimeInMillis() {
        return this.timeInMillis;
    }

    public final boolean getCanMerge() {
        return this.canMerge;
    }

    @NotNull
    public final TextEditType getTextEditType() {
        return this.textEditType;
    }

    @NotNull
    public final TextDeleteType getDeletionType() {
        if (this.textEditType != TextEditType.Delete) {
            return TextDeleteType.NotByUser;
        }
        if (!TextRange.getCollapsed-impl(this.postSelection)) {
            return TextDeleteType.NotByUser;
        }
        if (TextRange.getCollapsed-impl(this.preSelection)) {
            return TextRange.getStart-impl(this.preSelection) > TextRange.getStart-impl(this.postSelection) ? TextDeleteType.Start : TextDeleteType.End;
        }
        if (TextRange.getStart-impl(this.preSelection) == TextRange.getStart-impl(this.postSelection) && TextRange.getStart-impl(this.preSelection) == this.index) {
            return TextDeleteType.Inner;
        }
        return TextDeleteType.NotByUser;
    }

    public /* synthetic */ TextUndoOperation(int index2, String preText, String postText, long preSelection, long postSelection, long timeInMillis, boolean canMerge, DefaultConstructorMarker $constructor_marker) {
        this(index2, preText, postText, preSelection, postSelection, timeInMillis, canMerge);
    }

    static {
        Saver = new Saver<TextUndoOperation, Object>(){

            @NotNull
            public Object save(@NotNull SaverScope $this$save, @NotNull TextUndoOperation value) {
                Intrinsics.checkNotNullParameter($this$save, "<this>");
                Intrinsics.checkNotNullParameter(value, "value");
                Object[] objectArray = new Object[]{value.getIndex(), value.getPreText(), value.getPostText(), TextRange.getStart-impl(value.getPreSelection-d9O1mEE()), TextRange.getEnd-impl(value.getPreSelection-d9O1mEE()), TextRange.getStart-impl(value.getPostSelection-d9O1mEE()), TextRange.getEnd-impl(value.getPostSelection-d9O1mEE()), value.getTimeInMillis()};
                return CollectionsKt.listOf(objectArray);
            }

            @NotNull
            public TextUndoOperation restore(@NotNull Object value) {
                Intrinsics.checkNotNullParameter(value, "value");
                List $this$restore_u24lambda_u240 = (List)value;
                boolean bl = false;
                E e = $this$restore_u24lambda_u240.get(0);
                Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)e;
                E e2 = $this$restore_u24lambda_u240.get(1);
                Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type kotlin.String");
                String string = (String)e2;
                E e3 = $this$restore_u24lambda_u240.get(2);
                Intrinsics.checkNotNull(e3, "null cannot be cast to non-null type kotlin.String");
                String string2 = (String)e3;
                E e4 = $this$restore_u24lambda_u240.get(3);
                Intrinsics.checkNotNull(e4, "null cannot be cast to non-null type kotlin.Int");
                int n2 = (Integer)e4;
                E e5 = $this$restore_u24lambda_u240.get(4);
                Intrinsics.checkNotNull(e5, "null cannot be cast to non-null type kotlin.Int");
                long l = TextRangeKt.TextRange(n2, (Integer)e5);
                E e6 = $this$restore_u24lambda_u240.get(5);
                Intrinsics.checkNotNull(e6, "null cannot be cast to non-null type kotlin.Int");
                int n3 = (Integer)e6;
                E e7 = $this$restore_u24lambda_u240.get(6);
                Intrinsics.checkNotNull(e7, "null cannot be cast to non-null type kotlin.Int");
                long l2 = TextRangeKt.TextRange(n3, (Integer)e7);
                E e8 = $this$restore_u24lambda_u240.get(7);
                Intrinsics.checkNotNull(e8, "null cannot be cast to non-null type kotlin.Long");
                return new TextUndoOperation(n, string, string2, l, l2, (Long)e8, false, 64, null);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<TextUndoOperation, Object> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

