/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.SelectableDates;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarModel_skikoKt;
import androidx.compose.material3.internal.CalendarMonth;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b!\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R+\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Landroidx/compose/material3/BaseDatePickerStateImpl;", "", "initialDisplayedMonthMillis", "", "yearRange", "Lkotlin/ranges/IntRange;", "selectableDates", "Landroidx/compose/material3/SelectableDates;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Ljava/lang/Long;Lkotlin/ranges/IntRange;Landroidx/compose/material3/SelectableDates;Ljava/util/Locale;)V", "_displayedMonth", "Landroidx/compose/runtime/MutableState;", "Landroidx/compose/material3/internal/CalendarMonth;", "calendarModel", "Landroidx/compose/material3/internal/CalendarModel;", "getCalendarModel", "()Landroidx/compose/material3/internal/CalendarModel;", "monthMillis", "displayedMonthMillis", "getDisplayedMonthMillis", "()J", "setDisplayedMonthMillis", "(J)V", "<set-?>", "getSelectableDates", "()Landroidx/compose/material3/SelectableDates;", "setSelectableDates", "(Landroidx/compose/material3/SelectableDates;)V", "selectableDates$delegate", "Landroidx/compose/runtime/MutableState;", "getYearRange", "()Lkotlin/ranges/IntRange;", "material3"})
@Stable
@SourceDebugExtension(value={"SMAP\nDatePicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatePicker.kt\nandroidx/compose/material3/BaseDatePickerStateImpl\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,2274:1\n81#2:2275\n107#2,2:2276\n*S KotlinDebug\n*F\n+ 1 DatePicker.kt\nandroidx/compose/material3/BaseDatePickerStateImpl\n*L\n1085#1:2275\n1085#1:2276,2\n*E\n"})
public abstract class BaseDatePickerStateImpl {
    @NotNull
    private final IntRange yearRange;
    @NotNull
    private final CalendarModel calendarModel;
    @NotNull
    private final MutableState selectableDates$delegate;
    @NotNull
    private MutableState<CalendarMonth> _displayedMonth;
    public static final int $stable;

    public BaseDatePickerStateImpl(@Nullable Long initialDisplayedMonthMillis, @NotNull IntRange yearRange, @NotNull SelectableDates selectableDates, @NotNull Locale locale) {
        CalendarMonth calendarMonth;
        Intrinsics.checkNotNullParameter(yearRange, "yearRange");
        Intrinsics.checkNotNullParameter(selectableDates, "selectableDates");
        Intrinsics.checkNotNullParameter(locale, "locale");
        this.yearRange = yearRange;
        this.calendarModel = CalendarModel_skikoKt.createCalendarModel(locale);
        this.selectableDates$delegate = SnapshotStateKt.mutableStateOf$default(selectableDates, null, 2, null);
        if (initialDisplayedMonthMillis != null) {
            CalendarMonth month2 = this.calendarModel.getMonth(initialDisplayedMonthMillis);
            if (!this.yearRange.contains(month2.getYear())) {
                BaseDatePickerStateImpl baseDatePickerStateImpl = this;
                boolean bl = false;
                BaseDatePickerStateImpl baseDatePickerStateImpl2 = baseDatePickerStateImpl;
                String string = "The initial display month's year (" + month2.getYear() + ") is out of the years range of " + this.yearRange + '.';
                throw new IllegalArgumentException(string.toString());
            }
            calendarMonth = month2;
        } else {
            calendarMonth = this.calendarModel.getMonth(this.calendarModel.getToday());
        }
        this._displayedMonth = SnapshotStateKt.mutableStateOf$default(calendarMonth, null, 2, null);
    }

    @NotNull
    public final IntRange getYearRange() {
        return this.yearRange;
    }

    @NotNull
    public final CalendarModel getCalendarModel() {
        return this.calendarModel;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SelectableDates getSelectableDates() {
        void $this$getValue$iv;
        State state2 = this.selectableDates$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (SelectableDates)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setSelectableDates(@NotNull SelectableDates selectableDates) {
        void $this$setValue$iv;
        Intrinsics.checkNotNullParameter(selectableDates, "<set-?>");
        MutableState mutableState = this.selectableDates$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(selectableDates);
    }

    public final long getDisplayedMonthMillis() {
        return this._displayedMonth.getValue().getStartUtcTimeMillis();
    }

    public final void setDisplayedMonthMillis(long monthMillis) {
        CalendarMonth month2 = this.calendarModel.getMonth(monthMillis);
        if (!this.yearRange.contains(month2.getYear())) {
            boolean bl = false;
            String string = "The display month's year (" + month2.getYear() + ") is out of the years range of " + this.yearRange + '.';
            throw new IllegalArgumentException(string.toString());
        }
        this._displayedMonth.setValue(month2);
    }
}

