/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.DraggableAnchors;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u0015\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Landroidx/compose/material3/internal/MapDraggableAnchors;", "T", "Landroidx/compose/material3/internal/DraggableAnchors;", "anchors", "", "", "(Ljava/util/Map;)V", "size", "", "getSize", "()I", "closestAnchor", "position", "(F)Ljava/lang/Object;", "searchUpwards", "", "(FZ)Ljava/lang/Object;", "equals", "other", "", "hasAnchorFor", "value", "(Ljava/lang/Object;)Z", "hashCode", "maxAnchor", "minAnchor", "positionOf", "(Ljava/lang/Object;)F", "toString", "", "material3"})
@SourceDebugExtension(value={"SMAP\nAnchoredDraggable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnchoredDraggable.kt\nandroidx/compose/material3/internal/MapDraggableAnchors\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,864:1\n1#2:865\n*E\n"})
final class MapDraggableAnchors<T>
implements DraggableAnchors<T> {
    @NotNull
    private final Map<T, Float> anchors;

    public MapDraggableAnchors(@NotNull Map<T, Float> anchors2) {
        Intrinsics.checkNotNullParameter(anchors2, "anchors");
        this.anchors = anchors2;
    }

    @Override
    public float positionOf(T value) {
        Float f = this.anchors.get(value);
        return f != null ? f.floatValue() : Float.NaN;
    }

    @Override
    public boolean hasAnchorFor(T value) {
        return this.anchors.containsKey(value);
    }

    @Override
    @Nullable
    public T closestAnchor(float position) {
        Object v0;
        Iterable iterable = this.anchors.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t2 = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t2;
            } else {
                Map.Entry it = (Map.Entry)t2;
                boolean bl = false;
                float f = Math.abs(position - ((Number)it.getValue()).floatValue());
                do {
                    Object t3 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t3;
                    $i$a$-minByOrNull-MapDraggableAnchors$closestAnchor$1 = false;
                    float f2 = Math.abs(position - ((Number)it2.getValue()).floatValue());
                    if (Float.compare(f, f2) <= 0) continue;
                    t2 = t3;
                    f = f2;
                } while (iterator2.hasNext());
                v0 = t2;
            }
        }
        Map.Entry entry2 = v0;
        return (T)(entry2 != null ? entry2.getKey() : null);
    }

    @Override
    @Nullable
    public T closestAnchor(float position, boolean searchUpwards) {
        Object v0;
        Iterable iterable = this.anchors.entrySet();
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            v0 = null;
        } else {
            Object t2 = iterator2.next();
            if (!iterator2.hasNext()) {
                v0 = t2;
            } else {
                Map.Entry entry2 = (Map.Entry)t2;
                boolean bl = false;
                float anchor = ((Number)entry2.getValue()).floatValue();
                float delta = searchUpwards ? anchor - position : position - anchor;
                float f = delta < 0.0f ? Float.POSITIVE_INFINITY : delta;
                do {
                    float f2;
                    Object t3 = iterator2.next();
                    Map.Entry entry3 = (Map.Entry)t3;
                    $i$a$-minByOrNull-MapDraggableAnchors$closestAnchor$2 = false;
                    float anchor2 = ((Number)entry3.getValue()).floatValue();
                    float delta2 = searchUpwards ? anchor2 - position : position - anchor2;
                    float f3 = f2 = delta2 < 0.0f ? Float.POSITIVE_INFINITY : delta2;
                    if (Float.compare(f, f2) <= 0) continue;
                    t2 = t3;
                    f = f2;
                } while (iterator2.hasNext());
                v0 = t2;
            }
        }
        Map.Entry entry4 = v0;
        return entry4 != null ? (T)entry4.getKey() : null;
    }

    @Override
    public float minAnchor() {
        Object t2 = CollectionsKt.minOrNull((Iterable)this.anchors.values());
        return t2 != null ? ((Float)t2).floatValue() : Float.NaN;
    }

    @Override
    public float maxAnchor() {
        Object t2 = CollectionsKt.maxOrNull((Iterable)this.anchors.values());
        return t2 != null ? ((Float)t2).floatValue() : Float.NaN;
    }

    @Override
    public int getSize() {
        return this.anchors.size();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapDraggableAnchors)) {
            return false;
        }
        return Intrinsics.areEqual(this.anchors, ((MapDraggableAnchors)other).anchors);
    }

    public int hashCode() {
        return 31 * ((Object)this.anchors).hashCode();
    }

    @NotNull
    public String toString() {
        return "MapDraggableAnchors(" + this.anchors + ')';
    }
}

