/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B;\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0088\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorIterator;", "T", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "root", "", "", "tail", "index", "", "size", "trieHeight", "([Ljava/lang/Object;[Ljava/lang/Object;III)V", "[Ljava/lang/Object;", "trieIterator", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "next", "()Ljava/lang/Object;", "previous", "runtime"})
@StabilityInferred(parameters=0)
public final class PersistentVectorIterator<T>
extends AbstractListIterator<T> {
    @NotNull
    private final T[] tail;
    @NotNull
    private final TrieIterator<T> trieIterator;
    public static final int $stable = 8;

    public PersistentVectorIterator(@NotNull Object[] root, @NotNull T[] tail, int index2, int size2, int trieHeight) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(tail, "tail");
        super(index2, size2);
        this.tail = tail;
        int trieSize = UtilsKt.rootSize(size2);
        int trieIndex = RangesKt.coerceAtMost(index2, trieSize);
        this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
    }

    @Override
    public T next() {
        this.checkHasNext$runtime();
        if (this.trieIterator.hasNext()) {
            int n = this.getIndex();
            this.setIndex(n + 1);
            return this.trieIterator.next();
        }
        int n = this.getIndex();
        this.setIndex(n + 1);
        return this.tail[n - this.trieIterator.getSize()];
    }

    @Override
    public T previous() {
        this.checkHasPrevious$runtime();
        if (this.getIndex() > this.trieIterator.getSize()) {
            this.setIndex(this.getIndex() + -1);
            return this.tail[this.getIndex() - this.trieIterator.getSize()];
        }
        int n = this.getIndex();
        this.setIndex(n + -1);
        return this.trieIterator.previous();
    }
}

