/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.ComposableInferredTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.awt.RenderSettings;
import androidx.compose.ui.awt.SwingPanel_desktopKt;
import androidx.compose.ui.focus.FocusDirection;
import androidx.compose.ui.scene.ComposeContainer;
import androidx.compose.ui.window.WindowExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.SkiaLayerAnalytics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0012\u0010-\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\tH\u0002J\b\u00101\u001a\u00020\fH\u0007J\b\u00102\u001a\u00020\u001bH\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020\u001bH\u0016J\b\u00106\u001a\u00020\u001bH\u0016J\u0010\u00107\u001a\u00020\f2\u0006\u0010,\u001a\u00020+H\u0016J\u0012\u00108\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u00109\u001a\u00020\fH\u0016J\b\u0010:\u001a\u00020\fH\u0016J\u0012\u0010:\u001a\u00020\f2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001bH\u0016J\b\u0010>\u001a\u00020\u001bH\u0016J\u0012\u0010>\u001a\u00020\u001b2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J(\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020AH\u0016J\u0012\u0010E\u001a\u00020\f2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u001e\u0010H\u001a\u00020\f2\u0011\u0010I\u001a\r\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010JJ\u0010\u0010K\u001a\u00020\f2\u0006\u0010L\u001a\u00020\u001bH\u0016J\u0010\u0010M\u001a\u00020\f2\u0006\u0010N\u001a\u00020\u001bH\u0016J\u0012\u0010O\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010PH\u0016J\u0010\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020\u001bH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001a\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010$\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00018\u0006@FX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010\u0002\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006S"}, d2={"Landroidx/compose/ui/awt/ComposePanel;", "Ljavax/swing/JLayeredPane;", "()V", "skiaLayerAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "renderSettings", "Landroidx/compose/ui/awt/RenderSettings;", "(Lorg/jetbrains/skiko/SkiaLayerAnalytics;Landroidx/compose/ui/awt/RenderSettings;)V", "_composeContainer", "Landroidx/compose/ui/scene/ComposeContainer;", "_composeContent", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "Lkotlin/jvm/functions/Function2;", "_focusListeners", "", "Ljava/awt/event/FocusListener;", "value", "Landroidx/compose/ui/window/WindowExceptionHandler;", "exceptionHandler", "getExceptionHandler$annotations", "getExceptionHandler", "()Landroidx/compose/ui/window/WindowExceptionHandler;", "setExceptionHandler", "(Landroidx/compose/ui/window/WindowExceptionHandler;)V", "isDisposeOnRemove", "", "isDisposeOnRemove$annotations", "()Z", "setDisposeOnRemove", "(Z)V", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "windowContainer", "getWindowContainer$annotations", "getWindowContainer", "()Ljavax/swing/JLayeredPane;", "setWindowContainer", "(Ljavax/swing/JLayeredPane;)V", "add", "Ljava/awt/Component;", "component", "addFocusListener", "l", "addNotify", "createComposeContainer", "dispose", "getFocusTraversalKeysEnabled", "getPreferredSize", "Ljava/awt/Dimension;", "hasFocus", "isFocusOwner", "remove", "removeFocusListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "temporary", "requestFocusInWindow", "setBounds", "x", "", "y", "width", "height", "setComponentOrientation", "o", "Ljava/awt/ComponentOrientation;", "setContent", "content", "(Lkotlin/jvm/functions/Function2;)V", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "setFocusable", "focusable", "setLocale", "Ljava/util/Locale;", "setRequestFocusEnabled", "requestFocusEnabled", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposePanel.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1855#2,2:314\n*S KotlinDebug\n*F\n+ 1 ComposePanel.desktop.kt\nandroidx/compose/ui/awt/ComposePanel\n*L\n209#1:314,2\n*E\n"})
public final class ComposePanel
extends JLayeredPane {
    @NotNull
    private final SkiaLayerAnalytics skiaLayerAnalytics;
    @NotNull
    private final RenderSettings renderSettings;
    @NotNull
    private final Set<FocusListener> _focusListeners;
    @Nullable
    private ComposeContainer _composeContainer;
    @Nullable
    private Function2<? super Composer, ? super Integer, Unit> _composeContent;
    private boolean isDisposeOnRemove;
    @Nullable
    private WindowExceptionHandler exceptionHandler;
    @NotNull
    private JLayeredPane windowContainer;
    public static final int $stable = 8;

    @ExperimentalComposeUiApi
    public ComposePanel(@NotNull SkiaLayerAnalytics skiaLayerAnalytics, @NotNull RenderSettings renderSettings) {
        Intrinsics.checkNotNullParameter(skiaLayerAnalytics, "skiaLayerAnalytics");
        Intrinsics.checkNotNullParameter(renderSettings, "renderSettings");
        this.skiaLayerAnalytics = skiaLayerAnalytics;
        this.renderSettings = renderSettings;
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "ComposePanel should be created inside AWT Event Dispatch Thread (use SwingUtilities.invokeLater).\nCreating from another thread isn't supported.";
            throw new IllegalStateException(string.toString());
        }
        this.setBackground(Color.white);
        this.setLayout(null);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            @Nullable
            public Component getComponentAfter(@Nullable Container aContainer, @Nullable Component aComponent) {
                Container ancestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ancestor.getFocusTraversalPolicy();
                return policy.getComponentAfter(ancestor, this);
            }

            @Override
            @Nullable
            public Component getComponentBefore(@Nullable Container aContainer, @Nullable Component aComponent) {
                Container ancestor = this.getFocusCycleRootAncestor();
                FocusTraversalPolicy policy = ancestor.getFocusTraversalPolicy();
                return policy.getComponentBefore(ancestor, this);
            }

            @Nullable
            public Void getFirstComponent(@Nullable Container aContainer) {
                return null;
            }

            @Nullable
            public Void getLastComponent(@Nullable Container aContainer) {
                return null;
            }

            @Nullable
            public Void getDefaultComponent(@Nullable Container aContainer) {
                return null;
            }
        });
        this.setFocusCycleRoot(true);
        this.setFocusable(true);
        this._focusListeners = new LinkedHashSet();
        this.isDisposeOnRemove = true;
        this.windowContainer = this;
    }

    public /* synthetic */ ComposePanel(SkiaLayerAnalytics skiaLayerAnalytics, RenderSettings renderSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            renderSettings = RenderSettings.Companion.getDefault();
        }
        this(skiaLayerAnalytics, renderSettings);
    }

    public ComposePanel() {
        this(SkiaLayerAnalytics.Companion.getEmpty(), RenderSettings.Companion.getDefault());
    }

    public final boolean isDisposeOnRemove() {
        return this.isDisposeOnRemove;
    }

    public final void setDisposeOnRemove(boolean bl) {
        this.isDisposeOnRemove = bl;
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void isDisposeOnRemove$annotations() {
    }

    @ExperimentalComposeUiApi
    public final void dispose() {
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.dispose();
        }
        this._composeContainer = null;
    }

    @Override
    public void setBounds(int x2, int y2, int width2, int height2) {
        block0: {
            super.setBounds(x2, y2, width2, height2);
            ComposeContainer composeContainer = this._composeContainer;
            if (composeContainer == null) break block0;
            composeContainer.setBounds(0, 0, width2, height2);
        }
    }

    @Override
    @Nullable
    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.isPreferredSizeSet()) {
            dimension = super.getPreferredSize();
        } else {
            ComposeContainer composeContainer = this._composeContainer;
            dimension = composeContainer != null ? composeContainer.getPreferredSize() : null;
        }
        return dimension;
    }

    @ComposableInferredTarget(scheme="[androidx.compose.ui.UiComposable[androidx.compose.ui.UiComposable]]")
    public final void setContent(@NotNull Function2<? super Composer, ? super Integer, Unit> content2) {
        block0: {
            Intrinsics.checkNotNullParameter(content2, "content");
            this._composeContent = content2;
            ComposeContainer composeContainer = this._composeContainer;
            if (composeContainer == null) break block0;
            composeContainer.setContent(content2);
        }
    }

    @Nullable
    public final WindowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(@Nullable WindowExceptionHandler value) {
        this.exceptionHandler = value;
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.setExceptionHandler(value);
        }
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getExceptionHandler$annotations() {
    }

    @NotNull
    public final JLayeredPane getWindowContainer() {
        return this.windowContainer;
    }

    public final void setWindowContainer(@NotNull JLayeredPane value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.windowContainer = value;
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.setWindowContainer(value);
        }
    }

    @ExperimentalComposeUiApi
    public static /* synthetic */ void getWindowContainer$annotations() {
    }

    @Override
    @NotNull
    public Component add(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        Component component3 = super.add(component);
        Intrinsics.checkNotNullExpressionValue(component3, "add(...)");
        return component3;
    }

    @Override
    public void remove(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        super.remove(component);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer == null) {
            ComposeContainer composeContainer2;
            ComposeContainer it = composeContainer2 = this.createComposeContainer();
            boolean bl = false;
            this._composeContainer = it;
            Function2<? super Composer, ? super Integer, Unit> composeContent = this._composeContent;
            if (composeContent != null) {
                it.setContent(composeContent);
            }
            composeContainer = composeContainer2;
        }
        ComposeContainer composeContainer3 = composeContainer;
        composeContainer3.addNotify();
    }

    /*
     * WARNING - void declaration
     */
    private final ComposeContainer createComposeContainer() {
        void $this$forEach$iv;
        ComposeContainer composeContainer;
        ComposeContainer $this$createComposeContainer_u24lambda_u242 = composeContainer = new ComposeContainer(this, this.skiaLayerAnalytics, null, this.windowContainer, false, null, this.renderSettings, 52, null);
        boolean bl = false;
        $this$createComposeContainer_u24lambda_u242.setBounds(0, 0, this.getWidth(), this.getHeight());
        $this$createComposeContainer_u24lambda_u242.getContentComponent().setFocusable(this.isFocusable());
        $this$createComposeContainer_u24lambda_u242.getContentComponent().setRequestFocusEnabled(this.isRequestFocusEnabled());
        $this$createComposeContainer_u24lambda_u242.setExceptionHandler(this.exceptionHandler);
        Iterable iterable = this._focusListeners;
        JComponent jComponent = $this$createComposeContainer_u24lambda_u242.getContentComponent();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FocusListener p0 = (FocusListener)element$iv;
            boolean bl2 = false;
            jComponent.addFocusListener(p0);
        }
        $this$createComposeContainer_u24lambda_u242.getContentComponent().addFocusListener(new FocusListener(this, $this$createComposeContainer_u24lambda_u242){
            final /* synthetic */ ComposePanel this$0;
            final /* synthetic */ ComposeContainer $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public void focusGained(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (!e.isTemporary() && !SwingPanel_desktopKt.isFocusGainedHandledBySwingPanel(e, this.this$0)) {
                    FocusEvent.Cause cause = e.getCause();
                    switch (cause == null ? -1 : createComposeContainer.1.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: 
                        case 2: {
                            if (this.$this_apply.getFocusManager().getHasFocus()) break;
                            this.$this_apply.getFocusManager().takeFocus-3ESFkO8(FocusDirection.Companion.getNext-dhqQ-8s());
                            break;
                        }
                    }
                }
            }

            public void focusLost(@NotNull FocusEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
            }
        });
        return composeContainer;
    }

    @Override
    public void removeNotify() {
        ComposeContainer composeContainer = this._composeContainer;
        if (composeContainer != null) {
            composeContainer.removeNotify();
        }
        if (this.isDisposeOnRemove) {
            this.dispose();
        }
        super.removeNotify();
    }

    @Override
    public void setComponentOrientation(@Nullable ComponentOrientation o) {
        block0: {
            super.setComponentOrientation(o);
            ComposeContainer composeContainer = this._composeContainer;
            if (composeContainer == null) break block0;
            composeContainer.onLayoutDirectionChanged(this);
        }
    }

    @Override
    public void setLocale(@Nullable Locale l) {
        block0: {
            super.setLocale(l);
            ComposeContainer composeContainer = this._composeContainer;
            if (composeContainer == null) break block0;
            composeContainer.onLayoutDirectionChanged(this);
        }
    }

    @Override
    public void addFocusListener(@Nullable FocusListener l) {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            ((Component)object).addFocusListener(l);
        }
        this._focusListeners.add(l);
    }

    @Override
    public void removeFocusListener(@Nullable FocusListener l) {
        Object object = this._composeContainer;
        if (object != null && (object = ((ComposeContainer)object).getContentComponent()) != null) {
            ((Component)object).removeFocusListener(l);
        }
        this._focusListeners.remove(l);
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        ComposeContainer composeContainer = this._composeContainer;
        JComponent jComponent = composeContainer != null ? composeContainer.getContentComponent() : null;
        if (jComponent != null) {
            jComponent.setFocusable(focusable);
        }
    }

    @Override
    public void setRequestFocusEnabled(boolean requestFocusEnabled) {
        super.setRequestFocusEnabled(requestFocusEnabled);
        ComposeContainer composeContainer = this._composeContainer;
        JComponent jComponent = composeContainer != null ? composeContainer.getContentComponent() : null;
        if (jComponent != null) {
            jComponent.setRequestFocusEnabled(requestFocusEnabled);
        }
    }

    @Override
    public boolean hasFocus() {
        Object object = this._composeContainer;
        return object != null && (object = ((ComposeContainer)object).getContentComponent()) != null ? ((Component)object).hasFocus() : false;
    }

    @Override
    public boolean isFocusOwner() {
        Object object = this._composeContainer;
        return object != null && (object = ((ComposeContainer)object).getContentComponent()) != null ? ((Component)object).isFocusOwner() : false;
    }

    @Override
    public void requestFocus() {
        block0: {
            Object object = this._composeContainer;
            if (object == null || (object = ((ComposeContainer)object).getContentComponent()) == null) break block0;
            ((JComponent)object).requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        Object object = this._composeContainer;
        return object != null && (object = ((ComposeContainer)object).getContentComponent()) != null ? ((JComponent)object).requestFocus(temporary) : false;
    }

    @Override
    public void requestFocus(@Nullable FocusEvent.Cause cause) {
        block0: {
            Object object = this._composeContainer;
            if (object == null || (object = ((ComposeContainer)object).getContentComponent()) == null) break block0;
            ((Component)object).requestFocus(cause);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        Object object = this._composeContainer;
        return object != null && (object = ((ComposeContainer)object).getContentComponent()) != null ? ((JComponent)object).requestFocusInWindow() : false;
    }

    @Override
    public boolean requestFocusInWindow(@Nullable FocusEvent.Cause cause) {
        Object object = this._composeContainer;
        return object != null && (object = ((ComposeContainer)object).getContentComponent()) != null ? ((Component)object).requestFocusInWindow(cause) : false;
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        Object object = this._composeContainer;
        if (object == null || (object = object.getRenderApi()) == null) {
            object = GraphicsApi.UNKNOWN;
        }
        return object;
    }
}

