/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.input.pointer.HitPathTracker;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.PointerInputChangeEventProducer;
import androidx.compose.ui.input.pointer.PointerInputEvent;
import androidx.compose.ui.input.pointer.PointerInputEventProcessorKt;
import androidx.compose.ui.input.pointer.PointerType;
import androidx.compose.ui.input.pointer.PositionCalculator;
import androidx.compose.ui.node.HitTestResult;
import androidx.compose.ui.node.LayoutNode;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"Landroidx/compose/ui/input/pointer/PointerInputEventProcessor;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "(Landroidx/compose/ui/node/LayoutNode;)V", "hitPathTracker", "Landroidx/compose/ui/input/pointer/HitPathTracker;", "hitResult", "Landroidx/compose/ui/node/HitTestResult;", "isProcessing", "", "pointerInputChangeEventProducer", "Landroidx/compose/ui/input/pointer/PointerInputChangeEventProducer;", "getRoot", "()Landroidx/compose/ui/node/LayoutNode;", "clearPreviouslyHitModifierNodes", "", "process", "Landroidx/compose/ui/input/pointer/ProcessResult;", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerInputEvent;", "positionCalculator", "Landroidx/compose/ui/input/pointer/PositionCalculator;", "isInBounds", "process-BIzXfog", "(Landroidx/compose/ui/input/pointer/PointerInputEvent;Landroidx/compose/ui/input/pointer/PositionCalculator;Z)I", "processCancel", "ui"})
@StabilityInferred(parameters=0)
public final class PointerInputEventProcessor {
    @NotNull
    private final LayoutNode root;
    @NotNull
    private final HitPathTracker hitPathTracker;
    @NotNull
    private final PointerInputChangeEventProducer pointerInputChangeEventProducer;
    @NotNull
    private final HitTestResult hitResult;
    private boolean isProcessing;
    public static final int $stable = 8;

    public PointerInputEventProcessor(@NotNull LayoutNode root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.root = root;
        this.hitPathTracker = new HitPathTracker(this.root.getCoordinates());
        this.pointerInputChangeEventProducer = new PointerInputChangeEventProducer();
        this.hitResult = new HitTestResult();
    }

    @NotNull
    public final LayoutNode getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int process-BIzXfog(@NotNull PointerInputEvent pointerEvent, @NotNull PositionCalculator positionCalculator, boolean isInBounds) {
        Intrinsics.checkNotNullParameter(pointerEvent, "pointerEvent");
        Intrinsics.checkNotNullParameter(positionCalculator, "positionCalculator");
        if (this.isProcessing) {
            return PointerInputEventProcessorKt.ProcessResult(false, false);
        }
        try {
            boolean bl;
            PointerInputChange pointerInputChange;
            int i;
            this.isProcessing = true;
            InternalPointerEvent internalPointerEvent = this.pointerInputChangeEventProducer.produce(pointerEvent, positionCalculator);
            boolean isHover = true;
            int n = internalPointerEvent.getChanges().size();
            for (i = 0; i < n; ++i) {
                pointerInputChange = internalPointerEvent.getChanges().valueAt(i);
                if (!pointerInputChange.getPressed() && !pointerInputChange.getPreviousPressed()) continue;
                isHover = false;
                break;
            }
            n = internalPointerEvent.getChanges().size();
            for (i = 0; i < n; ++i) {
                pointerInputChange = internalPointerEvent.getChanges().valueAt(i);
                if (!isHover && !PointerEventKt.changedToDownIgnoreConsumed(pointerInputChange)) continue;
                boolean isTouchEvent = PointerType.equals-impl0(pointerInputChange.getType-T8wyACA(), PointerType.Companion.getTouch-T8wyACA());
                LayoutNode.hitTest-M_7yMNQ$ui$default(this.root, pointerInputChange.getPosition-F1C5BW0(), this.hitResult, isTouchEvent, false, 8, null);
                if (!(!((Collection)this.hitResult).isEmpty())) continue;
                this.hitPathTracker.addHitPath-QJqDSyo(pointerInputChange.getId-J3iCeTQ(), this.hitResult, PointerEventKt.changedToDownIgnoreConsumed(pointerInputChange));
                this.hitResult.clear();
            }
            this.hitPathTracker.removeDetachedPointerInputNodes();
            boolean dispatchedToSomething = this.hitPathTracker.dispatchChanges(internalPointerEvent, isInBounds);
            if (internalPointerEvent.getSuppressMovementConsumption()) {
                bl = false;
            } else {
                boolean result2 = false;
                int n2 = internalPointerEvent.getChanges().size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    PointerInputChange event = internalPointerEvent.getChanges().valueAt(i2);
                    if (!PointerEventKt.positionChangedIgnoreConsumed(event) || !event.isConsumed()) continue;
                    result2 = true;
                    break;
                }
                bl = result2;
            }
            boolean anyMovementConsumed = bl;
            int n3 = PointerInputEventProcessorKt.ProcessResult(dispatchedToSomething, anyMovementConsumed);
            return n3;
        }
        finally {
            this.isProcessing = false;
        }
    }

    public static /* synthetic */ int process-BIzXfog$default(PointerInputEventProcessor pointerInputEventProcessor, PointerInputEvent pointerInputEvent, PositionCalculator positionCalculator, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return pointerInputEventProcessor.process-BIzXfog(pointerInputEvent, positionCalculator, bl);
    }

    public final void processCancel() {
        if (!this.isProcessing) {
            this.pointerInputChangeEventProducer.clear();
            this.hitPathTracker.processCancel();
        }
    }

    public final void clearPreviouslyHitModifierNodes() {
        this.hitPathTracker.clearPreviouslyHitModifierNodeCache();
    }
}

