/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.internal.InlineClassHelperKt;
import androidx.compose.ui.node.MyersDiffKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0011\u001a\u00020\fJ \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J&\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J \u0010 \u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0006\u0010!\u001a\u00020\u0018J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/compose/ui/node/IntStack;", "", "initialCapacity", "", "(I)V", "lastIndex", "size", "getSize", "()I", "stack", "", "compareDiagonal", "", "a", "b", "get", "index", "isNotEmpty", "partition", "start", "end", "elSize", "pop", "pushDiagonal", "", "x", "y", "pushRange", "oldStart", "oldEnd", "newStart", "newEnd", "quickSort", "sortDiagonals", "swapDiagonal", "i", "j", "ui"})
@SourceDebugExtension(value={"SMAP\nMyersDiff.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/internal/InlineClassHelperKt\n*L\n1#1,512:1\n42#2,7:513\n*S KotlinDebug\n*F\n+ 1 MyersDiff.kt\nandroidx/compose/ui/node/IntStack\n*L\n464#1:513,7\n*E\n"})
final class IntStack {
    @NotNull
    private int[] stack;
    private int lastIndex;

    public IntStack(int initialCapacity) {
        this.stack = new int[initialCapacity];
    }

    public final int get(int index2) {
        return this.stack[index2];
    }

    public final int getSize() {
        return this.lastIndex;
    }

    public final void pushRange(int oldStart, int oldEnd, int newStart, int newEnd) {
        int i = this.lastIndex;
        if (i + 4 >= this.stack.length) {
            int[] nArray = Arrays.copyOf(this.stack, this.stack.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.stack = nArray;
        }
        int[] stack = this.stack;
        stack[i + 0] = oldStart;
        stack[i + 1] = oldEnd;
        stack[i + 2] = newStart;
        stack[i + 3] = newEnd;
        this.lastIndex = i + 4;
    }

    public final void pushDiagonal(int x2, int y2, int size2) {
        int i = this.lastIndex;
        if (i + 3 >= this.stack.length) {
            int[] nArray = Arrays.copyOf(this.stack, this.stack.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.stack = nArray;
        }
        int[] stack = this.stack;
        stack[i + 0] = x2 + size2;
        stack[i + 1] = y2 + size2;
        stack[i + 2] = size2;
        this.lastIndex = i + 3;
    }

    public final int pop() {
        this.lastIndex += -1;
        return this.stack[this.lastIndex];
    }

    public final boolean isNotEmpty() {
        return this.lastIndex != 0;
    }

    public final void sortDiagonals() {
        int i = this.lastIndex;
        boolean value$iv = i % 3 == 0;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("Array size not a multiple of 3");
        }
        if (i > 3) {
            this.quickSort(0, i - 3, 3);
        }
    }

    private final void quickSort(int start2, int end2, int elSize) {
        if (start2 < end2) {
            int i = this.partition(start2, end2, elSize);
            this.quickSort(start2, i - elSize, elSize);
            this.quickSort(i + elSize, end2, elSize);
        }
    }

    private final int partition(int start2, int end2, int elSize) {
        int i = start2 - elSize;
        for (int j = start2; j < end2; j += elSize) {
            if (!this.compareDiagonal(j, end2)) continue;
            this.swapDiagonal(i += elSize, j);
        }
        this.swapDiagonal(i + elSize, end2);
        return i + elSize;
    }

    private final void swapDiagonal(int i, int j) {
        int[] stack = this.stack;
        MyersDiffKt.access$swap(stack, i, j);
        MyersDiffKt.access$swap(stack, i + 1, j + 1);
        MyersDiffKt.access$swap(stack, i + 2, j + 2);
    }

    private final boolean compareDiagonal(int a, int b) {
        int[] stack = this.stack;
        int a0 = stack[a];
        int b0 = stack[b];
        return a0 < b0 || a0 == b0 && stack[a + 1] <= stack[b + 1];
    }
}

