/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.res.vector;

import androidx.compose.ui.graphics.PathFillType;
import androidx.compose.ui.graphics.StrokeCap;
import androidx.compose.ui.graphics.StrokeJoin;
import androidx.compose.ui.graphics.TileMode;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u001b\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"ALPHA_MASK", "", "parseColorValue", "color", "", "parseFillType", "Landroidx/compose/ui/graphics/PathFillType;", "fillType", "(Ljava/lang/String;)I", "parseStrokeCap", "Landroidx/compose/ui/graphics/StrokeCap;", "strokeCap", "parseStrokeJoin", "Landroidx/compose/ui/graphics/StrokeJoin;", "strokeJoin", "parseTileMode", "Landroidx/compose/ui/graphics/TileMode;", "tileMode", "parseDp", "Landroidx/compose/ui/unit/Dp;", "density", "Landroidx/compose/ui/unit/Density;", "(Ljava/lang/String;Landroidx/compose/ui/unit/Density;)F", "ui"})
@SourceDebugExtension(value={"SMAP\nDesktopValueParsers.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopValueParsers.desktop.kt\nandroidx/compose/ui/res/vector/DesktopValueParsers_desktopKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,104:1\n1#2:105\n169#3:106\n169#3:107\n*S KotlinDebug\n*F\n+ 1 DesktopValueParsers.desktop.kt\nandroidx/compose/ui/res/vector/DesktopValueParsers_desktopKt\n*L\n99#1:106\n100#1:107\n*E\n"})
public final class DesktopValueParsers_desktopKt {
    private static final int ALPHA_MASK = -16777216;

    public static final int parseColorValue(@NotNull String color2) {
        int n;
        Intrinsics.checkNotNullParameter(color2, "color");
        if (!StringsKt.startsWith$default(color2, "#", false, 2, null)) {
            boolean $i$a$-require-DesktopValueParsers_desktopKt$parseColorValue$22 = false;
            String $i$a$-require-DesktopValueParsers_desktopKt$parseColorValue$22 = "Invalid color value " + color2;
            throw new IllegalArgumentException($i$a$-require-DesktopValueParsers_desktopKt$parseColorValue$22.toString());
        }
        switch (color2.length()) {
            case 7: {
                String string = color2.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                n = Integer.parseUnsignedInt(string, 16) | 0xFF000000;
                break;
            }
            case 9: {
                String string = color2.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                n = Integer.parseUnsignedInt(string, 16);
                break;
            }
            case 4: {
                String string = color2.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                int v = Integer.parseUnsignedInt(string, 16);
                int k = (v >> 8 & 0xF) * 0x110000;
                k |= (v >> 4 & 0xF) * 4352;
                n = (k |= (v & 0xF) * 17) | 0xFF000000;
                break;
            }
            case 5: {
                String string = color2.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                int v = Integer.parseUnsignedInt(string, 16);
                int k = (v >> 12 & 0xF) * 0x11000000;
                k |= (v >> 8 & 0xF) * 0x110000;
                k |= (v >> 4 & 0xF) * 4352;
                n = (k |= (v & 0xF) * 17) | 0xFF000000;
                break;
            }
            default: {
                n = -16777216;
            }
        }
        return n;
    }

    public static final int parseFillType(@NotNull String fillType) {
        int n;
        Intrinsics.checkNotNullParameter(fillType, "fillType");
        String string = fillType;
        if (Intrinsics.areEqual(string, "nonZero")) {
            n = PathFillType.Companion.getNonZero-Rg-k1Os();
        } else if (Intrinsics.areEqual(string, "evenOdd")) {
            n = PathFillType.Companion.getEvenOdd-Rg-k1Os();
        } else {
            throw new UnsupportedOperationException("unknown fillType: " + fillType);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parseStrokeCap(@NotNull String strokeCap) {
        int n;
        block6: {
            Intrinsics.checkNotNullParameter(strokeCap, "strokeCap");
            String string = strokeCap;
            switch (string.hashCode()) {
                case -894674659: {
                    if (!string.equals("square")) {
                        throw new UnsupportedOperationException("unknown strokeCap: " + strokeCap);
                    }
                    break block6;
                }
                case 108704142: {
                    if (string.equals("round")) break;
                    throw new UnsupportedOperationException("unknown strokeCap: " + strokeCap);
                }
                case 3035667: {
                    if (!string.equals("butt")) throw new UnsupportedOperationException("unknown strokeCap: " + strokeCap);
                    n = StrokeCap.Companion.getButt-KaPHkGw();
                    return n;
                }
            }
            n = StrokeCap.Companion.getRound-KaPHkGw();
            return n;
        }
        n = StrokeCap.Companion.getSquare-KaPHkGw();
        return n;
        throw new UnsupportedOperationException("unknown strokeCap: " + strokeCap);
    }

    public static final int parseStrokeJoin(@NotNull String strokeJoin) {
        int n;
        Intrinsics.checkNotNullParameter(strokeJoin, "strokeJoin");
        switch (strokeJoin) {
            case "miter": {
                n = StrokeJoin.Companion.getMiter-LxFBmk8();
                break;
            }
            case "round": {
                n = StrokeJoin.Companion.getRound-LxFBmk8();
                break;
            }
            case "bevel": {
                n = StrokeJoin.Companion.getBevel-LxFBmk8();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown strokeJoin: " + strokeJoin);
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int parseTileMode(@NotNull String tileMode) {
        int n;
        block6: {
            Intrinsics.checkNotNullParameter(tileMode, "tileMode");
            String string = tileMode;
            switch (string.hashCode()) {
                case -1073910849: {
                    if (!string.equals("mirror")) {
                        throw new UnsupportedOperationException("unknown tileMode: " + tileMode);
                    }
                    break block6;
                }
                case -436781190: {
                    if (string.equals("repeated")) break;
                    throw new UnsupportedOperationException("unknown tileMode: " + tileMode);
                }
                case 94742715: {
                    if (!string.equals("clamp")) throw new UnsupportedOperationException("unknown tileMode: " + tileMode);
                    n = TileMode.Companion.getClamp-3opZhB0();
                    return n;
                }
            }
            n = TileMode.Companion.getRepeated-3opZhB0();
            return n;
        }
        n = TileMode.Companion.getMirror-3opZhB0();
        return n;
        throw new UnsupportedOperationException("unknown tileMode: " + tileMode);
    }

    public static final float parseDp(@Nullable String $this$parseDp, @NotNull Density density) {
        float f;
        Intrinsics.checkNotNullParameter(density, "density");
        Density $this$parseDp_u24lambda_u241 = density;
        boolean bl = false;
        if ($this$parseDp == null) {
            float $this$dp$iv = 0.0f;
            boolean $i$f$getDp = false;
            f = Dp.constructor-impl($this$dp$iv);
        } else if (StringsKt.endsWith$default($this$parseDp, "dp", false, 2, null)) {
            float $this$dp$iv = Float.parseFloat(StringsKt.removeSuffix($this$parseDp, (CharSequence)"dp"));
            boolean $i$f$getDp = false;
            f = Dp.constructor-impl($this$dp$iv);
        } else if (StringsKt.endsWith$default($this$parseDp, "px", false, 2, null)) {
            f = $this$parseDp_u24lambda_u241.toDp-u2uoSUM(Float.parseFloat(StringsKt.removeSuffix($this$parseDp, (CharSequence)"px")));
        } else {
            throw new UnsupportedOperationException("value should ends with dp or px");
        }
        return f;
    }
}

