/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.JvmActuals_jvmKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\b\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0004H\u0086\u0002J\r\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u0000J\u0013\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\"\u0010\u001c\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00150 \u00a2\u0006\u0002\u0010!J1\u0010\"\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00042\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00150 \u00a2\u0006\u0002\u0010!J\b\u0010#\u001a\u00020$H\u0016J!\u0010%\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00030&H\u0096\u0002J\u0015\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b)J*\u0010*\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00042\u0006\u0010+\u001a\u0002H\u0015H\u0096\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020.H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR \u0010\u000e\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Landroidx/compose/ui/semantics/SemanticsConfiguration;", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "", "", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "", "()V", "isClearingSemantics", "", "()Z", "setClearingSemantics", "(Z)V", "isMergingSemanticsOfDescendants", "setMergingSemanticsOfDescendants", "props", "", "collapsePeer", "", "peer", "collapsePeer$ui", "contains", "T", "key", "containsImportantForAccessibility", "containsImportantForAccessibility$ui", "copy", "equals", "other", "get", "(Landroidx/compose/ui/semantics/SemanticsPropertyKey;)Ljava/lang/Object;", "getOrElse", "defaultValue", "Lkotlin/Function0;", "(Landroidx/compose/ui/semantics/SemanticsPropertyKey;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrElseNullable", "hashCode", "", "iterator", "", "mergeChild", "child", "mergeChild$ui", "set", "value", "(Landroidx/compose/ui/semantics/SemanticsPropertyKey;Ljava/lang/Object;)V", "toString", "", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSemanticsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsConfiguration.kt\nandroidx/compose/ui/semantics/SemanticsConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1747#2,3:200\n*S KotlinDebug\n*F\n+ 1 SemanticsConfiguration.kt\nandroidx/compose/ui/semantics/SemanticsConfiguration\n*L\n78#1:200,3\n*E\n"})
public final class SemanticsConfiguration
implements SemanticsPropertyReceiver,
Iterable<Map.Entry<? extends SemanticsPropertyKey<?>, ? extends Object>>,
KMappedMarker {
    @NotNull
    private final Map<SemanticsPropertyKey<?>, Object> props = new LinkedHashMap();
    private boolean isMergingSemanticsOfDescendants;
    private boolean isClearingSemantics;
    public static final int $stable = 8;

    public final <T> T get(@NotNull SemanticsPropertyKey<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = this.props.get(key);
        if (object == null) {
            boolean bl = false;
            throw new IllegalStateException("Key not present: " + key + " - consider getOrElse or getOrNull");
        }
        return (T)object;
    }

    public final <T> T getOrElse(@NotNull SemanticsPropertyKey<T> key, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        Object object = this.props.get(key);
        if (object == null) {
            object = defaultValue.invoke();
        }
        return (T)object;
    }

    @Nullable
    public final <T> T getOrElseNullable(@NotNull SemanticsPropertyKey<T> key, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        Object object = this.props.get(key);
        if (object == null) {
            object = defaultValue.invoke();
        }
        return (T)object;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<SemanticsPropertyKey<?>, Object>> iterator() {
        return this.props.entrySet().iterator();
    }

    @Override
    public <T> void set(@NotNull SemanticsPropertyKey<T> key, T value) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (value instanceof AccessibilityAction && this.contains(key)) {
            Object t2;
            Object object = this.props.get(key);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type androidx.compose.ui.semantics.AccessibilityAction<*>");
            AccessibilityAction prev = (AccessibilityAction)object;
            Map<SemanticsPropertyKey<?>, Object> map2 = this.props;
            String string = ((AccessibilityAction)value).getLabel();
            if (string == null) {
                string = prev.getLabel();
            }
            if ((t2 = ((AccessibilityAction)value).getAction()) == null) {
                t2 = prev.getAction();
            }
            AccessibilityAction accessibilityAction = new AccessibilityAction(string, t2);
            map2.put(key, accessibilityAction);
        } else {
            this.props.put(key, value);
        }
    }

    public final <T> boolean contains(@NotNull SemanticsPropertyKey<T> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.props.containsKey(key);
    }

    public final boolean containsImportantForAccessibility$ui() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.props.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SemanticsPropertyKey it = (SemanticsPropertyKey)element$iv;
                    boolean bl2 = false;
                    if (!it.isImportantForAccessibility$ui()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isMergingSemanticsOfDescendants() {
        return this.isMergingSemanticsOfDescendants;
    }

    public final void setMergingSemanticsOfDescendants(boolean bl) {
        this.isMergingSemanticsOfDescendants = bl;
    }

    public final boolean isClearingSemantics() {
        return this.isClearingSemantics;
    }

    public final void setClearingSemantics(boolean bl) {
        this.isClearingSemantics = bl;
    }

    public final void mergeChild$ui(@NotNull SemanticsConfiguration child2) {
        Intrinsics.checkNotNullParameter(child2, "child");
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry2 : child2.props.entrySet()) {
            SemanticsPropertyKey<?> key = entry2.getKey();
            Object nextValue = entry2.getValue();
            Object existingValue = this.props.get(key);
            Intrinsics.checkNotNull(key, "null cannot be cast to non-null type androidx.compose.ui.semantics.SemanticsPropertyKey<kotlin.Any?>");
            Object mergeResult = key.merge(existingValue, nextValue);
            if (mergeResult == null) continue;
            this.props.put(key, mergeResult);
        }
    }

    public final void collapsePeer$ui(@NotNull SemanticsConfiguration peer) {
        Intrinsics.checkNotNullParameter(peer, "peer");
        if (peer.isMergingSemanticsOfDescendants) {
            this.isMergingSemanticsOfDescendants = true;
        }
        if (peer.isClearingSemantics) {
            this.isClearingSemantics = true;
        }
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry2 : peer.props.entrySet()) {
            Object t2;
            SemanticsPropertyKey<?> key = entry2.getKey();
            Object nextValue = entry2.getValue();
            if (!this.props.containsKey(key)) {
                this.props.put(key, nextValue);
                continue;
            }
            if (!(nextValue instanceof AccessibilityAction)) continue;
            Object object = this.props.get(key);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type androidx.compose.ui.semantics.AccessibilityAction<*>");
            AccessibilityAction value = (AccessibilityAction)object;
            Map<SemanticsPropertyKey<?>, Object> map2 = this.props;
            String string = value.getLabel();
            if (string == null) {
                string = ((AccessibilityAction)nextValue).getLabel();
            }
            if ((t2 = value.getAction()) == null) {
                t2 = ((AccessibilityAction)nextValue).getAction();
            }
            AccessibilityAction accessibilityAction = new AccessibilityAction(string, t2);
            map2.put(key, accessibilityAction);
        }
    }

    @NotNull
    public final SemanticsConfiguration copy() {
        SemanticsConfiguration copy2 = new SemanticsConfiguration();
        copy2.isMergingSemanticsOfDescendants = this.isMergingSemanticsOfDescendants;
        copy2.isClearingSemantics = this.isClearingSemantics;
        copy2.props.putAll(this.props);
        return copy2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemanticsConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.props, ((SemanticsConfiguration)other).props)) {
            return false;
        }
        if (this.isMergingSemanticsOfDescendants != ((SemanticsConfiguration)other).isMergingSemanticsOfDescendants) {
            return false;
        }
        return this.isClearingSemantics == ((SemanticsConfiguration)other).isClearingSemantics;
    }

    public int hashCode() {
        int result2 = ((Object)this.props).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isMergingSemanticsOfDescendants);
        result2 = 31 * result2 + Boolean.hashCode(this.isClearingSemantics);
        return result2;
    }

    @NotNull
    public String toString() {
        StringBuilder propsString = new StringBuilder();
        String nextSeparator = "";
        if (this.isMergingSemanticsOfDescendants) {
            propsString.append(nextSeparator);
            propsString.append("mergeDescendants=true");
            nextSeparator = ", ";
        }
        if (this.isClearingSemantics) {
            propsString.append(nextSeparator);
            propsString.append("isClearingSemantics=true");
            nextSeparator = ", ";
        }
        for (Map.Entry<SemanticsPropertyKey<?>, Object> entry2 : this.props.entrySet()) {
            SemanticsPropertyKey<?> key = entry2.getKey();
            Object value = entry2.getValue();
            propsString.append(nextSeparator);
            propsString.append(key.getName());
            propsString.append(" : ");
            propsString.append(value);
            nextSeparator = ", ";
        }
        return JvmActuals_jvmKt.simpleIdentityToString(this, null) + "{ " + propsString + " }";
    }
}

