/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextInclusionStrategy;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0005H\u0082\bJ*\u0010B\u001a\u00020@2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bH\u0010IJ\u0010\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020\u0007H\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010N\u001a\u0002072\u0006\u0010A\u001a\u00020\u0005H\u0016J\u001c\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010A\u001a\u00020\u00052\b\b\u0002\u0010Q\u001a\u00020\u0005H\u0002J\u0012\u0010R\u001a\u0004\u0018\u00010P2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010S\u001a\u0002072\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0018\u0010T\u001a\u00020\u001c2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0007H\u0016J\u0015\u0010V\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bXJ\u0010\u0010Y\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0010\u0010Z\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0015\u0010[\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\\J\u0018\u0010]\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0007H\u0016J\u0010\u0010_\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010`\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\u001cH\u0016J\u0010\u0010b\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0010\u0010c\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0012\u0010d\u001a\u0004\u0018\u00010\r2\u0006\u0010a\u001a\u00020\u001cH\u0002J\u0010\u0010e\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0010\u0010f\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0010\u0010g\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0010\u0010h\u001a\u00020\u001c2\u0006\u0010W\u001a\u00020\u0005H\u0016J\u001a\u0010i\u001a\u00020\u00052\u0006\u0010j\u001a\u00020kH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bl\u0010mJ\u0010\u0010n\u001a\u00020M2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0018\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020\u00052\u0006\u0010Q\u001a\u00020\u0005H\u0016J*\u0010r\u001a\u00020D2\u0006\u0010s\u001a\u0002072\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020wH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bx\u0010yJ\u001d\u0010z\u001a\u00020D2\u0006\u0010A\u001a\u00020\u0005H\u0016\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b{\u0010|J\u0010\u0010}\u001a\u00020\u00072\u0006\u0010W\u001a\u00020\u0005H\u0016J\u0012\u0010~\u001a\u0004\u0018\u00010\r2\u0006\u0010A\u001a\u00020\u0005H\u0002J_\u0010\u007f\u001a\u00020@2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0007\u0010\u0084\u0001\u001a\u00020\u001c2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0017\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008d\u0001\u0010\u008e\u0001J@\u0010\u007f\u001a\u00020@2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0091\u0001\u0010\u0092\u0001JV\u0010\u007f\u001a\u00020@2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001H\u0017\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0093\u0001\u0010\u0094\u0001J\u0014\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0002\u0010*R\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0019\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0014\u0010!\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010'R\u0014\u0010.\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001eR\u001e\u00102\u001a\u0002012\u0006\u00100\u001a\u000201@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b3\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u000107068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0096\u0001"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/compose/ui/unit/Constraints;", "(Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;IZJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "_lineMetrics", "", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "[Lorg/jetbrains/skia/paragraph/LineMetrics;", "getConstraints-msEJaDk", "()J", "J", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$ui_text", "()Lorg/jetbrains/skia/Font;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "ellipsisChar", "", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "lineCount", "getLineCount", "()I", "lineMetrics", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "minIntrinsicWidth", "getMinIntrinsicWidth", "value", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraph", "setParagraph", "(Lorg/jetbrains/skia/paragraph/Paragraph;)V", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "text", "getText", "()Ljava/lang/String;", "width", "getWidth", "checkOffsetIsValid", "", "offset", "fillBoundingBoxes", "range", "Landroidx/compose/ui/text/TextRange;", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getAlignedStartingPosition", "isRtl", "getBidiRunDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBoundingBox", "getBoxBackwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "end", "getBoxForwardByOffset", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineAscent", "lineIndex", "getLineAscent$ui_text", "getLineBaseline", "getLineBottom", "getLineDescent", "getLineDescent$ui_text", "getLineEnd", "visibleEnd", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineHeight", "getLineLeft", "getLineMetricsForVerticalPosition", "getLineRight", "getLineStart", "getLineTop", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getParagraphDirection", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "getRangeForRect", "rect", "granularity", "Landroidx/compose/ui/text/TextGranularity;", "inclusionStrategy", "Landroidx/compose/ui/text/TextInclusionStrategy;", "getRangeForRect-8-6BmAI", "(Landroidx/compose/ui/geometry/Rect;ILandroidx/compose/ui/text/TextInclusionStrategy;)J", "getWordBoundary", "getWordBoundary--jx7JFs", "(I)J", "isLineEllipsized", "lineMetricsForOffset", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "color", "Landroidx/compose/ui/graphics/Color;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "receiveLineMetrics", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSkiaParagraph.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph_skikoKt\n*L\n1#1,667:1\n582#1,4:673\n582#1,4:697\n582#1,4:701\n582#1,4:705\n1#2:668\n11065#3:669\n11400#3,3:670\n656#4,10:677\n656#4,10:687\n*S KotlinDebug\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n*L\n204#1:673,4\n311#1:697,4\n327#1:701,4\n481#1:705,4\n126#1:669\n126#1:670,3\n206#1:677,10\n250#1:687,10\n*E\n"})
public final class SkiaParagraph
implements Paragraph {
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final long constraints;
    @NotNull
    private final String ellipsisChar;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    @Nullable
    private LineMetrics[] _lineMetrics;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, boolean ellipsis, long constraints) {
        void $this$layouter_u24lambda_u240;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter(paragraphIntrinsics, "paragraphIntrinsics");
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.constraints = constraints;
        this.ellipsisChar = ellipsis ? "\u2026" : "";
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$layouter_u24lambda_u240.setParagraphStyle(this.maxLines, this.ellipsisChar);
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        this.layouter.setBrushSize-uvyYCjk(SizeKt.Size(this.getWidth(), this.getHeight()));
        this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        this.paragraph.layout(this.getWidth());
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    @NotNull
    public final Font getDefaultFont$ui_text() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph value) {
        this.paragraph = value;
        this._lineMetrics = null;
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl(this.constraints);
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = ArraysKt.firstOrNull(this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_firstBaseline__u24lambda_u241 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_firstBaseline__u24lambda_u241.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = ArraysKt.lastOrNull(this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_lastBaseline__u24lambda_u242 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_lastBaseline__u24lambda_u242.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual(this.getText(), "") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.paragraph.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect(it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start2, int end2) {
        TextBox[] boxes = this.paragraph.getRectsForRange(start2, end2, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path2 = SkiaBackedPath_skikoKt.Path();
        for (TextBox b : boxes) {
            Path.addRect$default(SkiaBackedPath_skikoKt.asSkiaPath(path2), b.getRect(), null, 0, 6, null);
        }
        return path2;
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset2) {
        double d;
        double d2;
        float horizontal = this.getHorizontalPosition(offset2, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset2);
        Intrinsics.checkNotNull(lineMetrics);
        LineMetrics line = lineMetrics;
        boolean isNewEmptyLine = offset2 - 1 == line.getStartIndex() && offset2 == this.getText().length();
        FontMetrics metrics2 = this.getDefaultFont$ui_text().getMetrics();
        double it = line.getAscent();
        boolean bl = false;
        if (isNewEmptyLine) {
            double ascent = -((double)metrics2.getAscent());
            d2 = RangesKt.coerceAtMost(it, ascent);
        } else {
            d2 = it;
        }
        double asc = d2;
        double it2 = line.getDescent();
        boolean bl2 = false;
        if (isNewEmptyLine) {
            double descent = metrics2.getDescent();
            d = RangesKt.coerceAtMost(it2, descent);
        } else {
            d = it2;
        }
        double desc = d;
        return new Rect(horizontal, (float)(line.getBaseline() - asc), horizontal, (float)(line.getBaseline() + desc));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final float getLineAscent$ui_text(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return -(lineMetrics != null ? (float)lineMetrics.getAscent() : 0.0f);
    }

    @Override
    public float getLineBaseline(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getBaseline() : 0.0f;
    }

    public final float getLineDescent$ui_text(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getDescent() : 0.0f;
    }

    private final LineMetrics lineMetricsForOffset(int offset2) {
        LineMetrics lineMetrics;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset2 ? offset2 <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset2 + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        LineMetrics[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            lineMetrics = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default(ArraysKt.asList($this$binarySearchFirstMatchingOrLast$iv), 0, 0, new Function1<LineMetrics, Integer>(offset2){
                final /* synthetic */ int $offset$inlined;
                {
                    this.$offset$inlined = n;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                @NotNull
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return this.$offset$inlined < it2.getEndIncludingNewline() ? 1 : -1;
                }
            }, 3, null);
            lineMetrics = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost(-index$iv - 1, ArraysKt.getLastIndex($this$binarySearchFirstMatchingOrLast$iv))];
        }
        return lineMetrics;
    }

    @Override
    public float getLineHeight(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public float getLineWidth(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getWidth() : 0.0f;
    }

    @Override
    public int getLineStart(int lineIndex) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        LineMetrics lineMetrics = ArraysKt.getOrNull(this.getLineMetrics(), lineIndex);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics metrics2 = lineMetrics;
        return visibleEnd ? (lineIndex > 0 && metrics2.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics2.getEndIndex() : (metrics2.getStartIndex() < this.getText().length() && this.getText().charAt(metrics2.getStartIndex()) == '\n' ? metrics2.getStartIndex() : metrics2.getEndExcludingWhitespaces())) : metrics2.getEndIndex();
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return false;
    }

    @Override
    public int getLineForOffset(int offset2) {
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset2);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(vertical);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float vertical) {
        LineMetrics lineMetrics;
        LineMetrics[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            lineMetrics = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default(ArraysKt.asList($this$binarySearchFirstMatchingOrLast$iv), 0, 0, new Function1<LineMetrics, Integer>(vertical){
                final /* synthetic */ float $vertical$inlined;
                {
                    this.$vertical$inlined = f;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                @NotNull
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return (double)this.$vertical$inlined < it2.getBaseline() + it2.getDescent() ? 1 : -1;
                }
            }, 3, null);
            lineMetrics = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost(-index$iv - 1, ArraysKt.getLastIndex($this$binarySearchFirstMatchingOrLast$iv))];
        }
        return lineMetrics;
    }

    @Override
    public float getHorizontalPosition(int offset2, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset2, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset2);
        boolean isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean isLtr = !isRtl;
        if (prevBox == null && nextBox == null) {
            f = this.getAlignedStartingPosition(isRtl);
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull(textBox);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isLtr && prevBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isRtl && prevBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)))));
        }
        return f;
    }

    private final float getAlignedStartingPosition(boolean isRtl) {
        int n = this.layouter.getTextStyle().getTextAlign-e0LSkKk();
        return TextAlign.equals-impl0(n, TextAlign.Companion.getLeft-e0LSkKk()) ? 0.0f : (TextAlign.equals-impl0(n, TextAlign.Companion.getRight-e0LSkKk()) ? this.getWidth() : (TextAlign.equals-impl0(n, TextAlign.Companion.getCenter-e0LSkKk()) ? this.getWidth() / (float)2 : (TextAlign.equals-impl0(n, TextAlign.Companion.getStart-e0LSkKk()) ? (isRtl ? this.getWidth() : 0.0f) : (TextAlign.equals-impl0(n, TextAlign.Companion.getEnd-e0LSkKk()) ? (isRtl ? 0.0f : this.getWidth()) : 0.0f))));
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray = this._lineMetrics;
        if (this._lineMetrics == null) {
            LineMetrics[] lineMetricsArray2;
            LineMetrics[] it = lineMetricsArray2 = this.receiveLineMetrics();
            boolean bl = false;
            this._lineMetrics = it;
            lineMetricsArray = lineMetricsArray2;
        }
        LineMetrics[] lineMetrics = lineMetricsArray;
        return lineMetrics;
    }

    private final LineMetrics[] receiveLineMetrics() {
        LineMetrics[] lineMetrics = ((CharSequence)this.getText()).length() == 0 ? this.layouter.emptyLineMetrics$ui_text(this.paragraph) : this.paragraph.getLineMetrics();
        FontMetrics fontMetrics2 = this.getDefaultFont$ui_text().getMetrics();
        if (!(lineMetrics.length == 0)) {
            lineMetrics[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetrics[0], fontMetrics2, this.layouter.getTextStyle());
            lineMetrics[lineMetrics.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetrics[lineMetrics.length - 1], fontMetrics2, this.layouter.getTextStyle());
        }
        return lineMetrics;
    }

    private final TextBox getBoxForwardByOffset(int offset2) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset2 ? offset2 <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset2 + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
        for (int to = offset2 + 1; to <= this.getText().length(); ++to) {
            TextBox box = ArraysKt.firstOrNull(this.paragraph.getRectsForRange(offset2, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset2, int end2) {
        boolean isRtl;
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset2 ? offset2 <= this_$iv.getText().length() : false)) {
            boolean $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = false;
            String $i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22 = "Invalid offset: " + offset2 + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException($i$a$-require-SkiaParagraph$checkOffsetIsValid$1$iv22.toString());
        }
        boolean bl = isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int from = offset2 - 1; from >= 0; --from) {
            TextBox box = ArraysKt.firstOrNull(this.paragraph.getRectsForRange(from, end2, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from) == '\n') {
                TextBox textBox;
                if (!isRtl) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect2 = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                    return new TextBox(rect2, box.getDirection());
                }
                if (from == StringsKt.getLastIndex(this.getText())) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect3 = new org.jetbrains.skia.Rect(this.getWidth(), box.getRect().getBottom(), this.getWidth(), bottom);
                    textBox = new TextBox(rect3, box.getDirection());
                } else {
                    TextBox nextBox = ArraysKt.first(this.paragraph.getRectsForRange(offset2, offset2 + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect4 = new org.jetbrains.skia.Rect(nextBox.getRect().getLeft(), nextBox.getRect().getTop(), nextBox.getRect().getLeft(), nextBox.getRect().getBottom());
                    textBox = new TextBox(rect4, nextBox.getDirection());
                }
                return textBox;
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset2) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset2) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(offset2);
        Direction direction = textBox != null ? textBox.getDirection() : null;
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long position) {
        float rightX;
        boolean isNotEmptyLine;
        int glyphPosition = this.paragraph.getGlyphPositionAtCoordinate(Offset.getX-impl(position), Offset.getY-impl(position)).getPosition();
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Offset.getY-impl(position));
        if (lineMetrics == null) {
            return glyphPosition;
        }
        LineMetrics expectedLine = lineMetrics;
        boolean bl = isNotEmptyLine = expectedLine.getStartIndex() < expectedLine.getEndIndex();
        if ((double)Offset.getX-impl(position) > expectedLine.getLeft() && (double)Offset.getX-impl(position) < expectedLine.getRight()) {
            return glyphPosition;
        }
        TextBox[] rects = isNotEmptyLine ? this.paragraph.getRectsForRange(expectedLine.getStartIndex(), expectedLine.isHardBreak() ? expectedLine.getEndIndex() : expectedLine.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null;
        Object object = rects;
        float leftX = rects != null && (object = (TextBox[])ArraysKt.firstOrNull(object)) != null && (object = ((TextBox)object).getRect()) != null ? ((org.jetbrains.skia.Rect)object).getLeft() : (float)expectedLine.getLeft();
        Object object2 = rects;
        float f = rightX = rects != null && (object2 = ArraysKt.lastOrNull(object2)) != null && (object2 = ((TextBox)object2).getRect()) != null ? ((org.jetbrains.skia.Rect)object2).getRight() : (float)expectedLine.getRight();
        if (leftX == rightX) {
            return glyphPosition;
        }
        int correctedGlyphPosition = glyphPosition;
        if (Offset.getX-impl(position) <= leftX) {
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(leftX + 1.0f, Offset.getY-impl(position)).getPosition();
        } else if (Offset.getX-impl(position) >= rightX) {
            boolean isNeutralChar;
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(rightX - 1.0f, Offset.getY-impl(position)).getPosition();
            boolean bl2 = isNeutralChar = (0 <= correctedGlyphPosition ? correctedGlyphPosition < this.getText().length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), correctedGlyphPosition)) : false;
            if (!isNeutralChar) {
                TextBox textBox = SkiaParagraph.getBoxBackwardByOffset$default(this, correctedGlyphPosition, 0, 2, null);
                if ((textBox != null ? textBox.getDirection() : null) == Direction.RTL) {
                    --correctedGlyphPosition;
                }
            }
        }
        return correctedGlyphPosition;
    }

    @Override
    public long getRangeForRect-8-6BmAI(@NotNull Rect rect2, int granularity, @NotNull TextInclusionStrategy inclusionStrategy) {
        Intrinsics.checkNotNullParameter(rect2, "rect");
        Intrinsics.checkNotNullParameter(inclusionStrategy, "inclusionStrategy");
        return TextRange.Companion.getZero-d9O1mEE();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset2) {
        TextBox textBox = this.getBoxForwardByOffset(offset2);
        if (textBox == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(offset2, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull(textBox2);
        }
        TextBox box = textBox;
        return Rects_skikoKt.toComposeRect(box.getRect());
    }

    @Override
    public void fillBoundingBoxes-8ffj60Q(long range, @NotNull float[] array, int arrayStart) {
        Intrinsics.checkNotNullParameter(array, "array");
        System.out.println((Object)"Compose Multiplatform doesn't support fillBoundingBoxes` yet. Follow https://github.com/JetBrains/compose-multiplatform/issues/4236");
    }

    @Override
    public long getWordBoundary--jx7JFs(int offset2) {
        SkiaParagraph this_$iv = this;
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset2 ? offset2 <= this_$iv.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset2 + ". Valid range is [0, " + this_$iv.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
        if (offset2 < this.getText().length() && CharsKt.isWhitespace(this.getText().charAt(offset2)) || offset2 == this.getText().length()) {
            return offset2 > 0 && !CharsKt.isWhitespace(this.getText().charAt(offset2 - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset2 - 1)) : TextRangeKt.TextRange(offset2, offset2);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long color2, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        void $this$paint_RPmYEkk_u24lambda_u2411;
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_RPmYEkk_u24lambda_u2411.setColor-8_81llA(color2);
        $this$paint_RPmYEkk_u24lambda_u2411.setTextStyle(shadow, textDecoration);
        skiaParagraph.setParagraph($this$paint_RPmYEkk_u24lambda_u2411.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-LG529CI(@NotNull Canvas canvas, long color2, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_LG529CI_u24lambda_u2412;
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u2412.setColor-8_81llA(color2);
        $this$paint_LG529CI_u24lambda_u2412.setTextStyle(shadow, textDecoration);
        $this$paint_LG529CI_u24lambda_u2412.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u2412.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_LG529CI_u24lambda_u2412.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha2, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int blendMode) {
        void $this$paint_hn5TExg_u24lambda_u2413;
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        Intrinsics.checkNotNullParameter(brush, "brush");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_hn5TExg_u24lambda_u2413.setBrush-12SF9DM(brush, SizeKt.Size(this.getWidth(), this.getHeight()), alpha2);
        $this$paint_hn5TExg_u24lambda_u2413.setTextStyle(shadow, textDecoration);
        $this$paint_hn5TExg_u24lambda_u2413.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u2413.setBlendMode-s9anfk8(blendMode);
        skiaParagraph.setParagraph($this$paint_hn5TExg_u24lambda_u2413.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int offset2) {
        boolean $i$f$checkOffsetIsValid = false;
        if (!(0 <= offset2 ? offset2 <= this.getText().length() : false)) {
            boolean bl = false;
            String string = "Invalid offset: " + offset2 + ". Valid range is [0, " + this.getText().length() + ']';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, boolean ellipsis, long constraints, DefaultConstructorMarker $constructor_marker) {
        this(paragraphIntrinsics, maxLines, ellipsis, constraints);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

