/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Fill;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.SpanStyle;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextForegroundStyle;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/compose/ui/text/TextPainter;", "", "()V", "paint", "", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "ui-text"})
@StabilityInferred(parameters=1)
public final class TextPainter {
    @NotNull
    public static final TextPainter INSTANCE = new TextPainter();
    public static final int $stable;

    private TextPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        DrawStyle drawStyle;
        Shadow shadow;
        Shadow shadow2;
        TextDecoration textDecoration;
        SpanStyle style;
        TextDecoration textDecoration2;
        boolean needClipping;
        Intrinsics.checkNotNullParameter(canvas, "canvas");
        Intrinsics.checkNotNullParameter(textLayoutResult, "textLayoutResult");
        boolean bl = needClipping = textLayoutResult.getHasVisualOverflow() && !TextOverflow.equals-impl0(textLayoutResult.getLayoutInput().getOverflow-gIe3tQ8(), TextOverflow.Companion.getVisible-gIe3tQ8());
        if (needClipping) {
            float width2 = IntSize.getWidth-impl(textLayoutResult.getSize-YbymL2g());
            float height2 = IntSize.getHeight-impl(textLayoutResult.getSize-YbymL2g());
            Rect bounds2 = RectKt.Rect-tz77jQw(Offset.Companion.getZero-F1C5BW0(), SizeKt.Size(width2, height2));
            canvas.save();
            Canvas.clipRect-mtrdD-E$default(canvas, bounds2, 0, 2, null);
        }
        if ((textDecoration2 = (style = textLayoutResult.getLayoutInput().getStyle().getSpanStyle$ui_text()).getTextDecoration()) == null) {
            textDecoration2 = textDecoration = TextDecoration.Companion.getNone();
        }
        if ((shadow2 = style.getShadow()) == null) {
            shadow2 = shadow = Shadow.Companion.getNone();
        }
        if ((drawStyle = style.getDrawStyle()) == null) {
            drawStyle = Fill.INSTANCE;
        }
        DrawStyle drawStyle2 = drawStyle;
        try {
            Brush brush = style.getBrush();
            if (brush != null) {
                float alpha2 = style.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? style.getTextForegroundStyle$ui_text().getAlpha() : 1.0f;
                MultiParagraph.paint-hn5TExg$default(textLayoutResult.getMultiParagraph(), canvas, brush, alpha2, shadow, textDecoration, drawStyle2, 0, 64, null);
            } else {
                long color2 = style.getTextForegroundStyle$ui_text() != TextForegroundStyle.Unspecified.INSTANCE ? style.getTextForegroundStyle$ui_text().getColor-0d7_KjU() : Color.Companion.getBlack-0d7_KjU();
                MultiParagraph.paint-LG529CI$default(textLayoutResult.getMultiParagraph(), canvas, color2, shadow, textDecoration, drawStyle2, 0, 32, null);
            }
        }
        finally {
            if (needClipping) {
                canvas.restore();
            }
        }
    }
}

