/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.InternalTextApi;
import androidx.compose.ui.text.input.GapBuffer;
import androidx.compose.ui.text.input.GapBufferKt;
import androidx.compose.ui.text.input.GapBuffer_jvmKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0086\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer;", "", "text", "", "(Ljava/lang/String;)V", "bufEnd", "", "bufStart", "buffer", "Landroidx/compose/ui/text/input/GapBuffer;", "length", "getLength", "()I", "getText", "()Ljava/lang/String;", "setText", "get", "", "index", "replace", "", "start", "end", "toString", "Companion", "ui-text"})
@InternalTextApi
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class PartialGapBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String text;
    @Nullable
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int $stable = 8;
    public static final int BUF_SIZE = 255;
    public static final int SURROUNDING_SIZE = 64;
    public static final int NOWHERE = -1;

    public PartialGapBuffer(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this.text = text2;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.text = string;
    }

    public final int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.length();
        }
        GapBuffer buffer2 = gapBuffer;
        return this.text.length() - (this.bufEnd - this.bufStart) + buffer2.length();
    }

    public final void replace(int start2, int end2, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        if (!(start2 <= end2)) {
            boolean $i$a$-require-PartialGapBuffer$replace$32 = false;
            String $i$a$-require-PartialGapBuffer$replace$32 = "start index must be less than or equal to end index: " + start2 + " > " + end2;
            throw new IllegalArgumentException($i$a$-require-PartialGapBuffer$replace$32.toString());
        }
        if (!(start2 >= 0)) {
            boolean $i$a$-require-PartialGapBuffer$replace$42 = false;
            String $i$a$-require-PartialGapBuffer$replace$42 = "start must be non-negative, but was " + start2;
            throw new IllegalArgumentException($i$a$-require-PartialGapBuffer$replace$42.toString());
        }
        GapBuffer buffer2 = this.buffer;
        if (buffer2 == null) {
            char[] charArray = new char[Math.max(255, text2.length() + 128)];
            int leftCopyCount = Math.min(start2, 64);
            int rightCopyCount = Math.min(this.text.length() - end2, 64);
            GapBuffer_jvmKt.toCharArray(this.text, charArray, 0, start2 - leftCopyCount, start2);
            GapBuffer_jvmKt.toCharArray(this.text, charArray, charArray.length - rightCopyCount, end2, end2 + rightCopyCount);
            GapBufferKt.access$toCharArray(text2, charArray, leftCopyCount);
            this.buffer = new GapBuffer(charArray, leftCopyCount + text2.length(), charArray.length - rightCopyCount);
            this.bufStart = start2 - leftCopyCount;
            this.bufEnd = end2 + rightCopyCount;
            return;
        }
        int bufferStart = start2 - this.bufStart;
        int bufferEnd = end2 - this.bufStart;
        if (bufferStart < 0 || bufferEnd > buffer2.length()) {
            this.text = this.toString();
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(start2, end2, text2);
            return;
        }
        buffer2.replace(bufferStart, bufferEnd, text2);
    }

    public final char get(int index2) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text.charAt(index2);
        }
        GapBuffer buffer2 = gapBuffer;
        if (index2 < this.bufStart) {
            return this.text.charAt(index2);
        }
        int gapBufLength = buffer2.length();
        if (index2 < gapBufLength + this.bufStart) {
            return buffer2.get(index2 - this.bufStart);
        }
        return this.text.charAt(index2 - (gapBufLength - this.bufEnd + this.bufStart));
    }

    @NotNull
    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.text;
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.text, 0, this.bufStart);
        b.append(sb);
        sb.append(this.text, this.bufEnd, this.text.length());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/compose/ui/text/input/PartialGapBuffer$Companion;", "", "()V", "BUF_SIZE", "", "NOWHERE", "SURROUNDING_SIZE", "ui-text"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

