/*
 * Decompiled with CFR 0.152.
 */
package com.eygraber.uri;

import com.eygraber.uri.UriSyntaxException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J&\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J*\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u001a\u0010!\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0002J*\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J!\u0010%\u001a\u00020&*\u00020'2\n\u0010(\u001a\u00060)j\u0002`*2\u0006\u0010\u0014\u001a\u00020\u0013H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/eygraber/uri/UriCodec;", "", "()V", "INVALID_INPUT_CHARACTER", "", "defaultAllowedSet", "", "digitAsciiRange", "Lkotlin/ranges/CharRange;", "hexDigits", "", "lowercaseAsciiAlphaRange", "lowercaseHexRange", "uppercaseAsciiAlphaRange", "uppercaseHexRange", "decode", "", "s", "convertPlus", "", "throwOnFailure", "decodeOrNull", "encode", "allow", "encodeOrNull", "getNextCharacter", "uri", "index", "", "end", "name", "hexCharToValue", "c", "isAllowed", "unexpectedCharacterException", "Lcom/eygraber/uri/UriSyntaxException;", "unexpected", "flushDecodingByteAccumulator", "", "Lcom/eygraber/uri/UriCodec$ByteBuffer;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ByteBuffer"})
@SourceDebugExtension(value={"SMAP\nUriCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriCodec.kt\ncom/eygraber/uri/UriCodec\n*L\n1#1,356:1\n291#1,14:357\n291#1,14:371\n291#1,14:385\n291#1,14:399\n291#1,14:413\n*S KotlinDebug\n*F\n+ 1 UriCodec.kt\ncom/eygraber/uri/UriCodec\n*L\n208#1:357,14\n225#1:371,14\n239#1:385,14\n250#1:399,14\n256#1:413,14\n*E\n"})
public final class UriCodec {
    @NotNull
    public static final UriCodec INSTANCE = new UriCodec();
    @NotNull
    private static final CharRange lowercaseAsciiAlphaRange = new CharRange('a', 'z');
    @NotNull
    private static final CharRange lowercaseHexRange = new CharRange('a', 'f');
    @NotNull
    private static final CharRange uppercaseAsciiAlphaRange = new CharRange('A', 'Z');
    @NotNull
    private static final CharRange uppercaseHexRange = new CharRange('A', 'F');
    @NotNull
    private static final CharRange digitAsciiRange = new CharRange('0', '9');
    @NotNull
    private static final Set<Character> defaultAllowedSet;
    @NotNull
    private static final char[] hexDigits;
    private static final char INVALID_INPUT_CHARACTER = '\ufffd';

    private UriCodec() {
    }

    @Nullable
    public final String encodeOrNull(@Nullable String s2) {
        String string = s2;
        return string == null ? null : this.encode(string, null);
    }

    @Nullable
    public final String encodeOrNull(@Nullable String s2, @Nullable String allow) {
        String string = s2;
        return string == null ? null : this.encode(string, allow);
    }

    @NotNull
    public final String encode(@NotNull String s2) {
        Intrinsics.checkNotNullParameter(s2, "s");
        return this.encode(s2, null);
    }

    @NotNull
    public final String encode(@NotNull String s2, @Nullable String allow) {
        Intrinsics.checkNotNullParameter(s2, "s");
        StringBuilder encoded = null;
        int oldLength = s2.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && this.isAllowed(s2.charAt(nextToEncode), allow); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                String string;
                if (current == 0) {
                    string = s2;
                } else {
                    StringBuilder stringBuilder = encoded;
                    Intrinsics.checkNotNull(stringBuilder);
                    stringBuilder.append(s2, current, oldLength);
                    String string2 = encoded.toString();
                    Intrinsics.checkNotNull(string2);
                    string = string2;
                }
                return string;
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s2, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !this.isAllowed(s2.charAt(nextAllowed), allow); ++nextAllowed) {
            }
            Intrinsics.checkNotNullExpressionValue(s2.substring(current, nextAllowed), "this as java.lang.String\u2026ing(startIndex, endIndex)");
            try {
                String toEncode;
                byte[] bytes = StringsKt.encodeToByteArray(toEncode);
                int bytesLength = bytes.length;
                for (int i = 0; i < bytesLength; ++i) {
                    encoded.append('%');
                    encoded.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
                    encoded.append(hexDigits[bytes[i] & 0xF]);
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            current = nextAllowed;
        }
        StringsKt.decodeToString(new byte[0]);
        StringBuilder stringBuilder = encoded;
        String string = stringBuilder != null ? stringBuilder.toString() : null;
        if (string == null) {
            string = s2;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAllowed(char c, String allow) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        CharRange charRange = lowercaseAsciiAlphaRange;
        char c2 = charRange.getFirst();
        if (c <= charRange.getLast()) {
            if (c2 <= c) {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        charRange = uppercaseAsciiAlphaRange;
        c2 = charRange.getFirst();
        if (c <= charRange.getLast()) {
            if (c2 <= c) {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        charRange = digitAsciiRange;
        c2 = charRange.getFirst();
        if (c <= charRange.getLast()) {
            if (c2 <= c) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (defaultAllowedSet.contains(Character.valueOf(c))) return true;
        if (allow == null) return false;
        if (StringsKt.indexOf$default((CharSequence)allow, c, 0, false, 6, null) == -1) return false;
        return true;
    }

    @Nullable
    public final String decodeOrNull(@Nullable String s2, boolean convertPlus, boolean throwOnFailure) {
        String string = s2;
        return string == null ? null : this.decode(string, convertPlus, throwOnFailure);
    }

    public static /* synthetic */ String decodeOrNull$default(UriCodec uriCodec, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return uriCodec.decodeOrNull(string, bl, bl2);
    }

    @NotNull
    public final String decode(@NotNull String s2, boolean convertPlus, boolean throwOnFailure) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(s2, "s");
        StringBuilder builder = new StringBuilder(s2.length());
        ByteBuffer $this$decode_u24lambda_u240 = byteBuffer = new ByteBuffer(s2.length());
        boolean bl = false;
        int i = 0;
        while (i < s2.length()) {
            boolean $i$f$flushDecodingByteAccumulator;
            ByteBuffer $this$flushDecodingByteAccumulator$iv;
            char c;
            if ((c = s2.charAt(i++)) == '+') {
                UriCodec uriCodec = INSTANCE;
                $this$flushDecodingByteAccumulator$iv = $this$decode_u24lambda_u240;
                $i$f$flushDecodingByteAccumulator = false;
                if ($this$flushDecodingByteAccumulator$iv.getWritePosition() != 0) {
                    try {
                        builder.append($this$flushDecodingByteAccumulator$iv.decodeToStringAndReset());
                    }
                    catch (Exception e$iv) {
                        if (throwOnFailure) {
                            throw new IllegalArgumentException(e$iv);
                        }
                        builder.append('\ufffd');
                    }
                }
                builder.append(convertPlus ? (char)' ' : '+');
                continue;
            }
            if (c == '%') {
                byte hexValue = 0;
                for (int j = 0; j < 2; ++j) {
                    char e$iv;
                    try {
                        e$iv = INSTANCE.getNextCharacter(s2, i, s2.length(), null);
                    }
                    catch (UriSyntaxException e) {
                        if (throwOnFailure) {
                            throw new IllegalArgumentException(e);
                        }
                        UriCodec uriCodec = INSTANCE;
                        ByteBuffer $this$flushDecodingByteAccumulator$iv2 = $this$decode_u24lambda_u240;
                        boolean $i$f$flushDecodingByteAccumulator2 = false;
                        if ($this$flushDecodingByteAccumulator$iv2.getWritePosition() != 0) {
                            try {
                                builder.append($this$flushDecodingByteAccumulator$iv2.decodeToStringAndReset());
                            }
                            catch (Exception e$iv2) {
                                if (throwOnFailure) {
                                    throw new IllegalArgumentException(e$iv2);
                                }
                                builder.append('\ufffd');
                            }
                        }
                        builder.append('\ufffd');
                        String string = builder.toString();
                        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                        return string;
                    }
                    char nextC = e$iv;
                    ++i;
                    int newDigit = INSTANCE.hexCharToValue(nextC);
                    if (newDigit < 0) {
                        if (throwOnFailure) {
                            throw new IllegalArgumentException(INSTANCE.unexpectedCharacterException(s2, null, nextC, i - 1));
                        }
                        UriCodec e = INSTANCE;
                        ByteBuffer $this$flushDecodingByteAccumulator$iv3 = $this$decode_u24lambda_u240;
                        boolean $i$f$flushDecodingByteAccumulator3 = false;
                        if ($this$flushDecodingByteAccumulator$iv3.getWritePosition() != 0) {
                            try {
                                builder.append($this$flushDecodingByteAccumulator$iv3.decodeToStringAndReset());
                            }
                            catch (Exception e$iv3) {
                                if (throwOnFailure) {
                                    throw new IllegalArgumentException(e$iv3);
                                }
                                builder.append('\ufffd');
                            }
                        }
                        builder.append('\ufffd');
                        break;
                    }
                    hexValue = (byte)(hexValue * 16 + newDigit);
                }
                $this$decode_u24lambda_u240.writeByte(hexValue);
                continue;
            }
            UriCodec hexValue = INSTANCE;
            $this$flushDecodingByteAccumulator$iv = $this$decode_u24lambda_u240;
            $i$f$flushDecodingByteAccumulator = false;
            if ($this$flushDecodingByteAccumulator$iv.getWritePosition() != 0) {
                try {
                    builder.append($this$flushDecodingByteAccumulator$iv.decodeToStringAndReset());
                }
                catch (Exception e$iv) {
                    if (throwOnFailure) {
                        throw new IllegalArgumentException(e$iv);
                    }
                    builder.append('\ufffd');
                }
            }
            builder.append(c);
        }
        UriCodec c = INSTANCE;
        ByteBuffer $this$flushDecodingByteAccumulator$iv = $this$decode_u24lambda_u240;
        boolean $i$f$flushDecodingByteAccumulator = false;
        if ($this$flushDecodingByteAccumulator$iv.getWritePosition() != 0) {
            try {
                builder.append($this$flushDecodingByteAccumulator$iv.decodeToStringAndReset());
            }
            catch (Exception e$iv) {
                if (throwOnFailure) {
                    throw new IllegalArgumentException(e$iv);
                }
                builder.append('\ufffd');
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String decode$default(UriCodec uriCodec, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return uriCodec.decode(string, bl, bl2);
    }

    private final void flushDecodingByteAccumulator(ByteBuffer $this$flushDecodingByteAccumulator, StringBuilder builder, boolean throwOnFailure) {
        boolean $i$f$flushDecodingByteAccumulator = false;
        if ($this$flushDecodingByteAccumulator.getWritePosition() == 0) {
            return;
        }
        try {
            builder.append($this$flushDecodingByteAccumulator.decodeToStringAndReset());
        }
        catch (Exception e) {
            if (throwOnFailure) {
                throw new IllegalArgumentException(e);
            }
            builder.append('\ufffd');
        }
    }

    private final UriSyntaxException unexpectedCharacterException(String uri, String name, char unexpected, int index2) {
        String string = name;
        Object nameString = string == null ? "" : " in [" + string + "]";
        return new UriSyntaxException(uri, "Unexpected character" + (String)nameString + ": " + unexpected, index2);
    }

    private final char getNextCharacter(String uri, int index2, int end2, String name) {
        if (index2 >= end2) {
            String string = name;
            Object nameString = string == null ? "" : " in [" + string + "]";
            throw new UriSyntaxException(uri, "Unexpected end of string " + (String)nameString, index2);
        }
        return uri.charAt(index2);
    }

    private final int hexCharToValue(char c) {
        int n;
        char c2 = c;
        CharRange charRange = digitAsciiRange;
        char c3 = charRange.getFirst();
        boolean bl = c2 <= charRange.getLast() ? c3 <= c2 : false;
        if (bl) {
            n = c - 48;
        } else {
            charRange = lowercaseHexRange;
            c3 = charRange.getFirst();
            boolean bl2 = c2 <= charRange.getLast() ? c3 <= c2 : false;
            if (bl2) {
                n = 10 + c - 97;
            } else {
                charRange = uppercaseHexRange;
                c3 = charRange.getFirst();
                n = (c2 <= charRange.getLast() ? c3 <= c2 : false) ? 10 + c - 65 : -1;
            }
        }
        return n;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('.'), Character.valueOf('~'), Character.valueOf('\''), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*')};
        defaultAllowedSet = SetsKt.setOf(objectArray);
        objectArray = new char[16];
        objectArray[0] = (Character)48;
        objectArray[1] = (Character)49;
        objectArray[2] = (Character)50;
        objectArray[3] = (Character)51;
        objectArray[4] = (Character)52;
        objectArray[5] = (Character)53;
        objectArray[6] = (Character)54;
        objectArray[7] = (Character)55;
        objectArray[8] = (Character)56;
        objectArray[9] = (Character)57;
        objectArray[10] = (Character)65;
        objectArray[11] = (Character)66;
        objectArray[12] = (Character)67;
        objectArray[13] = (Character)68;
        objectArray[14] = (Character)69;
        objectArray[15] = (Character)70;
        hexDigits = objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/eygraber/uri/UriCodec$ByteBuffer;", "", "size", "", "(I)V", "buffer", "", "getBuffer", "()[B", "buffer$delegate", "Lkotlin/Lazy;", "<set-?>", "writePosition", "getWritePosition", "()I", "decodeToStringAndReset", "", "writeByte", "", "byte", "", "uri"})
    private static final class ByteBuffer {
        private final int size;
        @NotNull
        private final Lazy buffer$delegate;
        private int writePosition;

        public ByteBuffer(int size2) {
            this.size = size2;
            this.buffer$delegate = LazyKt.lazy((Function0)new Function0<byte[]>(this){
                final /* synthetic */ ByteBuffer this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final byte[] invoke() {
                    int n = 0;
                    int n2 = ByteBuffer.access$getSize$p(this.this$0);
                    byte[] byArray = new byte[n2];
                    while (n < n2) {
                        int n3 = n++;
                        byArray[n3] = 0;
                    }
                    return byArray;
                }
            });
        }

        private final byte[] getBuffer() {
            Lazy lazy = this.buffer$delegate;
            return (byte[])lazy.getValue();
        }

        public final int getWritePosition() {
            return this.writePosition;
        }

        public final void writeByte(byte by) {
            int n = this.writePosition;
            this.writePosition = n + 1;
            this.getBuffer()[n] = by;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String decodeToStringAndReset() {
            String string;
            try {
                string = StringsKt.decodeToString(this.getBuffer(), 0, this.writePosition, false);
            }
            finally {
                this.writePosition = 0;
            }
            return string;
        }

        public static final /* synthetic */ int access$getSize$p(ByteBuffer $this) {
            return $this.size;
        }
    }
}

