/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectCountHashMap;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true, serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final RegularImmutableMultiset<Object> EMPTY = new RegularImmutableMultiset(ObjectCountHashMap.create());
    final transient ObjectCountHashMap<E> contents;
    private final transient int size;
    @LazyInit
    @CheckForNull
    private transient ImmutableSet<E> elementSet;

    RegularImmutableMultiset(ObjectCountHashMap<E> contents) {
        this.contents = contents;
        long size2 = 0L;
        for (int i = 0; i < contents.size(); ++i) {
            size2 += (long)contents.getValue(i);
        }
        this.size = Ints.saturatedCast(size2);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@CheckForNull Object element) {
        return this.contents.get(element);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ElementSet result2 = this.elementSet;
        return result2 == null ? (this.elementSet = new ElementSet()) : result2;
    }

    @Override
    Multiset.Entry<E> getEntry(int index2) {
        return this.contents.getEntry(index2);
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm(this);
    }

    @GwtIncompatible
    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        final int[] counts;
        private static final long serialVersionUID = 0L;

        SerializedForm(Multiset<? extends Object> multiset) {
            int distinct2 = multiset.entrySet().size();
            this.elements = new Object[distinct2];
            this.counts = new int[distinct2];
            int i = 0;
            for (Multiset.Entry<? extends Object> entry2 : multiset.entrySet()) {
                this.elements[i] = entry2.getElement();
                this.counts[i] = entry2.getCount();
                ++i;
            }
        }

        Object readResolve() {
            ImmutableMultiset.Builder<Object> builder = new ImmutableMultiset.Builder<Object>(this.elements.length);
            for (int i = 0; i < this.elements.length; ++i) {
                builder.addCopies(this.elements[i], this.counts[i]);
            }
            return builder.build();
        }
    }

    private final class ElementSet
    extends IndexedImmutableSet<E> {
        private ElementSet() {
        }

        @Override
        E get(int index2) {
            return RegularImmutableMultiset.this.contents.getKey(index2);
        }

        @Override
        public boolean contains(@CheckForNull Object object) {
            return RegularImmutableMultiset.this.contains(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return RegularImmutableMultiset.this.contents.size();
        }
    }
}

