/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.disk.DiskLruCache;
import com.seiko.imageloader.cache.disk.FaultHidingSink;
import com.seiko.imageloader.util.FileSystemKt;
import com.seiko.imageloader.util.LruHashMap;
import com.seiko.imageloader.util.LruHashMapKt;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014*\u0001\u0013\b\u0000\u0018\u0000 D2\u00060\u0001j\u0002`\u0002:\u0004DEFGB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0016J\u001c\u0010*\u001a\u00020(2\n\u0010+\u001a\u00060,R\u00020\u00002\u0006\u0010-\u001a\u00020\u0012H\u0002J\b\u0010.\u001a\u00020(H\u0002J\u0014\u0010/\u001a\b\u0018\u00010,R\u00020\u00002\u0006\u00100\u001a\u00020\u001eJ\u0006\u00101\u001a\u00020(J\u0006\u00102\u001a\u00020(J\u0017\u00103\u001a\b\u0018\u000104R\u00020\u00002\u0006\u00100\u001a\u00020\u001eH\u0086\u0002J\u0006\u00105\u001a\u00020(J\b\u00106\u001a\u00020\u0012H\u0002J\b\u00107\u001a\u00020(H\u0002J\b\u00108\u001a\u00020\u001bH\u0002J\b\u00109\u001a\u00020(H\u0002J\b\u0010:\u001a\u00020(H\u0002J\u0010\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020\u001eH\u0002J\u000e\u0010=\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u001eJ\u0014\u0010>\u001a\u00020\u00122\n\u0010?\u001a\u00060\u001fR\u00020\u0000H\u0002J\b\u0010@\u001a\u00020\u0012H\u0002J\u0006\u0010#\u001a\u00020\nJ\b\u0010A\u001a\u00020(H\u0002J\u0010\u0010B\u001a\u00020(2\u0006\u00100\u001a\u00020\u001eH\u0002J\b\u0010C\u001a\u00020(H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\b\u0012\u00060\u001fR\u00020\u00000\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00060%j\u0002`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "Ljava/io/Closeable;", "Lokio/Closeable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "cleanupDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "maxSize", "", "appVersion", "", "valueCount", "(Lokio/FileSystem;Lokio/Path;Lkotlinx/coroutines/CoroutineDispatcher;JII)V", "cleanupScope", "Lkotlinx/coroutines/CoroutineScope;", "closed", "", "com/seiko/imageloader/cache/disk/DiskLruCache$fileSystem$1", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$fileSystem$1;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Lcom/seiko/imageloader/util/LruHashMap;", "", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "mostRecentRebuildFailed", "mostRecentTrimFailed", "operationsSinceRewrite", "size", "syncObject", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "checkNotClosed", "", "close", "completeEdit", "editor", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "success", "delete", "edit", "key", "evictAll", "flush", "get", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "initialize", "journalRewriteRequired", "launchCleanup", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "remove", "removeEntry", "entry", "removeOldestEntry", "trimToSize", "validateKey", "writeJournal", "Companion", "Editor", "Entry", "Snapshot", "image-loader"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,852:1\n1#2:853\n28#3,4:854\n28#3,4:881\n28#3,4:921\n28#3,4:926\n28#3,4:931\n28#3,4:936\n28#3,4:941\n28#3,4:946\n28#3,4:953\n28#3,4:958\n20#4:858\n20#4:885\n20#4:925\n20#4:930\n20#4:935\n20#4:940\n20#4:945\n20#4:950\n20#4:957\n20#4:962\n66#5:859\n52#5,5:861\n60#5,10:867\n57#5,2:877\n71#5,2:879\n52#5,5:889\n60#5,10:895\n57#5,16:905\n67#6:860\n68#6:866\n80#6:886\n165#6:887\n81#6:888\n82#6:894\n37#7,2:951\n37#7,2:963\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache\n*L\n152#1:854,4\n308#1:881,4\n352#1:921,4\n375#1:926,4\n426#1:931,4\n431#1:936,4\n507#1:941,4\n563#1:946,4\n582#1:953,4\n621#1:958,4\n152#1:858\n308#1:885\n352#1:925\n375#1:930\n426#1:935\n431#1:940\n507#1:945\n563#1:950\n582#1:957\n621#1:962\n197#1:859\n197#1:861,5\n197#1:867,10\n197#1:877,2\n197#1:879,2\n311#1:889,5\n311#1:895,10\n311#1:905,16\n197#1:860\n197#1:866\n311#1:886\n311#1:887\n311#1:888\n311#1:894\n570#1:951,2\n624#1:963,2\n*E\n"})
public final class DiskLruCache
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    @NotNull
    private final Path journalFile;
    @NotNull
    private final Path journalFileTmp;
    @NotNull
    private final Path journalFileBackup;
    @NotNull
    private final LruHashMap<String, Entry> lruEntries;
    @NotNull
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    @Nullable
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    @NotNull
    private final Object syncObject;
    @NotNull
    private final fileSystem.1 fileSystem;
    public static final int $stable = 8;
    @NotNull
    public static final String JOURNAL_FILE = "journal";
    @NotNull
    public static final String JOURNAL_FILE_TMP = "journal.tmp";
    @NotNull
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @NotNull
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @NotNull
    public static final String VERSION = "1";
    @NotNull
    private static final String CLEAN = "CLEAN";
    @NotNull
    private static final String DIRTY = "DIRTY";
    @NotNull
    private static final String REMOVE = "REMOVE";
    @NotNull
    private static final String READ = "READ";
    @NotNull
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z\\d_-]{1,120}");

    public DiskLruCache(@NotNull FileSystem fileSystem2, @NotNull Path directory, @NotNull CoroutineDispatcher cleanupDispatcher, long maxSize, int appVersion, int valueCount) {
        Intrinsics.checkNotNullParameter(fileSystem2, "fileSystem");
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(cleanupDispatcher, "cleanupDispatcher");
        this.directory = directory;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            boolean $i$a$-require-DiskLruCache$32 = false;
            String $i$a$-require-DiskLruCache$32 = "maxSize <= 0";
            throw new IllegalArgumentException($i$a$-require-DiskLruCache$32.toString());
        }
        if (!(this.valueCount > 0)) {
            boolean bl = false;
            String string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
        this.lruEntries = new LruHashMap(0, 0.75f);
        this.cleanupScope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null).plus(cleanupDispatcher.limitedParallelism(1)));
        this.syncObject = new Object();
        this.fileSystem = new ForwardingFileSystem(fileSystem2){

            @NotNull
            public Sink sink(@NotNull Path file, boolean mustCreate) {
                block0: {
                    Intrinsics.checkNotNullParameter(file, "file");
                    Path path2 = file.parent();
                    if (path2 == null) break block0;
                    Path p0 = path2;
                    boolean bl = false;
                    this.createDirectories(p0);
                }
                return super.sink(file, mustCreate);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            this.fileSystem.delete(this.journalFileTmp);
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                }
            }
            if (this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readJournal() {
        Throwable thrown$iv$iv;
        Unit result$iv$iv;
        block20: {
            void this_$iv;
            FileSystem fileSystem2 = this.fileSystem;
            Path file$iv = this.journalFile;
            boolean bl = false;
            Closeable $this$use$iv$iv = Okio.buffer(this_$iv.source(file$iv));
            boolean $i$f$use = false;
            result$iv$iv = null;
            thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSource $this$readJournal_u24lambda_u243 = it$iv;
                boolean bl3 = false;
                String magic = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String version = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String appVersionString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String valueCountString = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                String blank = $this$readJournal_u24lambda_u243.readUtf8LineStrict();
                if (!Intrinsics.areEqual(MAGIC, magic)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + "]");
                if (!Intrinsics.areEqual(VERSION, version)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + "]");
                if (!Intrinsics.areEqual(String.valueOf(this.appVersion), appVersionString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + "]");
                if (!Intrinsics.areEqual(String.valueOf(this.valueCount), valueCountString)) throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + "]");
                if (((CharSequence)blank).length() > 0) {
                    throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + appVersionString + ", " + valueCountString + ", " + blank + "]");
                }
                int lineCount = 0;
                try {
                    while (true) {
                        this.readJournalLine($this$readJournal_u24lambda_u243.readUtf8LineStrict());
                        ++lineCount;
                    }
                }
                catch (EOFException eOFException) {
                    this.operationsSinceRewrite = lineCount - this.lruEntries.getEntries().size();
                    if (!$this$readJournal_u24lambda_u243.exhausted()) {
                        this.writeJournal();
                    } else {
                        this.journalWriter = this.newJournalWriter();
                    }
                    result$iv$iv = Unit.INSTANCE;
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                }
                catch (Throwable throwable) {
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable == null) throw throwable;
                        closeable.close();
                        throw throwable;
                    }
                    catch (Throwable t$iv$iv2) {
                        thrown$iv$iv = t$iv$iv2;
                    }
                    throw throwable;
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv3) {
                    if (thrown$iv$iv == null) {
                        thrown$iv$iv = t$iv$iv3;
                        break block20;
                    }
                    ExceptionsKt.addSuppressed(thrown$iv$iv, t$iv$iv3);
                }
            }
        }
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }

    private final BufferedSink newJournalWriter() {
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        FaultHidingSink faultHidingSink2 = new FaultHidingSink(fileSink, (Function1<? super IOException, Unit>)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull IOException it) {
                Intrinsics.checkNotNullParameter(it, "it");
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        });
        return Okio.buffer(faultHidingSink2);
    }

    private final void readJournalLine(String line) {
        int firstSpace = StringsKt.indexOf$default((CharSequence)line, ' ', 0, false, 6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)line, ' ', keyBegin, false, 4, null);
        String key = null;
        if (secondSpace == -1) {
            String string = line.substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            key = string;
            if (firstSpace == 6 && StringsKt.startsWith$default(line, REMOVE, false, 2, null)) {
                this.lruEntries.remove(key);
                return;
            }
        } else {
            String string = line.substring(keyBegin, secondSpace);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            key = string;
        }
        Entry entry2 = LruHashMapKt.getOrPut(this.lruEntries, key, (Function0)new Function0<Entry>(this, key){
            final /* synthetic */ DiskLruCache this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                super(0);
            }

            @NotNull
            public final Entry invoke() {
                return this.this$0.new Entry(this.$key);
            }
        });
        if (secondSpace != -1 && firstSpace == 5 && StringsKt.startsWith$default(line, CLEAN, false, 2, null)) {
            String string = line.substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            char[] cArray = new char[]{' '};
            List parts = StringsKt.split$default((CharSequence)string, cArray, false, 0, 6, null);
            entry2.setReadable(true);
            entry2.setCurrentEditor(null);
            entry2.setLengths(parts);
        } else if (secondSpace == -1 && firstSpace == 5 && StringsKt.startsWith$default(line, DIRTY, false, 2, null)) {
            entry2.setCurrentEditor(new Editor(entry2));
        } else if (secondSpace != -1 || firstSpace != 4 || !StringsKt.startsWith$default(line, READ, false, 2, null)) {
            throw new IOException("unexpected journal line: " + line);
        }
    }

    private final void processJournal() {
        long size2 = 0L;
        for (Map.Entry<String, Entry> entry2 : this.lruEntries.getEntries()) {
            int i;
            int n;
            if (entry2.getValue().getCurrentEditor() == null) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    size2 += entry2.getValue().getLengths()[i];
                }
                continue;
            }
            entry2.getValue().setCurrentEditor(null);
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                Path path2 = entry2.getValue().getCleanFiles().get(i);
                Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
                this.fileSystem.delete(path2);
                Path path3 = entry2.getValue().getDirtyFiles().get(i);
                Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
                this.fileSystem.delete(path3);
            }
            this.lruEntries.remove(entry2.getKey());
        }
        this.size = size2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    private final void writeJournal() {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            Throwable thrown$iv$iv;
            Unit result$iv$iv;
            block23: {
                void $this$iv;
                boolean bl = false;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                FileSystem fileSystem2 = this.fileSystem;
                Path file$iv = this.journalFileTmp;
                boolean mustCreate$iv = false;
                boolean bl2 = false;
                Closeable $this$use$iv$iv = Okio.buffer($this$iv.sink(file$iv, mustCreate$iv));
                boolean $i$f$use = false;
                result$iv$iv = null;
                thrown$iv$iv = null;
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl3 = false;
                BufferedSink $this$writeJournal_u24lambda_u245_u24lambda_u244 = it$iv;
                boolean bl4 = false;
                $this$writeJournal_u24lambda_u245_u24lambda_u244.writeUtf8(MAGIC).writeByte(10);
                $this$writeJournal_u24lambda_u245_u24lambda_u244.writeUtf8(VERSION).writeByte(10);
                $this$writeJournal_u24lambda_u245_u24lambda_u244.writeDecimalLong(this.appVersion).writeByte(10);
                $this$writeJournal_u24lambda_u245_u24lambda_u244.writeDecimalLong(this.valueCount).writeByte(10);
                $this$writeJournal_u24lambda_u245_u24lambda_u244.writeByte(10);
                for (Map.Entry<String, Entry> entry2 : this.lruEntries.getEntries()) {
                    if (entry2.getValue().getCurrentEditor() != null) {
                        $this$writeJournal_u24lambda_u245_u24lambda_u244.writeUtf8(DIRTY);
                        $this$writeJournal_u24lambda_u245_u24lambda_u244.writeByte(32);
                        $this$writeJournal_u24lambda_u245_u24lambda_u244.writeUtf8(entry2.getKey());
                        $this$writeJournal_u24lambda_u245_u24lambda_u244.writeByte(10);
                        continue;
                    }
                    $this$writeJournal_u24lambda_u245_u24lambda_u244.writeUtf8(CLEAN);
                    $this$writeJournal_u24lambda_u245_u24lambda_u244.writeByte(32);
                    $this$writeJournal_u24lambda_u245_u24lambda_u244.writeUtf8(entry2.getKey());
                    entry2.getValue().writeLengths($this$writeJournal_u24lambda_u245_u24lambda_u244);
                    $this$writeJournal_u24lambda_u245_u24lambda_u244.writeByte(10);
                }
                result$iv$iv = Unit.INSTANCE;
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                    break block23;
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
                break block23;
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            thrown$iv$iv = t$iv$iv2;
                        }
                        throw throwable;
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv3) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv3;
                            break block23;
                        }
                        ExceptionsKt.addSuppressed(thrown$iv$iv, t$iv$iv3);
                    }
                }
            }
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Intrinsics.checkNotNull(result$iv$iv);
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Snapshot get(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            BufferedSink bufferedSink;
            Object object2;
            block5: {
                boolean bl = false;
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                object2 = this.lruEntries.get(key);
                if (object2 != null && (object2 = ((Entry)object2).snapshot()) != null) break block5;
                Snapshot snapshot2 = null;
                return snapshot2;
            }
            Object snapshot3 = object2;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull(bufferedSink2);
            BufferedSink $this$get_u24lambda_u247_u24lambda_u246 = bufferedSink = bufferedSink2;
            boolean bl = false;
            $this$get_u24lambda_u247_u24lambda_u246.writeUtf8(READ);
            $this$get_u24lambda_u247_u24lambda_u246.writeByte(32);
            $this$get_u24lambda_u247_u24lambda_u246.writeUtf8(key);
            $this$get_u24lambda_u247_u24lambda_u246.writeByte(10);
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Object object3 = snapshot3;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Editor edit(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            Entry entry2;
            block11: {
                BufferedSink bufferedSink;
                block10: {
                    block9: {
                        block8: {
                            boolean bl = false;
                            this.checkNotClosed();
                            this.validateKey(key);
                            this.initialize();
                            Entry entry3 = entry2 = this.lruEntries.get(key);
                            if ((entry3 != null ? entry3.getCurrentEditor() : null) == null) break block8;
                            Editor editor = null;
                            return editor;
                        }
                        if (entry2 == null || entry2.getLockingSnapshotCount() == 0) break block9;
                        Editor editor = null;
                        return editor;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    Editor editor = null;
                    return editor;
                }
                BufferedSink bufferedSink2 = this.journalWriter;
                Intrinsics.checkNotNull(bufferedSink2);
                BufferedSink $this$edit_u24lambda_u249_u24lambda_u248 = bufferedSink = bufferedSink2;
                boolean bl = false;
                $this$edit_u24lambda_u249_u24lambda_u248.writeUtf8(DIRTY);
                $this$edit_u24lambda_u249_u24lambda_u248.writeByte(32);
                $this$edit_u24lambda_u249_u24lambda_u248.writeUtf8(key);
                $this$edit_u24lambda_u249_u24lambda_u248.writeByte(10);
                $this$edit_u24lambda_u249_u24lambda_u248.flush();
                if (!this.hasJournalErrors) break block11;
                Editor editor = null;
                return editor;
            }
            if (entry2 == null) {
                entry2 = new Entry(key);
                this.lruEntries.put(key, entry2);
            }
            Editor editor = new Editor(entry2);
            entry2.setCurrentEditor(editor);
            Editor editor2 = editor;
            return editor2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long size() {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            long l = this.size;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completeEdit(Editor editor, boolean success2) {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            BufferedSink bufferedSink;
            int i;
            int n;
            boolean bl = false;
            Entry entry2 = editor.getEntry();
            if (!Intrinsics.areEqual(entry2.getCurrentEditor(), editor)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (success2 && !entry2.getZombie()) {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    if (!editor.getWritten()[i]) continue;
                    Path path2 = entry2.getDirtyFiles().get(i);
                    Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
                    if (this.fileSystem.exists(path2)) continue;
                    editor.abort();
                    return;
                }
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    long newLength;
                    Path clean;
                    Path dirty;
                    Intrinsics.checkNotNullExpressionValue(entry2.getDirtyFiles().get(i), "get(...)");
                    Intrinsics.checkNotNullExpressionValue(entry2.getCleanFiles().get(i), "get(...)");
                    if (this.fileSystem.exists(dirty)) {
                        this.fileSystem.atomicMove(dirty, clean);
                    } else {
                        FileSystem fileSystem2 = this.fileSystem;
                        Path path3 = entry2.getCleanFiles().get(i);
                        Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
                        FileSystemKt.createFile(fileSystem2, path3);
                    }
                    long oldLength = entry2.getLengths()[i];
                    Long l = this.fileSystem.metadata(clean).getSize();
                    entry2.getLengths()[i] = newLength = l != null ? l : 0L;
                    this.size = this.size - oldLength + newLength;
                }
            } else {
                n = this.valueCount;
                for (i = 0; i < n; ++i) {
                    Path path4 = entry2.getDirtyFiles().get(i);
                    Intrinsics.checkNotNullExpressionValue(path4, "get(...)");
                    this.fileSystem.delete(path4);
                }
            }
            entry2.setCurrentEditor(null);
            if (entry2.getZombie()) {
                this.removeEntry(entry2);
                return;
            }
            int n2 = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n2 + 1;
            BufferedSink bufferedSink2 = this.journalWriter;
            Intrinsics.checkNotNull(bufferedSink2);
            BufferedSink $this$completeEdit_u24lambda_u2412_u24lambda_u2411 = bufferedSink = bufferedSink2;
            boolean bl2 = false;
            if (success2 || entry2.getReadable()) {
                entry2.setReadable(true);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(CLEAN);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(32);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(entry2.getKey());
                entry2.writeLengths($this$completeEdit_u24lambda_u2412_u24lambda_u2411);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(10);
            } else {
                this.lruEntries.remove(entry2.getKey());
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(REMOVE);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(32);
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeUtf8(entry2.getKey());
                $this$completeEdit_u24lambda_u2412_u24lambda_u2411.writeByte(10);
            }
            $this$completeEdit_u24lambda_u2412_u24lambda_u2411.flush();
            if (this.size > this.maxSize || this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            Entry entry2;
            block5: {
                boolean bl = false;
                this.checkNotClosed();
                this.validateKey(key);
                this.initialize();
                if (this.lruEntries.get(key) != null) break block5;
                boolean bl2 = false;
                return bl2;
            }
            Entry entry3 = entry2;
            boolean removed = this.removeEntry(entry3);
            if (removed && this.size <= this.maxSize) {
                this.mostRecentTrimFailed = false;
            }
            boolean bl = removed;
            return bl;
        }
    }

    private final boolean removeEntry(Entry entry2) {
        if (entry2.getLockingSnapshotCount() > 0) {
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                BufferedSink bufferedSink2;
                BufferedSink $this$removeEntry_u24lambda_u2414 = bufferedSink2 = bufferedSink;
                boolean bl = false;
                $this$removeEntry_u24lambda_u2414.writeUtf8(DIRTY);
                $this$removeEntry_u24lambda_u2414.writeByte(32);
                $this$removeEntry_u24lambda_u2414.writeUtf8(entry2.getKey());
                $this$removeEntry_u24lambda_u2414.writeByte(10);
                $this$removeEntry_u24lambda_u2414.flush();
            }
        }
        if (entry2.getLockingSnapshotCount() > 0 || entry2.getCurrentEditor() != null) {
            entry2.setZombie(true);
            return true;
        }
        int n = this.valueCount;
        for (int i = 0; i < n; ++i) {
            Path path2 = entry2.getCleanFiles().get(i);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            this.fileSystem.delete(path2);
            this.size -= entry2.getLengths()[i];
            entry2.getLengths()[i] = 0L;
        }
        int n2 = this.operationsSinceRewrite;
        this.operationsSinceRewrite = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            BufferedSink bufferedSink3;
            BufferedSink $this$removeEntry_u24lambda_u2415 = bufferedSink3 = bufferedSink;
            boolean bl = false;
            $this$removeEntry_u24lambda_u2415.writeUtf8(REMOVE);
            $this$removeEntry_u24lambda_u2415.writeByte(32);
            $this$removeEntry_u24lambda_u2415.writeUtf8(entry2.getKey());
            $this$removeEntry_u24lambda_u2415.writeByte(10);
        }
        this.lruEntries.remove(entry2.getKey());
        if (this.journalRewriteRequired()) {
            this.launchCleanup();
        }
        return true;
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            if (!this.initialized || this.closed) {
                this.closed = true;
                return;
            }
            Collection $this$toTypedArray$iv = this.lruEntries.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            for (Map.Entry entry2 : thisCollection$iv.toArray(new Map.Entry[0])) {
                Editor editor = ((Entry)entry2.getValue()).getCurrentEditor();
                if (editor == null) continue;
                editor.detach();
            }
            this.trimToSize();
            CoroutineScopeKt.cancel$default(this.cleanupScope, null, 1, null);
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull(bufferedSink);
            bufferedSink.close();
            this.journalWriter = null;
            this.closed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            if (!this.initialized) {
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull(bufferedSink);
            bufferedSink.flush();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    private final boolean removeOldestEntry() {
        for (Map.Entry<String, Entry> toEvict : this.lruEntries.getEntries()) {
            if (toEvict.getValue().getZombie()) continue;
            this.removeEntry(toEvict.getValue());
            return true;
        }
        return false;
    }

    private final void delete() {
        this.close();
        FileSystemKt.deleteContents(this.fileSystem, this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void evictAll() {
        Object lock$iv = this.syncObject;
        boolean $i$f$synchronized = false;
        boolean $i$f$synchronizedImpl = false;
        Object object = lock$iv;
        synchronized (object) {
            boolean bl = false;
            this.initialize();
            Collection $this$toTypedArray$iv = this.lruEntries.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            for (Map.Entry entry2 : thisCollection$iv.toArray(new Map.Entry[0])) {
                this.removeEntry((Entry)entry2.getValue());
            }
            this.mostRecentTrimFailed = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void launchCleanup() {
        BuildersKt.launch$default(this.cleanupScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DiskLruCache this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void lock$iv;
                        ResultKt.throwOnFailure(object);
                        Object object2 = DiskLruCache.access$getSyncObject$p(this.this$0);
                        DiskLruCache diskLruCache = this.this$0;
                        boolean $i$f$synchronized = false;
                        boolean $i$f$synchronizedImpl = false;
                        void var6_6 = lock$iv;
                        synchronized (var6_6) {
                            boolean bl = false;
                            if (!DiskLruCache.access$getInitialized$p(diskLruCache)) return Unit.INSTANCE;
                            if (DiskLruCache.access$getClosed$p(diskLruCache)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(diskLruCache);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(diskLruCache)) {
                                    DiskLruCache.access$writeJournal(diskLruCache);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache, true);
                                DiskLruCache.access$setJournalWriter$p(diskLruCache, Okio.buffer(Okio.blackhole()));
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches(key)) {
            boolean bl = false;
            String string = "keys must match regex [a-z0-9_-]{1,120}: \"" + key + "\"";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        $this.hasJournalErrors = bl;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = bl;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = bl;
    }

    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        $this.journalWriter = bufferedSink;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Companion;", "", "()V", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TMP", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "MAGIC", "READ", "REMOVE", "VERSION", "image-loader"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\f\u0010\u0011\u001a\b\u0018\u00010\u0012R\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "", "entry", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache;Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "written", "", "getWritten", "()[Z", "abort", "", "commit", "commitAndGet", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "complete", "success", "detach", "file", "Lokio/Path;", "index", "", "image-loader"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Editor\n+ 2 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 3 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,852:1\n28#2,4:853\n28#2,4:859\n28#2,4:864\n20#3:857\n20#3:863\n20#3:868\n1#4:858\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Editor\n*L\n705#1:853,4\n732#1:859,4\n748#1:864,4\n705#1:857\n732#1:863\n748#1:868\n*E\n"})
    public final class Editor {
        @NotNull
        private final Entry entry;
        private boolean closed;
        @NotNull
        private final boolean[] written;

        public Editor(Entry entry2) {
            Intrinsics.checkNotNullParameter(entry2, "entry");
            this.entry = entry2;
            this.written = new boolean[DiskLruCache.this.valueCount];
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final boolean[] getWritten() {
            return this.written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Path file(int index2) {
            void lock$iv;
            Object object = DiskLruCache.this.syncObject;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var6_6 = lock$iv;
            synchronized (var6_6) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                this.written[index2] = true;
                Path path2 = this.entry.getDirtyFiles().get(index2);
                Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
                Path path3 = path2;
                fileSystem.1 var8_10 = diskLruCache.fileSystem;
                Path p0 = path3;
                boolean bl3 = false;
                FileSystemKt.createFile(var8_10, p0);
                Path path4 = path3;
                return path4;
            }
        }

        public final void detach() {
            if (Intrinsics.areEqual(this.entry.getCurrentEditor(), this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot commitAndGet() {
            void lock$iv;
            Object object = DiskLruCache.this.syncObject;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var5_5 = lock$iv;
            synchronized (var5_5) {
                boolean bl = false;
                this.commit();
                Snapshot snapshot2 = diskLruCache.get(this.entry.getKey());
                return snapshot2;
            }
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void complete(boolean success2) {
            void lock$iv;
            Object object = DiskLruCache.this.syncObject;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var6_6 = lock$iv;
            synchronized (var6_6) {
                boolean bl = false;
                if (!(!this.closed)) {
                    boolean bl2 = false;
                    String string = "editor is closed";
                    throw new IllegalStateException(string.toString());
                }
                if (Intrinsics.areEqual(this.entry.getCurrentEditor(), this)) {
                    diskLruCache.completeEdit(this, success2);
                }
                this.closed = true;
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030,J\f\u0010-\u001a\b\u0018\u00010.R\u00020\rJ\u000e\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0018\u00010\fR\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u00062"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "", "key", "", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "Ljava/util/ArrayList;", "Lokio/Path;", "Lkotlin/collections/ArrayList;", "getCleanFiles", "()Ljava/util/ArrayList;", "currentEditor", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "getCurrentEditor", "()Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "setCurrentEditor", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles", "getKey", "()Ljava/lang/String;", "lengths", "", "getLengths", "()[J", "lockingSnapshotCount", "", "getLockingSnapshotCount", "()I", "setLockingSnapshotCount", "(I)V", "readable", "", "getReadable", "()Z", "setReadable", "(Z)V", "zombie", "getZombie", "setZombie", "setLengths", "", "strings", "", "snapshot", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "writeLengths", "writer", "Lokio/BufferedSink;", "image-loader"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Entry\n+ 2 Collections.kt\ncom/seiko/imageloader/util/CollectionsKt\n*L\n1#1,852:1\n8#2,4:853\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Entry\n*L\n824#1:853,4\n*E\n"})
    public final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final long[] lengths;
        @NotNull
        private final ArrayList<Path> cleanFiles;
        @NotNull
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        @Nullable
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter(key, "key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.valueCount;
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                Collection collection = this.cleanFiles;
                Path path2 = DiskLruCache.this.directory;
                String string = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                collection.add(path2.resolve(string));
                fileBuilder.append(".tmp");
                collection = this.dirtyFiles;
                Path path3 = DiskLruCache.this.directory;
                String string2 = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                collection.add(path3.resolve(string2));
                fileBuilder.setLength(truncateTo);
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final long[] getLengths() {
            return this.lengths;
        }

        @NotNull
        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        @NotNull
        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = bl;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = bl;
        }

        @Nullable
        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        public final void setCurrentEditor(@Nullable Editor editor) {
            this.currentEditor = editor;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        public final void setLockingSnapshotCount(int n) {
            this.lockingSnapshotCount = n;
        }

        public final void setLengths(@NotNull List<String> strings) {
            Intrinsics.checkNotNullParameter(strings, "strings");
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + strings);
            }
            try {
                int n = strings.size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("unexpected journal line: " + strings);
            }
        }

        public final void writeLengths(@NotNull BufferedSink writer) {
            Intrinsics.checkNotNullParameter(writer, "writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Snapshot snapshot() {
            void $this$forEachIndices$iv;
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            List list2 = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$forEachIndices = false;
            int n = $this$forEachIndices$iv.size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Path file = (Path)$this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                if (diskLruCache.fileSystem.exists(file)) continue;
                try {
                    diskLruCache.removeEntry(this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            int n2 = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n2 + 1;
            return new Snapshot(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\b\u0018\u00010\u000eR\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "Lokio/Closeable;", "entry", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "Lcom/seiko/imageloader/cache/disk/DiskLruCache;", "(Lcom/seiko/imageloader/cache/disk/DiskLruCache;Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;)V", "closed", "", "getEntry", "()Lcom/seiko/imageloader/cache/disk/DiskLruCache$Entry;", "close", "", "closeAndEdit", "Lcom/seiko/imageloader/cache/disk/DiskLruCache$Editor;", "file", "Lokio/Path;", "index", "", "image-loader"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n*L\n1#1,852:1\n1#2:853\n28#3,4:854\n28#3,4:859\n20#4:858\n20#4:863\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\ncom/seiko/imageloader/cache/disk/DiskLruCache$Snapshot\n*L\n673#1:854,4\n683#1:859,4\n673#1:858\n683#1:863\n*E\n"})
    public final class Snapshot
    implements Closeable {
        @NotNull
        private final Entry entry;
        private boolean closed;

        public Snapshot(Entry entry2) {
            Intrinsics.checkNotNullParameter(entry2, "entry");
            this.entry = entry2;
        }

        @NotNull
        public final Entry getEntry() {
            return this.entry;
        }

        @NotNull
        public final Path file(int index2) {
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "snapshot is closed";
                throw new IllegalStateException(string.toString());
            }
            Path path2 = this.entry.getCleanFiles().get(index2);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            return path2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void close() {
            if (!this.closed) {
                void lock$iv;
                this.closed = true;
                Object object = DiskLruCache.this.syncObject;
                DiskLruCache diskLruCache = DiskLruCache.this;
                boolean $i$f$synchronized = false;
                boolean $i$f$synchronizedImpl = false;
                void var5_5 = lock$iv;
                synchronized (var5_5) {
                    boolean bl = false;
                    Entry entry2 = this.entry;
                    int n = entry2.getLockingSnapshotCount();
                    entry2.setLockingSnapshotCount(n + -1);
                    if (this.entry.getLockingSnapshotCount() == 0 && this.entry.getZombie()) {
                        diskLruCache.removeEntry(this.entry);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final Editor closeAndEdit() {
            void lock$iv;
            Object object = DiskLruCache.this.syncObject;
            DiskLruCache diskLruCache = DiskLruCache.this;
            boolean $i$f$synchronized = false;
            boolean $i$f$synchronizedImpl = false;
            void var5_5 = lock$iv;
            synchronized (var5_5) {
                boolean bl = false;
                this.close();
                Editor editor = diskLruCache.edit(this.entry.getKey());
                return editor;
            }
        }
    }
}

