/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.memory;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.memory.EmptyStrongMemoryCache;
import com.seiko.imageloader.cache.memory.EmptyWeakMemoryCache;
import com.seiko.imageloader.cache.memory.MemoryCache;
import com.seiko.imageloader.cache.memory.RealMemoryCache;
import com.seiko.imageloader.cache.memory.RealStrongMemoryCache;
import com.seiko.imageloader.cache.memory.RealWeakMemoryCache;
import com.seiko.imageloader.cache.memory.StrongMemoryCache;
import com.seiko.imageloader.cache.memory.WeakMemoryCache;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B/\b\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/seiko/imageloader/cache/memory/MemoryCacheBuilder;", "K", "", "V", "valueHashProvider", "Lkotlin/Function1;", "", "valueSizeProvider", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "maxSizeBytes", "strongReferencesEnabled", "", "weakReferencesEnabled", "build", "Lcom/seiko/imageloader/cache/memory/MemoryCache;", "build$image_loader", "", "size", "enable", "image-loader"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMemoryCacheBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCacheBuilder.kt\ncom/seiko/imageloader/cache/memory/MemoryCacheBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class MemoryCacheBuilder<K, V> {
    @NotNull
    private final Function1<V, Integer> valueHashProvider;
    @NotNull
    private final Function1<V, Integer> valueSizeProvider;
    private int maxSizeBytes;
    private boolean strongReferencesEnabled;
    private boolean weakReferencesEnabled;
    public static final int $stable = 8;

    public MemoryCacheBuilder(@NotNull Function1<? super V, Integer> valueHashProvider, @NotNull Function1<? super V, Integer> valueSizeProvider) {
        Intrinsics.checkNotNullParameter(valueHashProvider, "valueHashProvider");
        Intrinsics.checkNotNullParameter(valueSizeProvider, "valueSizeProvider");
        this.valueHashProvider = valueHashProvider;
        this.valueSizeProvider = valueSizeProvider;
        this.strongReferencesEnabled = true;
        this.weakReferencesEnabled = true;
    }

    public final void maxSizeBytes(int size2) {
        if (!(size2 >= 0)) {
            boolean bl = false;
            String string = "size must be >= 0.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxSizeBytes = size2;
    }

    public final void strongReferencesEnabled(boolean enable) {
        this.strongReferencesEnabled = enable;
    }

    public final void weakReferencesEnabled(boolean enable) {
        this.weakReferencesEnabled = enable;
    }

    @NotNull
    public final MemoryCache<K, V> build$image_loader() {
        WeakMemoryCache weakMemoryCache = this.weakReferencesEnabled ? (WeakMemoryCache)new RealWeakMemoryCache(this.valueHashProvider) : (WeakMemoryCache)new EmptyWeakMemoryCache();
        StrongMemoryCache strongMemoryCache = this.strongReferencesEnabled && this.maxSizeBytes > 0 ? (StrongMemoryCache)new RealStrongMemoryCache(this.maxSizeBytes, weakMemoryCache, this.valueSizeProvider) : (StrongMemoryCache)new EmptyStrongMemoryCache(weakMemoryCache, this.valueSizeProvider);
        return new RealMemoryCache(strongMemoryCache, weakMemoryCache);
    }
}

