/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.memory;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.memory.MemoryCache;
import com.seiko.imageloader.cache.memory.StrongMemoryCache;
import com.seiko.imageloader.cache.memory.WeakMemoryCache;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B-\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/seiko/imageloader/cache/memory/RealMemoryCache;", "K", "", "V", "Lcom/seiko/imageloader/cache/memory/MemoryCache;", "strongMemoryCache", "Lcom/seiko/imageloader/cache/memory/StrongMemoryCache;", "weakMemoryCache", "Lcom/seiko/imageloader/cache/memory/WeakMemoryCache;", "(Lcom/seiko/imageloader/cache/memory/StrongMemoryCache;Lcom/seiko/imageloader/cache/memory/WeakMemoryCache;)V", "keys", "", "getKeys", "()Ljava/util/Set;", "maxSize", "", "getMaxSize", "()I", "size", "getSize", "clear", "", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "remove", "", "(Ljava/lang/Object;)Z", "set", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "image-loader"})
@StabilityInferred(parameters=4)
public final class RealMemoryCache<K, V>
implements MemoryCache<K, V> {
    @NotNull
    private final StrongMemoryCache<K, V> strongMemoryCache;
    @NotNull
    private final WeakMemoryCache<K, V> weakMemoryCache;
    public static final int $stable;

    public RealMemoryCache(@NotNull StrongMemoryCache<K, V> strongMemoryCache, @NotNull WeakMemoryCache<K, V> weakMemoryCache) {
        Intrinsics.checkNotNullParameter(strongMemoryCache, "strongMemoryCache");
        Intrinsics.checkNotNullParameter(weakMemoryCache, "weakMemoryCache");
        this.strongMemoryCache = strongMemoryCache;
        this.weakMemoryCache = weakMemoryCache;
    }

    @Override
    public int getSize() {
        return this.strongMemoryCache.getSize();
    }

    @Override
    public int getMaxSize() {
        return this.strongMemoryCache.getMaxSize();
    }

    @Override
    @NotNull
    public Set<K> getKeys() {
        return SetsKt.plus(this.strongMemoryCache.getKeys(), (Iterable)this.weakMemoryCache.getKeys());
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        V v = this.strongMemoryCache.get(key);
        if (v == null) {
            v = this.weakMemoryCache.get(key);
        }
        return v;
    }

    @Override
    public void set(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.strongMemoryCache.set(key, value);
    }

    @Override
    public boolean remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        boolean removedStrong = this.strongMemoryCache.remove(key);
        boolean removedWeak = this.weakMemoryCache.remove(key);
        return removedStrong || removedWeak;
    }

    @Override
    public void clear() {
        this.strongMemoryCache.evictAll();
        this.weakMemoryCache.evictAll();
    }
}

