/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.cache.memory;

import androidx.collection.LruCache;
import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.cache.memory.RealStrongMemoryCache;
import com.seiko.imageloader.cache.memory.StrongMemoryCache;
import com.seiko.imageloader.cache.memory.WeakMemoryCache;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000E\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\r\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001\"B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0017\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010!R\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/seiko/imageloader/cache/memory/RealStrongMemoryCache;", "K", "", "V", "Lcom/seiko/imageloader/cache/memory/StrongMemoryCache;", "maxSize", "", "weakMemoryCache", "Lcom/seiko/imageloader/cache/memory/WeakMemoryCache;", "valueSizeProvider", "Lkotlin/Function1;", "(ILcom/seiko/imageloader/cache/memory/WeakMemoryCache;Lkotlin/jvm/functions/Function1;)V", "cache", "com/seiko/imageloader/cache/memory/RealStrongMemoryCache$cache$1", "Lcom/seiko/imageloader/cache/memory/RealStrongMemoryCache$cache$1;", "keys", "", "getKeys", "()Ljava/util/Set;", "getMaxSize", "()I", "size", "getSize", "evictAll", "", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "remove", "", "(Ljava/lang/Object;)Z", "set", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "InternalValue", "image-loader"})
@StabilityInferred(parameters=0)
public class RealStrongMemoryCache<K, V>
implements StrongMemoryCache<K, V> {
    @NotNull
    private final WeakMemoryCache<K, V> weakMemoryCache;
    @NotNull
    private final Function1<V, Integer> valueSizeProvider;
    @NotNull
    private final cache.1<K, V> cache;
    public static final int $stable = 8;

    public RealStrongMemoryCache(int maxSize, @NotNull WeakMemoryCache<K, V> weakMemoryCache, @NotNull Function1<? super V, Integer> valueSizeProvider) {
        Intrinsics.checkNotNullParameter(weakMemoryCache, "weakMemoryCache");
        Intrinsics.checkNotNullParameter(valueSizeProvider, "valueSizeProvider");
        this.weakMemoryCache = weakMemoryCache;
        this.valueSizeProvider = valueSizeProvider;
        this.cache = new LruCache<K, InternalValue<V>>(maxSize, this){
            final /* synthetic */ RealStrongMemoryCache<K, V> this$0;
            {
                this.this$0 = $receiver;
                super($maxSize);
            }

            protected int sizeOf(@NotNull K key, @NotNull InternalValue<V> value) {
                Intrinsics.checkNotNullParameter(key, "key");
                Intrinsics.checkNotNullParameter(value, "value");
                return value.getSize();
            }

            protected void entryRemoved(boolean evicted, @NotNull K key, @NotNull InternalValue<V> oldValue, @Nullable InternalValue<V> newValue) {
                Intrinsics.checkNotNullParameter(key, "key");
                Intrinsics.checkNotNullParameter(oldValue, "oldValue");
                RealStrongMemoryCache.access$getWeakMemoryCache$p(this.this$0).set(key, oldValue.getValue(), oldValue.getSize());
            }
        };
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    public int getMaxSize() {
        return this.cache.maxSize();
    }

    @Override
    @NotNull
    public Set<K> getKeys() {
        return this.cache.snapshot().keySet();
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        InternalValue internalValue = (InternalValue)this.cache.get(key);
        return (V)(internalValue != null ? internalValue.getValue() : null);
    }

    @Override
    public void set(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        int size2 = ((Number)this.valueSizeProvider.invoke(value)).intValue();
        if (size2 <= this.getMaxSize()) {
            this.cache.put(key, new InternalValue<V>(value, size2));
        } else {
            this.cache.remove(key);
            this.weakMemoryCache.set(key, value, size2);
        }
    }

    @Override
    public boolean remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.cache.remove(key) != null;
    }

    @Override
    public void evictAll() {
        this.cache.evictAll();
    }

    public static final /* synthetic */ WeakMemoryCache access$getWeakMemoryCache$p(RealStrongMemoryCache $this) {
        return $this.weakMemoryCache;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/seiko/imageloader/cache/memory/RealStrongMemoryCache$InternalValue;", "V", "", "value", "size", "", "(Ljava/lang/Object;I)V", "getSize", "()I", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "image-loader"})
    private static final class InternalValue<V> {
        private final V value;
        private final int size;

        public InternalValue(V value, int size2) {
            this.value = value;
            this.size = size2;
        }

        public final V getValue() {
            return this.value;
        }

        public final int getSize() {
            return this.size;
        }
    }
}

