/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component;

import androidx.compose.runtime.internal.StabilityInferred;
import com.seiko.imageloader.component.decoder.Decoder;
import com.seiko.imageloader.component.fetcher.Fetcher;
import com.seiko.imageloader.component.keyer.Keyer;
import com.seiko.imageloader.component.mapper.Mapper;
import com.seiko.imageloader.model.ImageResult;
import com.seiko.imageloader.option.Options;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001BG\b\u0000\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0014J,\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0014J \u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019J\u0015\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b%R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006&"}, d2={"Lcom/seiko/imageloader/component/ComponentRegistry;", "", "mappers", "", "Lcom/seiko/imageloader/component/mapper/Mapper;", "keyers", "Lcom/seiko/imageloader/component/keyer/Keyer;", "fetcherFactories", "Lcom/seiko/imageloader/component/fetcher/Fetcher$Factory;", "decoderFactories", "Lcom/seiko/imageloader/component/decoder/Decoder$Factory;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDecoderFactories", "()Ljava/util/List;", "getFetcherFactories", "getKeyers", "getMappers", "decode", "Lkotlin/Pair;", "Lcom/seiko/imageloader/component/decoder/Decoder;", "", "source", "Lcom/seiko/imageloader/model/ImageResult$OfSource;", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "options", "Lcom/seiko/imageloader/option/Options;", "startIndex", "fetch", "Lcom/seiko/imageloader/component/fetcher/Fetcher;", "data", "key", "", "type", "Lcom/seiko/imageloader/component/keyer/Keyer$Type;", "map", "merge", "component", "merge$image_loader", "image-loader"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComponentRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentRegistry.kt\ncom/seiko/imageloader/component/ComponentRegistry\n+ 2 Collections.kt\ncom/seiko/imageloader/util/CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n8#2,2:66\n11#2:69\n8#2,4:70\n1#3:68\n*S KotlinDebug\n*F\n+ 1 ComponentRegistry.kt\ncom/seiko/imageloader/component/ComponentRegistry\n*L\n28#1:66,2\n28#1:69\n35#1:70,4\n*E\n"})
public final class ComponentRegistry {
    @NotNull
    private final List<Mapper<? extends Object>> mappers;
    @NotNull
    private final List<Keyer> keyers;
    @NotNull
    private final List<Fetcher.Factory> fetcherFactories;
    @NotNull
    private final List<Decoder.Factory> decoderFactories;
    public static final int $stable = 8;

    public ComponentRegistry(@NotNull List<? extends Mapper<? extends Object>> mappers, @NotNull List<? extends Keyer> keyers, @NotNull List<? extends Fetcher.Factory> fetcherFactories, @NotNull List<? extends Decoder.Factory> decoderFactories) {
        Intrinsics.checkNotNullParameter(mappers, "mappers");
        Intrinsics.checkNotNullParameter(keyers, "keyers");
        Intrinsics.checkNotNullParameter(fetcherFactories, "fetcherFactories");
        Intrinsics.checkNotNullParameter(decoderFactories, "decoderFactories");
        this.mappers = mappers;
        this.keyers = keyers;
        this.fetcherFactories = fetcherFactories;
        this.decoderFactories = decoderFactories;
    }

    @NotNull
    public final List<Mapper<? extends Object>> getMappers() {
        return this.mappers;
    }

    @NotNull
    public final List<Keyer> getKeyers() {
        return this.keyers;
    }

    @NotNull
    public final List<Fetcher.Factory> getFetcherFactories() {
        return this.fetcherFactories;
    }

    @NotNull
    public final List<Decoder.Factory> getDecoderFactories() {
        return this.decoderFactories;
    }

    @NotNull
    public final ComponentRegistry merge$image_loader(@NotNull ComponentRegistry component) {
        Intrinsics.checkNotNullParameter(component, "component");
        return new ComponentRegistry(CollectionsKt.plus((Collection)this.mappers, (Iterable)component.mappers), CollectionsKt.plus((Collection)this.keyers, (Iterable)component.keyers), CollectionsKt.plus((Collection)this.fetcherFactories, (Iterable)component.fetcherFactories), CollectionsKt.plus((Collection)this.decoderFactories, (Iterable)component.decoderFactories));
    }

    @NotNull
    public final Object map(@NotNull Object data2, @NotNull Options options2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(options2, "options");
        Object mappedData = null;
        mappedData = data2;
        List<Mapper<? extends Object>> $this$forEachIndices$iv = this.mappers;
        boolean $i$f$forEachIndices = false;
        int n = $this$forEachIndices$iv.size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object it;
            Mapper<? extends Object> mapper = $this$forEachIndices$iv.get(i$iv);
            boolean bl = false;
            if (mapper.map(mappedData, options2) == null) continue;
            boolean bl2 = false;
            mappedData = it;
        }
        return mappedData;
    }

    @Nullable
    public final String key(@NotNull Object data2, @NotNull Options options2, @NotNull Keyer.Type type2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(options2, "options");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        List<Keyer> $this$forEachIndices$iv = this.keyers;
        boolean $i$f$forEachIndices = false;
        int n = $this$forEachIndices$iv.size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Keyer keyer = $this$forEachIndices$iv.get(i$iv);
            boolean bl = false;
            String string = keyer.key(data2, options2, type2);
            if (string == null) continue;
            String it = string;
            boolean bl2 = false;
            return it;
        }
        return null;
    }

    @NotNull
    public final Pair<Fetcher, Integer> fetch(@NotNull Object data2, @NotNull Options options2, int startIndex) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(options2, "options");
        int n = this.fetcherFactories.size();
        for (int index2 = startIndex; index2 < n; ++index2) {
            Fetcher.Factory factory2 = this.fetcherFactories.get(index2);
            Fetcher fetcher = factory2.create(data2, options2);
            if (fetcher == null) continue;
            Fetcher it = fetcher;
            boolean bl = false;
            return TuplesKt.to(it, index2);
        }
        throw new RuntimeException("Unable to create a fetcher that supports: " + data2);
    }

    public static /* synthetic */ Pair fetch$default(ComponentRegistry componentRegistry, Object object, Options options2, int n, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return componentRegistry.fetch(object, options2, n);
    }

    @NotNull
    public final Pair<Decoder, Integer> decode(@NotNull ImageResult.OfSource source2, @NotNull Options options2, int startIndex) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(options2, "options");
        int n = this.decoderFactories.size();
        for (int index2 = startIndex; index2 < n; ++index2) {
            Decoder.Factory factory2 = this.decoderFactories.get(index2);
            Decoder decoder = factory2.create(source2, options2);
            if (decoder == null) continue;
            Decoder it = decoder;
            boolean bl = false;
            return TuplesKt.to(it, index2);
        }
        throw new RuntimeException("Unable to create a decoder that supports: " + source2);
    }

    public static /* synthetic */ Pair decode$default(ComponentRegistry componentRegistry, ImageResult.OfSource ofSource, Options options2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return componentRegistry.decode(ofSource, options2, n);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComponentRegistry)) {
            return false;
        }
        ComponentRegistry componentRegistry = (ComponentRegistry)other;
        if (!Intrinsics.areEqual(this.mappers, componentRegistry.mappers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyers, componentRegistry.keyers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fetcherFactories, componentRegistry.fetcherFactories)) {
            return false;
        }
        return Intrinsics.areEqual(this.decoderFactories, componentRegistry.decoderFactories);
    }

    public int hashCode() {
        int result2 = ((Object)this.mappers).hashCode();
        result2 = result2 * 31 + ((Object)this.keyers).hashCode();
        result2 = result2 * 31 + ((Object)this.fetcherFactories).hashCode();
        result2 = result2 * 31 + ((Object)this.decoderFactories).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "ComponentRegistry(mappers=" + this.mappers + ", keyers=" + this.keyers + ", fetcherFactories=" + this.fetcherFactories + ", decoderFactories=" + this.decoderFactories + ")";
    }
}

