/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.component.decoder;

import androidx.compose.ui.unit.Density;
import com.seiko.imageloader.component.decoder.DecodeResult;
import com.seiko.imageloader.component.decoder.Decoder;
import com.seiko.imageloader.component.decoder.SvgDecoder_skiaKt;
import com.seiko.imageloader.model.ExtraDataKt;
import com.seiko.imageloader.model.ImageResult;
import com.seiko.imageloader.option.Options;
import com.seiko.imageloader.util.SourceTypeKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/seiko/imageloader/component/decoder/SvgDecoder;", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lokio/BufferedSource;", "density", "Landroidx/compose/ui/unit/Density;", "options", "Lcom/seiko/imageloader/option/Options;", "(Lokio/BufferedSource;Landroidx/compose/ui/unit/Density;Lcom/seiko/imageloader/option/Options;)V", "decode", "Lcom/seiko/imageloader/component/decoder/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "Factory", "svg"})
public final class SvgDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Density density;
    @NotNull
    private final Options options;
    @NotNull
    private static final String MIME_TYPE_SVG = "image/svg+xml";

    private SvgDecoder(BufferedSource source2, Density density, Options options2) {
        this.source = source2;
        this.density = density;
        this.options = options2;
    }

    @Override
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        return new DecodeResult.OfPainter(SvgDecoder_skiaKt.createSVGPainter(this.source, this.density, this.options));
    }

    public /* synthetic */ SvgDecoder(BufferedSource source2, Density density, Options options2, DefaultConstructorMarker $constructor_marker) {
        this(source2, density, options2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/seiko/imageloader/component/decoder/SvgDecoder$Companion;", "", "()V", "MIME_TYPE_SVG", "", "svg"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/seiko/imageloader/component/decoder/SvgDecoder$Factory;", "Lcom/seiko/imageloader/component/decoder/Decoder$Factory;", "density", "Landroidx/compose/ui/unit/Density;", "(Landroidx/compose/ui/unit/Density;)V", "create", "Lcom/seiko/imageloader/component/decoder/Decoder;", "source", "Lcom/seiko/imageloader/model/ImageResult$OfSource;", "Lcom/seiko/imageloader/component/decoder/DecodeSource;", "options", "Lcom/seiko/imageloader/option/Options;", "isApplicable", "", "svg"})
    public static final class Factory
    implements Decoder.Factory {
        @Nullable
        private final Density density;

        public Factory(@Nullable Density density) {
            this.density = density;
        }

        public /* synthetic */ Factory(Density density, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                density = null;
            }
            this(density);
        }

        @Override
        @Nullable
        public Decoder create(@NotNull ImageResult.OfSource source2, @NotNull Options options2) {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(options2, "options");
            if (!this.isApplicable(source2)) {
                return null;
            }
            BufferedSource bufferedSource = source2.getSource();
            Density density = this.density;
            if (density == null) {
                density = SvgDecoder_skiaKt.defaultDensity(options2);
            }
            return new SvgDecoder(bufferedSource, density, options2, null);
        }

        private final boolean isApplicable(ImageResult.OfSource source2) {
            return Intrinsics.areEqual(ExtraDataKt.getMimeType(source2.getExtra()), SvgDecoder.MIME_TYPE_SVG) || SourceTypeKt.isSvg(source2.getSource());
        }

        public Factory() {
            this(null, 1, null);
        }
    }
}

