/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.model;

import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.painter.Painter;
import com.seiko.imageloader.model.DataSource;
import com.seiko.imageloader.model.ExtraDataKt;
import com.seiko.imageloader.model.ImageAction;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Image;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0005\u0007\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/seiko/imageloader/model/ImageResult;", "Lcom/seiko/imageloader/model/ImageAction;", "OfBitmap", "OfError", "OfImage", "OfPainter", "OfSource", "Lcom/seiko/imageloader/model/ImageResult$OfBitmap;", "Lcom/seiko/imageloader/model/ImageResult$OfError;", "Lcom/seiko/imageloader/model/ImageResult$OfImage;", "Lcom/seiko/imageloader/model/ImageResult$OfPainter;", "Lcom/seiko/imageloader/model/ImageResult$OfSource;", "image-loader"})
@Immutable
public interface ImageResult
extends ImageAction {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/seiko/imageloader/model/ImageResult$OfBitmap;", "Lcom/seiko/imageloader/model/ImageResult;", "Lcom/seiko/imageloader/model/ImageAction$Success;", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "Lcom/seiko/imageloader/Bitmap;", "(Lorg/jetbrains/skia/Bitmap;)V", "getBitmap", "()Lorg/jetbrains/skia/Bitmap;", "image-loader"})
    @Immutable
    public static final class OfBitmap
    implements ImageResult,
    ImageAction.Success {
        @NotNull
        private final Bitmap bitmap;
        public static final int $stable;

        public OfBitmap(@NotNull Bitmap bitmap2) {
            Intrinsics.checkNotNullParameter(bitmap2, "bitmap");
            this.bitmap = bitmap2;
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfBitmap)) {
                return false;
            }
            OfBitmap ofBitmap = (OfBitmap)other;
            return Intrinsics.areEqual(this.bitmap, ofBitmap.bitmap);
        }

        public int hashCode() {
            return this.bitmap.hashCode();
        }

        @NotNull
        public String toString() {
            return "OfBitmap(bitmap=" + this.bitmap + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/seiko/imageloader/model/ImageResult$OfError;", "Lcom/seiko/imageloader/model/ImageResult;", "Lcom/seiko/imageloader/model/ImageAction$Failure;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "image-loader"})
    @Immutable
    public static final class OfError
    implements ImageResult,
    ImageAction.Failure {
        @NotNull
        private final Throwable error;
        public static final int $stable;

        public OfError(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter(error, "error");
            this.error = error;
        }

        @Override
        @NotNull
        public Throwable getError() {
            return this.error;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfError)) {
                return false;
            }
            OfError ofError = (OfError)other;
            return Intrinsics.areEqual(this.error, ofError.error);
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        @NotNull
        public String toString() {
            return "OfError(error=" + this.error + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/seiko/imageloader/model/ImageResult$OfImage;", "Lcom/seiko/imageloader/model/ImageResult;", "Lcom/seiko/imageloader/model/ImageAction$Success;", "image", "Lorg/jetbrains/skia/Image;", "Lcom/seiko/imageloader/Image;", "(Lorg/jetbrains/skia/Image;)V", "getImage", "()Lorg/jetbrains/skia/Image;", "image-loader"})
    @Immutable
    public static final class OfImage
    implements ImageResult,
    ImageAction.Success {
        @NotNull
        private final Image image;
        public static final int $stable;

        public OfImage(@NotNull Image image) {
            Intrinsics.checkNotNullParameter(image, "image");
            this.image = image;
        }

        @NotNull
        public final Image getImage() {
            return this.image;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfImage)) {
                return false;
            }
            OfImage ofImage = (OfImage)other;
            return Intrinsics.areEqual(this.image, ofImage.image);
        }

        public int hashCode() {
            return this.image.hashCode();
        }

        @NotNull
        public String toString() {
            return "OfImage(image=" + this.image + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/seiko/imageloader/model/ImageResult$OfPainter;", "Lcom/seiko/imageloader/model/ImageResult;", "Lcom/seiko/imageloader/model/ImageAction$Success;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "(Landroidx/compose/ui/graphics/painter/Painter;)V", "getPainter", "()Landroidx/compose/ui/graphics/painter/Painter;", "image-loader"})
    @Immutable
    public static final class OfPainter
    implements ImageResult,
    ImageAction.Success {
        @NotNull
        private final Painter painter;
        public static final int $stable;

        public OfPainter(@NotNull Painter painter) {
            Intrinsics.checkNotNullParameter(painter, "painter");
            this.painter = painter;
        }

        @NotNull
        public final Painter getPainter() {
            return this.painter;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfPainter)) {
                return false;
            }
            OfPainter ofPainter = (OfPainter)other;
            return Intrinsics.areEqual(this.painter, ofPainter.painter);
        }

        public int hashCode() {
            return this.painter.hashCode();
        }

        @NotNull
        public String toString() {
            return "OfPainter(painter=" + this.painter + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/seiko/imageloader/model/ImageResult$OfSource;", "Lcom/seiko/imageloader/model/ImageResult;", "Lcom/seiko/imageloader/model/ImageAction$Failure;", "source", "Lokio/BufferedSource;", "dataSource", "Lcom/seiko/imageloader/model/DataSource;", "extra", "", "", "", "Lcom/seiko/imageloader/model/ExtraData;", "(Lokio/BufferedSource;Lcom/seiko/imageloader/model/DataSource;Ljava/util/Map;)V", "getDataSource", "()Lcom/seiko/imageloader/model/DataSource;", "error", "", "getError", "()Ljava/lang/Throwable;", "getExtra", "()Ljava/util/Map;", "getSource", "()Lokio/BufferedSource;", "image-loader"})
    @Immutable
    public static final class OfSource
    implements ImageResult,
    ImageAction.Failure {
        @NotNull
        private final BufferedSource source;
        @NotNull
        private final DataSource dataSource;
        @NotNull
        private final Map<String, Object> extra;
        public static final int $stable;

        public OfSource(@NotNull BufferedSource source2, @NotNull DataSource dataSource, @NotNull Map<String, ? extends Object> extra) {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter((Object)dataSource, "dataSource");
            Intrinsics.checkNotNullParameter(extra, "extra");
            this.source = source2;
            this.dataSource = dataSource;
            this.extra = extra;
        }

        public /* synthetic */ OfSource(BufferedSource bufferedSource, DataSource dataSource, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                map2 = ExtraDataKt.getEmptyExtraData();
            }
            this(bufferedSource, dataSource, map2);
        }

        @NotNull
        public final BufferedSource getSource() {
            return this.source;
        }

        @NotNull
        public final DataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public final Map<String, Object> getExtra() {
            return this.extra;
        }

        @Override
        @NotNull
        public Throwable getError() {
            return new IllegalStateException("failure to decode image source");
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfSource)) {
                return false;
            }
            OfSource ofSource = (OfSource)other;
            if (!Intrinsics.areEqual(this.source, ofSource.source)) {
                return false;
            }
            if (this.dataSource != ofSource.dataSource) {
                return false;
            }
            return Intrinsics.areEqual(this.extra, ofSource.extra);
        }

        public int hashCode() {
            int result2 = this.source.hashCode();
            result2 = result2 * 31 + this.dataSource.hashCode();
            result2 = result2 * 31 + ((Object)this.extra).hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "OfSource(source=" + this.source + ", dataSource=" + this.dataSource + ", extra=" + this.extra + ")";
        }
    }
}

