/*
 * Decompiled with CFR 0.152.
 */
package com.seiko.imageloader.util;

import com.seiko.imageloader.option.Scale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u001a,\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\u001a0\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u001a0\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\r"}, d2={"calculateDstSize", "Lkotlin/Pair;", "", "srcWidth", "srcHeight", "maxImageSize", "calculateInSampleSize", "dstWidth", "dstHeight", "scale", "Lcom/seiko/imageloader/option/Scale;", "computeSizeMultiplier", "", "image-loader"})
public final class CalculateSIzeKt {
    @NotNull
    public static final Pair<Integer, Integer> calculateDstSize(int srcWidth, int srcHeight, int maxImageSize) {
        if (maxImageSize <= 0) {
            return TuplesKt.to(srcWidth, srcHeight);
        }
        int dstWidth = srcWidth;
        int dstHeight = srcHeight;
        if (Math.max(dstWidth, dstHeight) > maxImageSize) {
            if (dstWidth >= dstHeight) {
                dstHeight = (int)((float)maxImageSize / (float)srcWidth * (float)dstHeight);
                dstWidth = maxImageSize;
            } else {
                dstWidth = (int)((float)maxImageSize / (float)srcHeight * (float)dstWidth);
                dstHeight = maxImageSize;
            }
        }
        return TuplesKt.to(dstWidth, dstHeight);
    }

    public static final int calculateInSampleSize(int srcWidth, int srcHeight, int dstWidth, int dstHeight, @NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)scale2, "scale");
        int widthInSampleSize = Integer.highestOneBit(srcWidth / dstWidth);
        int heightInSampleSize = Integer.highestOneBit(srcHeight / dstHeight);
        return RangesKt.coerceAtLeast(WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()] == 1 ? Math.min(widthInSampleSize, heightInSampleSize) : Math.max(widthInSampleSize, heightInSampleSize), 1);
    }

    public static final double computeSizeMultiplier(int srcWidth, int srcHeight, int dstWidth, int dstHeight, @NotNull Scale scale2) {
        Intrinsics.checkNotNullParameter((Object)scale2, "scale");
        double widthPercent = (double)dstWidth / (double)srcWidth;
        double heightPercent = (double)dstHeight / (double)srcHeight;
        return WhenMappings.$EnumSwitchMapping$0[scale2.ordinal()] == 1 ? Math.max(widthPercent, heightPercent) : Math.min(widthPercent, heightPercent);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scale.values().length];
            try {
                nArray[Scale.FILL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

