/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateParser;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateParser;
import io.ktor.util.date.InvalidDateStringException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\n\u0010\t\u001a\u00020\u0002*\u00020\u0004\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"HTTP_DATE_FORMATS", "", "", "fromCookieToGmtDate", "Lio/ktor/util/date/GMTDate;", "fromHttpToGmtDate", "padZero", "", "length", "toHttpDate", "ktor-http"})
public final class DateUtilsKt {
    @NotNull
    private static final List<String> HTTP_DATE_FORMATS;

    @NotNull
    public static final GMTDate fromHttpToGmtDate(@NotNull String $this$fromHttpToGmtDate) {
        Intrinsics.checkNotNullParameter($this$fromHttpToGmtDate, "<this>");
        String $this$fromHttpToGmtDate_u24lambda_u240 = ((Object)StringsKt.trim((CharSequence)$this$fromHttpToGmtDate)).toString();
        boolean bl = false;
        for (String format2 : HTTP_DATE_FORMATS) {
            try {
                GMTDateParser parser2 = new GMTDateParser(format2);
                return parser2.parse($this$fromHttpToGmtDate);
            }
            catch (InvalidDateStringException invalidDateStringException) {
            }
        }
        throw new IllegalStateException(("Failed to parse date: " + $this$fromHttpToGmtDate_u24lambda_u240).toString());
    }

    @NotNull
    public static final GMTDate fromCookieToGmtDate(@NotNull String $this$fromCookieToGmtDate) {
        Intrinsics.checkNotNullParameter($this$fromCookieToGmtDate, "<this>");
        String $this$fromCookieToGmtDate_u24lambda_u241 = ((Object)StringsKt.trim((CharSequence)$this$fromCookieToGmtDate)).toString();
        boolean bl = false;
        try {
            CookieDateParser parser2 = new CookieDateParser();
            return parser2.parse($this$fromCookieToGmtDate_u24lambda_u241);
        }
        catch (InvalidCookieDateException invalidCookieDateException) {
            return DateUtilsKt.fromHttpToGmtDate($this$fromCookieToGmtDate_u24lambda_u241);
        }
    }

    @NotNull
    public static final String toHttpDate(@NotNull GMTDate $this$toHttpDate) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$toHttpDate, "<this>");
        StringBuilder $this$toHttpDate_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toHttpDate_u24lambda_u242.append($this$toHttpDate.getDayOfWeek().getValue() + ", ");
        $this$toHttpDate_u24lambda_u242.append(DateUtilsKt.padZero($this$toHttpDate.getDayOfMonth(), 2) + ' ');
        $this$toHttpDate_u24lambda_u242.append($this$toHttpDate.getMonth().getValue() + ' ');
        $this$toHttpDate_u24lambda_u242.append(DateUtilsKt.padZero($this$toHttpDate.getYear(), 4));
        $this$toHttpDate_u24lambda_u242.append(' ' + DateUtilsKt.padZero($this$toHttpDate.getHours(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getMinutes(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getSeconds(), 2) + ' ');
        $this$toHttpDate_u24lambda_u242.append("GMT");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String padZero(int $this$padZero, int length) {
        return StringsKt.padStart(String.valueOf($this$padZero), length, '0');
    }

    static {
        String[] stringArray = new String[]{"***, dd MMM YYYY hh:mm:ss zzz", "****, dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d hh:mm:ss YYYY", "***, dd-MMM-YYYY hh:mm:ss zzz", "***, dd-MMM-YYYY hh-mm-ss zzz", "***, dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh:mm:ss zzz", "*** dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh-mm-ss zzz", "***,dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d YYYY hh:mm:ss zzz"};
        HTTP_DATE_FORMATS = CollectionsKt.listOf(stringArray);
    }
}

