/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.core.BufferKt;
import io.ktor.utils.io.core.InsufficientSpaceException;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import java.io.EOFException;
import java.nio.ByteBuffer;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="\n    We're migrating to the new kotlinx-io library.\n    This declaration is deprecated and will be removed in Ktor 4.0.0\n    If you have any problems with migration, please contact us in \n    https://youtrack.jetbrains.com/issue/KTOR-6030/Migrate-to-new-kotlinx.io-library\n    ")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u0000 <2\u00020\u0001:\u0001<B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0001J\u0010\u0010!\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0015\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u0000H\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0000H\u0014J\u0006\u0010'\u001a\u00020(J\r\u0010)\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u00101\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0006J\b\u00102\u001a\u00020\u001cH\u0016J\u0006\u00103\u001a\u00020\u001cJ\u0006\u00104\u001a\u00020\u001cJ\u000e\u00104\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u00105\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\b\u00106\u001a\u000207H\u0016J\u0006\u00108\u001a\u00020\u0006J\u0006\u00109\u001a\u00020\u0006J\u000e\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020(R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0012\u0010\u0013\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u001e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0012\u0010\u0019\u001a\u00020\u00068\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006="}, d2={"Lio/ktor/utils/io/core/Buffer;", "", "memory", "Lio/ktor/utils/io/bits/Memory;", "(Ljava/nio/ByteBuffer;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "capacity", "", "getCapacity", "()I", "endGap", "getEndGap", "<set-?>", "limit", "getLimit", "getMemory-SK3TCg8", "()Ljava/nio/ByteBuffer;", "Ljava/nio/ByteBuffer;", "readPosition", "getReadPosition", "readRemaining", "getReadRemaining", "startGap", "getStartGap", "writePosition", "getWritePosition", "writeRemaining", "getWriteRemaining", "commitWritten", "", "count", "commitWrittenUntilIndex", "", "position", "discardExact", "discardUntilIndex", "discardUntilIndex$ktor_io", "duplicate", "duplicateTo", "copy", "readByte", "", "releaseEndGap", "releaseEndGap$ktor_io", "releaseGaps", "releaseGaps$ktor_io", "releaseStartGap", "newReadPosition", "releaseStartGap$ktor_io", "reserveEndGap", "reserveStartGap", "reset", "resetForRead", "resetForWrite", "rewind", "toString", "", "tryPeekByte", "tryReadByte", "writeByte", "value", "Companion", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nio/ktor/utils/io/core/Buffer\n+ 2 MemoryJvm.kt\nio/ktor/utils/io/bits/Memory\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Memory.kt\nio/ktor/utils/io/bits/MemoryKt\n*L\n1#1,472:1\n69#1:475\n69#1:476\n74#1:477\n74#1:478\n74#1:479\n69#1:480\n69#1,6:491\n59#1:497\n21#2:473\n21#2:474\n26#2:483\n26#2:485\n26#2:487\n37#2,2:489\n1#3:481\n84#4:482\n84#4:484\n84#4:486\n99#4:488\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nio/ktor/utils/io/core/Buffer\n*L\n86#1:475\n81#1:476\n94#1:477\n106#1:478\n113#1:479\n122#1:480\n333#1:491,6\n333#1:497\n53#1:473\n64#1:474\n277#1:483\n291#1:485\n307#1:487\n319#1:489,2\n277#1:482\n291#1:484\n307#1:486\n319#1:488\n*E\n"})
public class Buffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuffer memory;
    private int readPosition;
    private int writePosition;
    private int startGap;
    private int limit;
    private final int capacity;
    public static final int ReservedSize = 8;

    private Buffer(ByteBuffer memory) {
        Intrinsics.checkNotNullParameter(memory, "memory");
        ByteBuffer arg0$iv = this.memory = memory;
        boolean bl = false;
        this.limit = arg0$iv.limit();
        arg0$iv = this.memory;
        bl = false;
        this.capacity = arg0$iv.limit();
    }

    @NotNull
    public final ByteBuffer getMemory-SK3TCg8() {
        return this.memory;
    }

    public final int getReadPosition() {
        return this.readPosition;
    }

    public final int getWritePosition() {
        return this.writePosition;
    }

    public final int getStartGap() {
        return this.startGap;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final int getEndGap() {
        boolean $i$f$getEndGap = false;
        return this.getCapacity() - this.getLimit();
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getReadRemaining() {
        boolean $i$f$getReadRemaining = false;
        return this.getWritePosition() - this.getReadPosition();
    }

    public final int getWriteRemaining() {
        boolean $i$f$getWriteRemaining = false;
        return this.getLimit() - this.getWritePosition();
    }

    public final void discardExact(int count2) {
        if (count2 == 0) {
            return;
        }
        int newReadPosition = this.readPosition + count2;
        if (count2 < 0 || newReadPosition > this.writePosition) {
            Buffer this_$iv = this;
            boolean $i$f$getReadRemaining = false;
            BufferKt.discardFailed(count2, this_$iv.getWritePosition() - this_$iv.getReadPosition());
            throw new KotlinNothingValueException();
        }
        this.readPosition = newReadPosition;
    }

    public static /* synthetic */ void discardExact$default(Buffer buffer2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: discardExact");
        }
        if ((n2 & 1) != 0) {
            Buffer this_$iv = buffer2;
            boolean $i$f$getReadRemaining = false;
            n = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        }
        buffer2.discardExact(n);
    }

    public final void commitWritten(int count2) {
        int newWritePosition = this.writePosition + count2;
        if (count2 < 0 || newWritePosition > this.limit) {
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            BufferKt.commitWrittenFailed(count2, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        this.writePosition = newWritePosition;
    }

    @PublishedApi
    public final boolean commitWrittenUntilIndex(int position) {
        int limit = this.limit;
        if (position < this.writePosition) {
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            BufferKt.commitWrittenFailed(position - this.writePosition, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        if (position >= limit) {
            if (position == limit) {
                this.writePosition = position;
                return false;
            }
            Buffer this_$iv = this;
            boolean $i$f$getWriteRemaining = false;
            BufferKt.commitWrittenFailed(position - this.writePosition, this_$iv.getLimit() - this_$iv.getWritePosition());
            throw new KotlinNothingValueException();
        }
        this.writePosition = position;
        return true;
    }

    public final void discardUntilIndex$ktor_io(int position) {
        if (position < 0 || position > this.writePosition) {
            Buffer this_$iv = this;
            boolean $i$f$getReadRemaining = false;
            BufferKt.discardFailed(position - this.readPosition, this_$iv.getWritePosition() - this_$iv.getReadPosition());
            throw new KotlinNothingValueException();
        }
        if (this.readPosition != position) {
            this.readPosition = position;
        }
    }

    public final void rewind(int count2) {
        int newReadPosition = this.readPosition - count2;
        if (newReadPosition < this.startGap) {
            BufferKt.rewindFailed(count2, this.readPosition - this.startGap);
            throw new KotlinNothingValueException();
        }
        this.readPosition = newReadPosition;
    }

    public static /* synthetic */ void rewind$default(Buffer buffer2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rewind");
        }
        if ((n2 & 1) != 0) {
            n = buffer2.readPosition - buffer2.startGap;
        }
        buffer2.rewind(n);
    }

    public final void reserveStartGap(int startGap) {
        if (!(startGap >= 0)) {
            boolean bl = false;
            String string = "startGap shouldn't be negative: " + startGap;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.readPosition >= startGap) {
            this.startGap = startGap;
            return;
        }
        if (this.readPosition == this.writePosition) {
            if (startGap > this.limit) {
                BufferKt.startGapReservationFailedDueToLimit(this, startGap);
                throw new KotlinNothingValueException();
            }
            this.writePosition = startGap;
            this.readPosition = startGap;
            this.startGap = startGap;
            return;
        }
        BufferKt.startGapReservationFailed(this, startGap);
        throw new KotlinNothingValueException();
    }

    public final void reserveEndGap(int endGap) {
        if (!(endGap >= 0)) {
            boolean bl = false;
            String string = "endGap shouldn't be negative: " + endGap;
            throw new IllegalArgumentException(string.toString());
        }
        int newLimit = this.capacity - endGap;
        if (newLimit >= this.writePosition) {
            this.limit = newLimit;
            return;
        }
        if (newLimit < 0) {
            BufferKt.endGapReservationFailedDueToCapacity(this, endGap);
        }
        if (newLimit < this.startGap) {
            BufferKt.endGapReservationFailedDueToStartGap(this, endGap);
        }
        if (this.readPosition == this.writePosition) {
            this.limit = newLimit;
            this.readPosition = newLimit;
            this.writePosition = newLimit;
            return;
        }
        BufferKt.endGapReservationFailedDueToContent(this, endGap);
    }

    public final void resetForRead() {
        int capacity;
        this.startGap = 0;
        this.readPosition = 0;
        this.writePosition = capacity = this.capacity;
    }

    public final void resetForWrite() {
        this.resetForWrite(this.capacity - this.startGap);
    }

    public final void resetForWrite(int limit) {
        int startGap;
        this.readPosition = startGap = this.startGap;
        this.writePosition = startGap;
        this.limit = limit;
    }

    public final void releaseGaps$ktor_io() {
        this.releaseStartGap$ktor_io(0);
        this.releaseEndGap$ktor_io();
    }

    public final void releaseEndGap$ktor_io() {
        this.limit = this.capacity;
    }

    public final void releaseStartGap$ktor_io(int newReadPosition) {
        if (!(newReadPosition >= 0)) {
            boolean $i$a$-require-Buffer$releaseStartGap$32 = false;
            String $i$a$-require-Buffer$releaseStartGap$32 = "newReadPosition shouldn't be negative: " + newReadPosition;
            throw new IllegalArgumentException($i$a$-require-Buffer$releaseStartGap$32.toString());
        }
        if (!(newReadPosition <= this.readPosition)) {
            boolean bl = false;
            String string = "newReadPosition shouldn't be ahead of the read position: " + newReadPosition + " > " + this.readPosition;
            throw new IllegalArgumentException(string.toString());
        }
        this.readPosition = newReadPosition;
        if (this.startGap > newReadPosition) {
            this.startGap = newReadPosition;
        }
    }

    protected void duplicateTo(@NotNull Buffer copy2) {
        Intrinsics.checkNotNullParameter(copy2, "copy");
        copy2.limit = this.limit;
        copy2.startGap = this.startGap;
        copy2.readPosition = this.readPosition;
        copy2.writePosition = this.writePosition;
    }

    @NotNull
    public Buffer duplicate() {
        Buffer buffer2;
        Buffer $this$duplicate_u24lambda_u244 = buffer2 = new Buffer(this.memory, null);
        boolean bl = false;
        $this$duplicate_u24lambda_u244.duplicateTo($this$duplicate_u24lambda_u244);
        return buffer2;
    }

    public final int tryPeekByte() {
        int readPosition = this.readPosition;
        if (readPosition == this.writePosition) {
            return -1;
        }
        ByteBuffer $this$get_u2deY85DW0$iv = this.memory;
        boolean bl = false;
        boolean bl2 = false;
        return $this$get_u2deY85DW0$iv.get(readPosition) & 0xFF;
    }

    public final int tryReadByte() {
        int readPosition = this.readPosition;
        if (readPosition == this.writePosition) {
            return -1;
        }
        this.readPosition = readPosition + 1;
        ByteBuffer $this$get_u2deY85DW0$iv = this.memory;
        boolean bl = false;
        boolean bl2 = false;
        return $this$get_u2deY85DW0$iv.get(readPosition) & 0xFF;
    }

    public final byte readByte() {
        int readPosition = this.readPosition;
        if (readPosition == this.writePosition) {
            throw new EOFException("No readable bytes available.");
        }
        this.readPosition = readPosition + 1;
        ByteBuffer $this$get_u2deY85DW0$iv = this.memory;
        boolean bl = false;
        boolean bl2 = false;
        return $this$get_u2deY85DW0$iv.get(readPosition);
    }

    public final void writeByte(byte value) {
        int writePosition = this.writePosition;
        if (writePosition == this.limit) {
            throw new InsufficientSpaceException("No free space in the buffer to write a byte");
        }
        ByteBuffer $this$set_u2d62zg_DM$iv = this.memory;
        boolean bl = false;
        boolean bl2 = false;
        $this$set_u2d62zg_DM$iv.put(writePosition, value);
        this.writePosition = writePosition + 1;
    }

    public void reset() {
        this.releaseGaps$ktor_io();
        this.resetForWrite();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Buffer[0x");
        String string = Integer.toString(this.hashCode(), CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
        Buffer this_$iv = this;
        boolean $i$f$getReadRemaining = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string).append("](").append(this_$iv.getWritePosition() - this_$iv.getReadPosition()).append(" used, ");
        this_$iv = this;
        boolean $i$f$getWriteRemaining = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(this_$iv.getLimit() - this_$iv.getWritePosition()).append(" free, ");
        this_$iv = this;
        boolean $i$f$getEndGap = false;
        return stringBuilder3.append(this.startGap + (this_$iv.getCapacity() - this_$iv.getLimit())).append(" reserved of ").append(this.capacity).append(')').toString();
    }

    public /* synthetic */ Buffer(ByteBuffer memory, DefaultConstructorMarker $constructor_marker) {
        this(memory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ktor/utils/io/core/Buffer$Companion;", "", "()V", "Empty", "Lio/ktor/utils/io/core/Buffer;", "getEmpty", "()Lio/ktor/utils/io/core/Buffer;", "ReservedSize", "", "ktor-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Buffer getEmpty() {
            return ChunkBuffer.Companion.getEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

