/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.internal.DivRemResult;
import kotlinx.datetime.internal.MathJvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\b\u001a\u0019\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0082\b\u001a\u0011\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\b\u001a(\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a \u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0000\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0018\u001a\u00020\n*\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0019"}, d2={"POWERS_OF_TEN", "", "getPOWERS_OF_TEN", "()[I", "high", "", "x", "indexBit", "value", "bit", "", "low", "multiplyAddAndDivide", "d", "n", "r", "m", "multiplyAndAdd", "multiplyAndDivide", "Lkotlinx/datetime/internal/DivRemResult;", "a", "b", "c", "safeMultiplyOrZero", "clampToInt", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nmath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/MathKt\n*L\n1#1,241:1\n133#1:242\n135#1:243\n133#1:244\n135#1:245\n133#1:246\n133#1,3:247\n133#1:250\n135#1:251\n133#1,3:252\n133#1:255\n135#1:256\n133#1:257\n138#1:258\n138#1:259\n*S KotlinDebug\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/MathKt\n*L\n66#1:242\n67#1:243\n68#1:244\n69#1:245\n80#1:246\n81#1:247,3\n82#1:250\n83#1:251\n83#1:252,3\n84#1:255\n87#1:256\n87#1:257\n93#1:258\n111#1:259\n*E\n"})
public final class MathKt {
    @NotNull
    private static final int[] POWERS_OF_TEN;

    public static final int clampToInt(long $this$clampToInt) {
        return $this$clampToInt > Integer.MAX_VALUE ? Integer.MAX_VALUE : ($this$clampToInt < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)$this$clampToInt);
    }

    public static final long safeMultiplyOrZero(long a, long b) {
        long l = b;
        if (l == -1L) {
            if (a == Long.MIN_VALUE) {
                return 0L;
            }
            return -a;
        }
        if (l == 1L) {
            return a;
        }
        long total = a * b;
        if (total / b != a) {
            return 0L;
        }
        return total;
    }

    @NotNull
    public static final DivRemResult multiplyAndDivide(long a, long b, long c) {
        int sign2;
        if (a == 0L || b == 0L) {
            return new DivRemResult(0L, 0L);
        }
        long ab = MathKt.safeMultiplyOrZero(a, b);
        if (ab != 0L) {
            return new DivRemResult(ab / c, ab % c);
        }
        if (b == c) {
            return new DivRemResult(a, 0L);
        }
        if (a == c) {
            return new DivRemResult(b, 0L);
        }
        long ae = a >= 0L ? 0L : -1L;
        long be = b >= 0L ? 0L : -1L;
        boolean $i$f$low = false;
        long al = a & 0xFFFFFFFFL;
        boolean $i$f$high = false;
        long ah = a >> 32 & 0xFFFFFFFFL;
        boolean $i$f$low2 = false;
        long bl = b & 0xFFFFFFFFL;
        boolean $i$f$high2 = false;
        long bh = b >> 32 & 0xFFFFFFFFL;
        long w = ae * bh + ah * be;
        long x2 = ae * bl + ah * bh + al * be;
        long y1 = ah * bl;
        long y2 = al * bh;
        long z = al * bl;
        boolean $i$f$low3 = false;
        long r4 = z & 0xFFFFFFFFL;
        boolean $i$f$low4 = false;
        $i$f$low4 = false;
        boolean $i$f$high3 = false;
        long r3c = (y1 & 0xFFFFFFFFL) + (y2 & 0xFFFFFFFFL) + (z >> 32 & 0xFFFFFFFFL);
        boolean $i$f$low5 = false;
        long r3 = r3c & 0xFFFFFFFFL;
        boolean $i$f$high4 = false;
        boolean $i$f$low6 = false;
        $i$f$high4 = false;
        $i$f$high4 = false;
        long r2c = (r3c >> 32 & 0xFFFFFFFFL) + (x2 & 0xFFFFFFFFL) + (y1 >> 32 & 0xFFFFFFFFL) + (y2 >> 32 & 0xFFFFFFFFL);
        boolean $i$f$low7 = false;
        long r2 = r2c & 0xFFFFFFFFL;
        boolean $i$f$high5 = false;
        $i$f$high5 = false;
        boolean $i$f$low8 = false;
        long r1 = (r2c >> 32 & 0xFFFFFFFFL) + (x2 >> 32 & 0xFFFFFFFFL) + (w & 0xFFFFFFFFL);
        long abl = r3 << 32 | r4;
        long abh = r1 << 32 | r2;
        int bit$iv = 63;
        boolean $i$f$indexBit = false;
        int n = sign2 = (abh >> bit$iv & 1L) == 1L ? -1 : 1;
        if (sign2 == -1) {
            abl = (abl ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
            abh ^= 0xFFFFFFFFFFFFFFFFL;
            if (abl == 0L) {
                ++abh;
            }
        }
        long q = 0L;
        long r = 0L;
        for (int bitNo = 127; -1 < bitNo; --bitNo) {
            long l;
            if (bitNo < 64) {
                boolean $i$f$indexBit2 = false;
                l = abl >> bitNo & 1L;
            } else {
                int bit$iv2 = bitNo - 64;
                boolean $i$f$indexBit3 = false;
                l = abh >> bit$iv2 & 1L;
            }
            long nextBit = l;
            r = r << 1 | nextBit;
            if (r < c && r >= 0L) continue;
            r -= c;
            if (bitNo < 63) {
                q |= 1L << bitNo;
                continue;
            }
            throw new ArithmeticException("The result of a multiplication followed by division overflows a long");
        }
        return new DivRemResult((long)sign2 * q, (long)sign2 * r);
    }

    private static final long low(long x2) {
        boolean $i$f$low = false;
        return x2 & 0xFFFFFFFFL;
    }

    private static final long high(long x2) {
        boolean $i$f$high = false;
        return x2 >> 32 & 0xFFFFFFFFL;
    }

    private static final long indexBit(long value, int bit) {
        boolean $i$f$indexBit = false;
        return value >> bit & 1L;
    }

    public static final long multiplyAddAndDivide(long d, long n, long r, long m4) {
        long l;
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            l = md;
            md = l + -1L;
            mr += n;
        } else if (d < 0L && r > 0L) {
            l = md;
            md = l + 1L;
            mr -= n;
        }
        if (md == 0L) {
            return mr / m4;
        }
        DivRemResult divRemResult = MathKt.multiplyAndDivide(md, n, m4);
        long rd = divRemResult.component1();
        long rr = divRemResult.component2();
        return MathJvmKt.safeAdd(rd, MathJvmKt.safeAdd(mr / m4, MathJvmKt.safeAdd(mr % m4, rr) / m4));
    }

    public static final long multiplyAndAdd(long d, long n, long r) {
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            long l = md;
            md = l + -1L;
            mr += n;
        } else if (d < 0L && r > 0L) {
            long l = md;
            md = l + 1L;
            mr -= n;
        }
        return MathJvmKt.safeAdd(MathJvmKt.safeMultiply(md, n), mr);
    }

    @NotNull
    public static final int[] getPOWERS_OF_TEN() {
        return POWERS_OF_TEN;
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POWERS_OF_TEN = nArray;
    }
}

