/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.formatter;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/datetime/internal/format/formatter/SignedIntFormatterStructure;", "T", "Lkotlinx/datetime/internal/format/formatter/FormatterStructure;", "number", "Lkotlin/Function1;", "", "zeroPadding", "outputPlusOnExceededWidth", "(Lkotlin/jvm/functions/Function1;ILjava/lang/Integer;)V", "Ljava/lang/Integer;", "format", "", "obj", "builder", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "minusNotRequired", "", "(Ljava/lang/Object;Ljava/lang/Appendable;Z)V", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nFormatterOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormatterOperation.kt\nkotlinx/datetime/internal/format/formatter/SignedIntFormatterStructure\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class SignedIntFormatterStructure<T>
implements FormatterStructure<T> {
    @NotNull
    private final Function1<T, Integer> number;
    private final int zeroPadding;
    @Nullable
    private final Integer outputPlusOnExceededWidth;

    public SignedIntFormatterStructure(@NotNull Function1<? super T, Integer> number, int zeroPadding, @Nullable Integer outputPlusOnExceededWidth) {
        Intrinsics.checkNotNullParameter(number, "number");
        this.number = number;
        this.zeroPadding = zeroPadding;
        this.outputPlusOnExceededWidth = outputPlusOnExceededWidth;
        if (!(this.zeroPadding >= 0)) {
            boolean $i$a$-require-SignedIntFormatterStructure$32 = false;
            String $i$a$-require-SignedIntFormatterStructure$32 = "The minimum number of digits (" + this.zeroPadding + ") is negative";
            throw new IllegalArgumentException($i$a$-require-SignedIntFormatterStructure$32.toString());
        }
        if (!(this.zeroPadding <= 9)) {
            boolean bl = false;
            String string = "The minimum number of digits (" + this.zeroPadding + ") exceeds the length of an Int";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void format(T obj, @NotNull Appendable builder, boolean minusNotRequired) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        StringBuilder innerBuilder = new StringBuilder();
        int it = ((Number)this.number.invoke(obj)).intValue();
        boolean bl = false;
        int number = minusNotRequired && it < 0 ? -it : it;
        if (this.outputPlusOnExceededWidth != null && number >= MathKt.getPOWERS_OF_TEN()[this.outputPlusOnExceededWidth]) {
            innerBuilder.append('+');
        }
        if (Math.abs(number) < MathKt.getPOWERS_OF_TEN()[this.zeroPadding - 1]) {
            int n;
            if (number >= 0) {
                StringBuilder stringBuilder = innerBuilder.append(number + MathKt.getPOWERS_OF_TEN()[this.zeroPadding]);
                Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
                StringBuilder stringBuilder2 = stringBuilder;
                n = 0;
                Intrinsics.checkNotNullExpressionValue(stringBuilder2.deleteCharAt(n), "deleteCharAt(...)");
            } else {
                StringBuilder stringBuilder = innerBuilder.append(number - MathKt.getPOWERS_OF_TEN()[this.zeroPadding]);
                Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
                StringBuilder stringBuilder3 = stringBuilder;
                n = 1;
                Intrinsics.checkNotNullExpressionValue(stringBuilder3.deleteCharAt(n), "deleteCharAt(...)");
            }
        } else {
            innerBuilder.append(number);
        }
        builder.append(innerBuilder);
    }
}

