/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.parser.AssignableField;
import kotlinx.datetime.internal.format.parser.NumberConsumer;
import kotlinx.datetime.internal.format.parser.NumberConsumerKt;
import kotlinx.datetime.internal.format.parser.NumberConsumptionError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/datetime/internal/format/parser/ReducedIntConsumer;", "Receiver", "Lkotlinx/datetime/internal/format/parser/NumberConsumer;", "length", "", "setter", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "name", "", "base", "(ILkotlinx/datetime/internal/format/parser/AssignableField;Ljava/lang/String;I)V", "getBase", "()I", "baseFloor", "baseMod", "getLength", "()Ljava/lang/Integer;", "modulo", "consume", "Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "storage", "input", "(Ljava/lang/Object;Ljava/lang/String;)Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "kotlinx-datetime"})
public final class ReducedIntConsumer<Receiver>
extends NumberConsumer<Receiver> {
    private final int length;
    @NotNull
    private final AssignableField<Receiver, Integer> setter;
    private final int base;
    private final int modulo;
    private final int baseMod;
    private final int baseFloor;

    public ReducedIntConsumer(int length, @NotNull AssignableField<? super Receiver, Integer> setter, @NotNull String name, int base) {
        Intrinsics.checkNotNullParameter(setter, "setter");
        Intrinsics.checkNotNullParameter(name, "name");
        super(length, name, null);
        this.length = length;
        this.setter = setter;
        this.base = base;
        this.modulo = MathKt.getPOWERS_OF_TEN()[this.getLength()];
        this.baseMod = this.base % this.modulo;
        this.baseFloor = this.base - this.baseMod;
    }

    @Override
    @NotNull
    public Integer getLength() {
        return this.length;
    }

    public final int getBase() {
        return this.base;
    }

    @Override
    @Nullable
    public NumberConsumptionError consume(Receiver storage, @NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Integer result2 = StringsKt.toIntOrNull(input);
        return result2 == null ? (NumberConsumptionError)NumberConsumptionError.ExpectedInt.INSTANCE : NumberConsumerKt.access$setWithoutReassigning(this.setter, storage, result2 >= this.baseMod ? this.baseFloor + result2 : this.baseFloor + this.modulo + result2);
    }
}

