/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.channel;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import me.fan87.pixelmongo.ui.channel.CommunicationModule;
import me.fan87.pixelmongo.ui.channel.impl.BoutiqueGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.CalendarGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.CombatPassGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.FusionGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.GamblingGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.PlayTimeGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.RankGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.RewardGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.SCMGuiHandler;
import me.fan87.pixelmongo.ui.channel.impl.VoteGuiHandler;
import me.fan87.pixelmongo.ui.events.PacketReadEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tech.fandiful.grpcpacketchannel.impl.client.GrpcPacketChannel;
import tech.fandiful.grpcpacketchannel.impl.server.GrpcPacketServer;
import tech.fandiful.javamodular.AbstractModule;
import tech.fandiful.javamodular.CustomModuleLoader;

public class PixelmonGoCommunication
extends AbstractModule {
    private final CustomModuleLoader<CommunicationModule> loader = new CustomModuleLoader();
    private GrpcPacketChannel packetChannel;
    private GrpcPacketServer packetServer;
    private GrpcPacketChannel packetChannelForge;
    private GrpcPacketServer packetServerForge;
    private final BoutiqueGuiHandler boutiqueGuiHandler = this.loader.addModule(new BoutiqueGuiHandler());

    public PixelmonGoCommunication() {
        this.loader.addModule(new RewardGuiHandler());
        this.loader.addModule(new RankGuiHandler());
        this.loader.addModule(new CalendarGuiHandler());
        this.loader.addModule(new SCMGuiHandler());
        this.loader.addModule(new VoteGuiHandler());
        this.loader.addModule(new GamblingGuiHandler());
        this.loader.addModule(new PlayTimeGuiHandler());
        this.loader.addModule(new FusionGuiHandler());
        this.loader.addModule(new CombatPassGuiHandler());
    }

    @Override
    protected void onLoad() {
        this.packetChannel = new GrpcPacketChannel(UUID.randomUUID().toString(), 20000, it -> {
            Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("pixelmongoui:client_to_server"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])it))));
            return null;
        });
        this.packetServer = new GrpcPacketServer(20000, it -> {
            Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("pixelmongoui:server_to_client"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])it))));
            return null;
        });
        this.packetChannelForge = new GrpcPacketChannel(UUID.randomUUID().toString(), 20000, it -> {
            Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("pixelmongoui:client_to_server_channel_a"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])it))));
            return null;
        });
        this.packetServerForge = new GrpcPacketServer(20000, it -> {
            Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("pixelmongoui:server_to_client_channel_b"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])it))));
            return null;
        });
        for (CommunicationModule module : this.loader.getModules()) {
            module.setChannel(this.getPacketChannel());
            module.setServer(this.getPacketServer());
            module.setChannelForge(this.getPacketChannelForge());
            module.setServerForge(this.getPacketServerForge());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loader.load();
    }

    @Override
    protected void onUnload() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.loader.unload();
    }

    @SubscribeEvent
    public void sendRegistryPackets(ClientPlayerNetworkEvent.LoggedInEvent event) {
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("minecraft", "register"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])"pixelmongoui:client_to_server".getBytes(StandardCharsets.UTF_8)))));
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a((IPacket)new CCustomPayloadPacket(new ResourceLocation("minecraft", "register"), new PacketBuffer(Unpooled.wrappedBuffer((byte[])"pixelmongoui:server_to_client".getBytes(StandardCharsets.UTF_8)))));
    }

    @SubscribeEvent
    public void onCustomPayload(PacketReadEvent event) {
        IPacket<?> packet = event.getPacket();
        if (packet instanceof SCustomPayloadPlayPacket) {
            byte[] data2;
            PacketBuffer bytes;
            SCustomPayloadPlayPacket typed = (SCustomPayloadPlayPacket)packet;
            if (typed.func_149169_c().toString().equals("pixelmongoui:client_to_server")) {
                bytes = typed.func_180735_b();
                data2 = new byte[bytes.writerIndex()];
                bytes.readBytes(data2);
                this.packetChannel.submitData(data2);
            }
            if (typed.func_149169_c().toString().equals("pixelmongoui:server_to_client")) {
                bytes = typed.func_180735_b();
                data2 = new byte[bytes.writerIndex()];
                bytes.readBytes(data2);
                this.packetServer.submitData(data2);
            }
            if (typed.func_149169_c().toString().equals("pixelmongoui:client_to_server_channel_a")) {
                bytes = typed.func_180735_b();
                data2 = new byte[bytes.writerIndex()];
                bytes.readBytes(data2);
                this.packetChannelForge.submitData(data2);
            }
            if (typed.func_149169_c().toString().equals("pixelmongoui:server_to_client_channel_b")) {
                bytes = typed.func_180735_b();
                data2 = new byte[bytes.writerIndex()];
                bytes.readBytes(data2);
                this.packetServerForge.submitData(data2);
            }
        }
    }

    public GrpcPacketChannel getPacketChannel() {
        return this.packetChannel;
    }

    public GrpcPacketServer getPacketServer() {
        return this.packetServer;
    }

    public GrpcPacketChannel getPacketChannelForge() {
        return this.packetChannelForge;
    }

    public GrpcPacketServer getPacketServerForge() {
        return this.packetServerForge;
    }

    public BoutiqueGuiHandler getBoutiqueGuiHandler() {
        return this.boutiqueGuiHandler;
    }
}

