/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import me.fan87.pixelmongo.ui.com.google.protobuf.Internal;

abstract class AbstractProtobufList<E>
extends AbstractList<E>
implements Internal.ProtobufList<E> {
    protected static final int DEFAULT_CAPACITY = 10;
    private boolean isMutable;

    AbstractProtobufList() {
        this(true);
    }

    AbstractProtobufList(boolean isMutable) {
        this.isMutable = isMutable;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (!(o instanceof RandomAccess)) {
            return super.equals(o);
        }
        List other = (List)o;
        int size2 = this.size();
        if (size2 != other.size()) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int size2 = this.size();
        int hashCode = 1;
        for (int i = 0; i < size2; ++i) {
            hashCode = 31 * hashCode + this.get(i).hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean add(E e) {
        this.ensureIsMutable();
        return super.add(e);
    }

    @Override
    public void add(int index2, E element) {
        this.ensureIsMutable();
        super.add(index2, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.ensureIsMutable();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends E> c) {
        this.ensureIsMutable();
        return super.addAll(index2, c);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        super.clear();
    }

    @Override
    public boolean isModifiable() {
        return this.isMutable;
    }

    @Override
    public final void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    @Override
    public E remove(int index2) {
        this.ensureIsMutable();
        return super.remove(index2);
    }

    @Override
    public boolean remove(Object o) {
        this.ensureIsMutable();
        int index2 = this.indexOf(o);
        if (index2 == -1) {
            return false;
        }
        this.remove(index2);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.ensureIsMutable();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.ensureIsMutable();
        return super.retainAll(c);
    }

    @Override
    public E set(int index2, E element) {
        this.ensureIsMutable();
        return super.set(index2, element);
    }

    protected void ensureIsMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }
}

