/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.nio.ByteBuffer;
import me.fan87.pixelmongo.ui.com.google.protobuf.CanIgnoreReturnValue;
import me.fan87.pixelmongo.ui.com.google.protobuf.CheckReturnValue;
import me.fan87.pixelmongo.ui.com.google.protobuf.Internal;
import me.fan87.pixelmongo.ui.com.google.protobuf.Java8Compatibility;

@CheckReturnValue
abstract class AllocatedBuffer {
    AllocatedBuffer() {
    }

    public abstract boolean hasNioBuffer();

    public abstract boolean hasArray();

    public abstract ByteBuffer nioBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract int position();

    @CanIgnoreReturnValue
    public abstract AllocatedBuffer position(int var1);

    public abstract int limit();

    public abstract int remaining();

    public static AllocatedBuffer wrap(byte[] bytes) {
        return AllocatedBuffer.wrapNoCheck(bytes, 0, bytes.length);
    }

    public static AllocatedBuffer wrap(byte[] bytes, int offset2, int length) {
        if (offset2 < 0 || length < 0 || offset2 + length > bytes.length) {
            throw new IndexOutOfBoundsException(String.format("bytes.length=%d, offset=%d, length=%d", bytes.length, offset2, length));
        }
        return AllocatedBuffer.wrapNoCheck(bytes, offset2, length);
    }

    public static AllocatedBuffer wrap(final ByteBuffer buffer2) {
        Internal.checkNotNull(buffer2, "buffer");
        return new AllocatedBuffer(){

            @Override
            public boolean hasNioBuffer() {
                return true;
            }

            @Override
            public ByteBuffer nioBuffer() {
                return buffer2;
            }

            @Override
            public boolean hasArray() {
                return buffer2.hasArray();
            }

            @Override
            public byte[] array() {
                return buffer2.array();
            }

            @Override
            public int arrayOffset() {
                return buffer2.arrayOffset();
            }

            @Override
            public int position() {
                return buffer2.position();
            }

            @Override
            public AllocatedBuffer position(int position) {
                Java8Compatibility.position(buffer2, position);
                return this;
            }

            @Override
            public int limit() {
                return buffer2.limit();
            }

            @Override
            public int remaining() {
                return buffer2.remaining();
            }
        };
    }

    private static AllocatedBuffer wrapNoCheck(final byte[] bytes, final int offset2, final int length) {
        return new AllocatedBuffer(){
            private int position;

            @Override
            public boolean hasNioBuffer() {
                return false;
            }

            @Override
            public ByteBuffer nioBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasArray() {
                return true;
            }

            @Override
            public byte[] array() {
                return bytes;
            }

            @Override
            public int arrayOffset() {
                return offset2;
            }

            @Override
            public int position() {
                return this.position;
            }

            @Override
            public AllocatedBuffer position(int position) {
                if (position < 0 || position > length) {
                    throw new IllegalArgumentException("Invalid position: " + position);
                }
                this.position = position;
                return this;
            }

            @Override
            public int limit() {
                return length;
            }

            @Override
            public int remaining() {
                return length - this.position;
            }
        };
    }
}

