/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import me.fan87.pixelmongo.ui.com.google.protobuf.AbstractProtobufList;
import me.fan87.pixelmongo.ui.com.google.protobuf.Internal;
import me.fan87.pixelmongo.ui.com.google.protobuf.PrimitiveNonBoxingCollection;

final class FloatArrayList
extends AbstractProtobufList<Float>
implements Internal.FloatList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final FloatArrayList EMPTY_LIST = new FloatArrayList(new float[0], 0, false);
    private float[] array;
    private int size;

    public static FloatArrayList emptyList() {
        return EMPTY_LIST;
    }

    FloatArrayList() {
        this(new float[10], 0, true);
    }

    private FloatArrayList(float[] other, int size2, boolean isMutable) {
        super(isMutable);
        this.array = other;
        this.size = size2;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatArrayList)) {
            return super.equals(o);
        }
        FloatArrayList other = (FloatArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        float[] arr = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.array[i]) == Float.floatToIntBits(arr[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.size; ++i) {
            result2 = 31 * result2 + Float.floatToIntBits(this.array[i]);
        }
        return result2;
    }

    @Override
    public Internal.FloatList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new FloatArrayList(Arrays.copyOf(this.array, capacity), this.size, true);
    }

    @Override
    public Float get(int index2) {
        return Float.valueOf(this.getFloat(index2));
    }

    @Override
    public float getFloat(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public int indexOf(Object element) {
        if (!(element instanceof Float)) {
            return -1;
        }
        float unboxedElement = ((Float)element).floatValue();
        int numElems = this.size();
        for (int i = 0; i < numElems; ++i) {
            if (this.array[i] != unboxedElement) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float set(int index2, Float element) {
        return Float.valueOf(this.setFloat(index2, element.floatValue()));
    }

    @Override
    public float setFloat(int index2, float element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        float previousValue = this.array[index2];
        this.array[index2] = element;
        return previousValue;
    }

    @Override
    public boolean add(Float element) {
        this.addFloat(element.floatValue());
        return true;
    }

    @Override
    public void add(int index2, Float element) {
        this.addFloat(index2, element.floatValue());
    }

    @Override
    public void addFloat(float element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int length = this.size * 3 / 2 + 1;
            float[] newArray = new float[length];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
        this.array[this.size++] = element;
    }

    private void addFloat(int index2, float element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length = this.size * 3 / 2 + 1;
            float[] newArray = new float[length];
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof FloatArrayList)) {
            return super.addAll(collection);
        }
        FloatArrayList list2 = (FloatArrayList)collection;
        if (list2.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list2.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list2.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Float remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        float value = this.array[index2];
        if (index2 < this.size - 1) {
            System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2 - 1);
        }
        --this.size;
        ++this.modCount;
        return Float.valueOf(value);
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }
}

