/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import me.fan87.pixelmongo.ui.com.google.protobuf.AbstractProtobufList;
import me.fan87.pixelmongo.ui.com.google.protobuf.Internal;
import me.fan87.pixelmongo.ui.com.google.protobuf.PrimitiveNonBoxingCollection;

final class LongArrayList
extends AbstractProtobufList<Long>
implements Internal.LongList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final LongArrayList EMPTY_LIST = new LongArrayList(new long[0], 0, false);
    private long[] array;
    private int size;

    public static LongArrayList emptyList() {
        return EMPTY_LIST;
    }

    LongArrayList() {
        this(new long[10], 0, true);
    }

    private LongArrayList(long[] other, int size2, boolean isMutable) {
        super(isMutable);
        this.array = other;
        this.size = size2;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongArrayList)) {
            return super.equals(o);
        }
        LongArrayList other = (LongArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        long[] arr = other.array;
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == arr[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.size; ++i) {
            result2 = 31 * result2 + Internal.hashLong(this.array[i]);
        }
        return result2;
    }

    @Override
    public Internal.LongList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new LongArrayList(Arrays.copyOf(this.array, capacity), this.size, true);
    }

    @Override
    public Long get(int index2) {
        return this.getLong(index2);
    }

    @Override
    public long getLong(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public int indexOf(Object element) {
        if (!(element instanceof Long)) {
            return -1;
        }
        long unboxedElement = (Long)element;
        int numElems = this.size();
        for (int i = 0; i < numElems; ++i) {
            if (this.array[i] != unboxedElement) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Long set(int index2, Long element) {
        return this.setLong(index2, element);
    }

    @Override
    public long setLong(int index2, long element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        long previousValue = this.array[index2];
        this.array[index2] = element;
        return previousValue;
    }

    @Override
    public boolean add(Long element) {
        this.addLong(element);
        return true;
    }

    @Override
    public void add(int index2, Long element) {
        this.addLong(index2, element);
    }

    @Override
    public void addLong(long element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int length = this.size * 3 / 2 + 1;
            long[] newArray = new long[length];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
        this.array[this.size++] = element;
    }

    private void addLong(int index2, long element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length = this.size * 3 / 2 + 1;
            long[] newArray = new long[length];
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Long> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof LongArrayList)) {
            return super.addAll(collection);
        }
        LongArrayList list2 = (LongArrayList)collection;
        if (list2.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list2.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list2.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Long remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        long value = this.array[index2];
        if (index2 < this.size - 1) {
            System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2 - 1);
        }
        --this.size;
        ++this.modCount;
        return value;
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }
}

