/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.fan87.pixelmongo.ui.com.google.protobuf.AbstractMessage;
import me.fan87.pixelmongo.ui.com.google.protobuf.MapEntry;
import me.fan87.pixelmongo.ui.com.google.protobuf.MapField;
import me.fan87.pixelmongo.ui.com.google.protobuf.MapFieldLite;
import me.fan87.pixelmongo.ui.com.google.protobuf.MapFieldReflectionAccessor;
import me.fan87.pixelmongo.ui.com.google.protobuf.Message;
import me.fan87.pixelmongo.ui.com.google.protobuf.MessageOrBuilder;
import me.fan87.pixelmongo.ui.com.google.protobuf.MutabilityOracle;

public class MapFieldBuilder<KeyT, MessageOrBuilderT extends MessageOrBuilder, MessageT extends MessageOrBuilderT, BuilderT extends MessageOrBuilderT>
extends MapFieldReflectionAccessor {
    Map<KeyT, MessageOrBuilderT> builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>();
    Map<KeyT, MessageT> messageMap = null;
    List<Message> messageList = null;
    Converter<KeyT, MessageOrBuilderT, MessageT> converter;

    public MapFieldBuilder(Converter<KeyT, MessageOrBuilderT, MessageT> converter) {
        this.converter = converter;
    }

    private List<MapEntry<KeyT, MessageT>> getMapEntryList() {
        ArrayList<MapEntry<KeyT, MessageT>> list2 = new ArrayList<MapEntry<KeyT, MessageT>>(this.messageList.size());
        Class<?> valueClass = ((MessageOrBuilder)this.converter.defaultEntry().getValue()).getClass();
        for (Message entry2 : this.messageList) {
            MapEntry typedEntry = (MapEntry)entry2;
            if (valueClass.isInstance(typedEntry.getValue())) {
                list2.add(typedEntry);
                continue;
            }
            list2.add((MapEntry<KeyT, MessageT>)((MapEntry.Builder)((AbstractMessage.Builder)this.converter.defaultEntry().toBuilder()).mergeFrom(entry2)).build());
        }
        return list2;
    }

    public Map<KeyT, MessageOrBuilderT> ensureBuilderMap() {
        if (this.builderMap != null) {
            return this.builderMap;
        }
        if (this.messageMap != null) {
            this.builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>(this.messageMap.size());
            for (Map.Entry<KeyT, MessageT> entry2 : this.messageMap.entrySet()) {
                this.builderMap.put(entry2.getKey(), (MessageOrBuilder)entry2.getValue());
            }
            this.messageMap = null;
            return this.builderMap;
        }
        this.builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>(this.messageList.size());
        for (MapEntry<KeyT, MessageT> entry3 : this.getMapEntryList()) {
            this.builderMap.put(entry3.getKey(), (MessageOrBuilder)entry3.getValue());
        }
        this.messageList = null;
        return this.builderMap;
    }

    public List<Message> ensureMessageList() {
        if (this.messageList != null) {
            return this.messageList;
        }
        if (this.builderMap != null) {
            this.messageList = new ArrayList<Message>(this.builderMap.size());
            for (Map.Entry<KeyT, MessageOrBuilderT> entry2 : this.builderMap.entrySet()) {
                this.messageList.add(((MapEntry.Builder)this.converter.defaultEntry().toBuilder()).setKey(entry2.getKey()).setValue(this.converter.build((MessageOrBuilder)entry2.getValue())).build());
            }
            this.builderMap = null;
            return this.messageList;
        }
        this.messageList = new ArrayList<Message>(this.messageMap.size());
        for (Map.Entry<KeyT, MessageT> entry3 : this.messageMap.entrySet()) {
            this.messageList.add(((MapEntry.Builder)this.converter.defaultEntry().toBuilder()).setKey(entry3.getKey()).setValue((MessageOrBuilder)entry3.getValue()).build());
        }
        this.messageMap = null;
        return this.messageList;
    }

    public Map<KeyT, MessageT> ensureMessageMap() {
        this.messageMap = this.populateMutableMap();
        this.builderMap = null;
        this.messageList = null;
        return this.messageMap;
    }

    public Map<KeyT, MessageT> getImmutableMap() {
        return new MapField.MutabilityAwareMap<KeyT, MessageT>(MutabilityOracle.IMMUTABLE, this.populateMutableMap());
    }

    private Map<KeyT, MessageT> populateMutableMap() {
        if (this.messageMap != null) {
            return this.messageMap;
        }
        if (this.builderMap != null) {
            LinkedHashMap<KeyT, MessageT> toReturn = new LinkedHashMap<KeyT, MessageT>(this.builderMap.size());
            for (Map.Entry<KeyT, MessageOrBuilderT> entry2 : this.builderMap.entrySet()) {
                toReturn.put(entry2.getKey(), this.converter.build((MessageOrBuilder)entry2.getValue()));
            }
            return toReturn;
        }
        LinkedHashMap<KeyT, MessageOrBuilder> toReturn = new LinkedHashMap<KeyT, MessageOrBuilder>(this.messageList.size());
        for (MapEntry<KeyT, MessageT> entry3 : this.getMapEntryList()) {
            toReturn.put(entry3.getKey(), (MessageOrBuilder)entry3.getValue());
        }
        return toReturn;
    }

    public void mergeFrom(MapField<KeyT, MessageT> other) {
        this.ensureBuilderMap().putAll(MapFieldLite.copy(other.getMap()));
    }

    public void clear() {
        this.builderMap = new LinkedHashMap<KeyT, MessageOrBuilderT>();
        this.messageMap = null;
        this.messageList = null;
    }

    private boolean typedEquals(MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT> other) {
        return MapFieldLite.equals(this.ensureBuilderMap(), other.ensureBuilderMap());
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapFieldBuilder)) {
            return false;
        }
        return this.typedEquals((MapFieldBuilder)object);
    }

    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this.ensureBuilderMap());
    }

    public MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT> copy() {
        MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT> clone2 = new MapFieldBuilder<KeyT, MessageOrBuilderT, MessageT, BuilderT>(this.converter);
        clone2.ensureBuilderMap().putAll(this.ensureBuilderMap());
        return clone2;
    }

    public MapField<KeyT, MessageT> build(MapEntry<KeyT, MessageT> defaultEntry) {
        MapField<KeyT, MessageT> mapField = MapField.newMapField(defaultEntry);
        Map<KeyT, MessageT> map2 = mapField.getMutableMap();
        for (Map.Entry<KeyT, MessageOrBuilderT> entry2 : this.ensureBuilderMap().entrySet()) {
            map2.put(entry2.getKey(), this.converter.build((MessageOrBuilder)entry2.getValue()));
        }
        mapField.makeImmutable();
        return mapField;
    }

    @Override
    List<Message> getList() {
        return this.ensureMessageList();
    }

    @Override
    List<Message> getMutableList() {
        return this.ensureMessageList();
    }

    @Override
    Message getMapEntryMessageDefaultInstance() {
        return this.converter.defaultEntry();
    }

    public static interface Converter<KeyT, MessageOrBuilderT extends MessageOrBuilder, MessageT extends MessageOrBuilderT> {
        public MessageT build(MessageOrBuilderT var1);

        public MapEntry<KeyT, MessageT> defaultEntry();
    }
}

