/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import me.fan87.pixelmongo.ui.com.google.protobuf.ByteString;
import me.fan87.pixelmongo.ui.com.google.protobuf.GeneratedMessageLite;
import me.fan87.pixelmongo.ui.com.google.protobuf.MessageLite;
import me.fan87.pixelmongo.ui.com.google.protobuf.TextFormatEscaper;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";
    private static final char[] INDENT_BUFFER = new char[80];

    private MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String commentString) {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append("# ").append(commentString);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, buffer2, 0);
        return buffer2.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder buffer2, int indent) {
        HashSet<String> setters = new HashSet<String>();
        HashMap<String, Method> hazzers = new HashMap<String, Method>();
        TreeMap<String, Method> getters = new TreeMap<String, Method>();
        for (Method method : messageLite.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getName().length() < 3) continue;
            if (method.getName().startsWith("set")) {
                setters.add(method.getName());
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("has")) {
                hazzers.put(method.getName(), method);
                continue;
            }
            if (!method.getName().startsWith("get")) continue;
            getters.put(method.getName(), method);
        }
        for (Map.Entry entry2 : getters.entrySet()) {
            Method mapMethod;
            Method listMethod;
            String suffix = ((String)entry2.getKey()).substring(3);
            if (suffix.endsWith(LIST_SUFFIX) && !suffix.endsWith(BUILDER_LIST_SUFFIX) && !suffix.equals(LIST_SUFFIX) && (listMethod = (Method)entry2.getValue()) != null && listMethod.getReturnType().equals(List.class)) {
                MessageLiteToString.printField(buffer2, indent, suffix.substring(0, suffix.length() - LIST_SUFFIX.length()), GeneratedMessageLite.invokeOrDie(listMethod, messageLite, new Object[0]));
                continue;
            }
            if (suffix.endsWith(MAP_SUFFIX) && !suffix.equals(MAP_SUFFIX) && (mapMethod = (Method)entry2.getValue()) != null && mapMethod.getReturnType().equals(Map.class) && !mapMethod.isAnnotationPresent(Deprecated.class) && Modifier.isPublic(mapMethod.getModifiers())) {
                MessageLiteToString.printField(buffer2, indent, suffix.substring(0, suffix.length() - MAP_SUFFIX.length()), GeneratedMessageLite.invokeOrDie(mapMethod, messageLite, new Object[0]));
                continue;
            }
            if (!setters.contains("set" + suffix) || suffix.endsWith(BYTES_SUFFIX) && getters.containsKey("get" + suffix.substring(0, suffix.length() - BYTES_SUFFIX.length()))) continue;
            Method getMethod = (Method)entry2.getValue();
            Method hasMethod = (Method)hazzers.get("has" + suffix);
            if (getMethod == null) continue;
            Object value = GeneratedMessageLite.invokeOrDie(getMethod, messageLite, new Object[0]);
            boolean bl = hasMethod == null ? !MessageLiteToString.isDefaultValue(value) : (Boolean)GeneratedMessageLite.invokeOrDie(hasMethod, messageLite, new Object[0]);
            boolean hasValue = bl;
            if (!hasValue) continue;
            MessageLiteToString.printField(buffer2, indent, suffix, value);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iter = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iter.hasNext()) {
                Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object> entry3 = iter.next();
                MessageLiteToString.printField(buffer2, indent, "[" + entry3.getKey().getNumber() + "]", entry3.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(buffer2, indent);
        }
    }

    private static boolean isDefaultValue(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o == false;
        }
        if (o instanceof Integer) {
            return (Integer)o == 0;
        }
        if (o instanceof Float) {
            return Float.floatToRawIntBits(((Float)o).floatValue()) == 0;
        }
        if (o instanceof Double) {
            return Double.doubleToRawLongBits((Double)o) == 0L;
        }
        if (o instanceof String) {
            return o.equals("");
        }
        if (o instanceof ByteString) {
            return o.equals(ByteString.EMPTY);
        }
        if (o instanceof MessageLite) {
            return o == ((MessageLite)o).getDefaultInstanceForType();
        }
        if (o instanceof Enum) {
            return ((Enum)o).ordinal() == 0;
        }
        return false;
    }

    static void printField(StringBuilder buffer2, int indent, String name, Object object) {
        if (object instanceof List) {
            List list2 = (List)object;
            for (Object entry2 : list2) {
                MessageLiteToString.printField(buffer2, indent, name, entry2);
            }
            return;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            for (Map.Entry entry3 : map2.entrySet()) {
                MessageLiteToString.printField(buffer2, indent, name, entry3);
            }
            return;
        }
        buffer2.append('\n');
        MessageLiteToString.indent(indent, buffer2);
        buffer2.append(MessageLiteToString.pascalCaseToSnakeCase(name));
        if (object instanceof String) {
            buffer2.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
        } else if (object instanceof ByteString) {
            buffer2.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
        } else if (object instanceof GeneratedMessageLite) {
            buffer2.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, buffer2, indent + 2);
            buffer2.append("\n");
            MessageLiteToString.indent(indent, buffer2);
            buffer2.append("}");
        } else if (object instanceof Map.Entry) {
            buffer2.append(" {");
            Map.Entry entry4 = (Map.Entry)object;
            MessageLiteToString.printField(buffer2, indent + 2, "key", entry4.getKey());
            MessageLiteToString.printField(buffer2, indent + 2, "value", entry4.getValue());
            buffer2.append("\n");
            MessageLiteToString.indent(indent, buffer2);
            buffer2.append("}");
        } else {
            buffer2.append(": ").append(object);
        }
    }

    private static void indent(int indent, StringBuilder buffer2) {
        while (indent > 0) {
            int partialIndent = indent;
            if (partialIndent > INDENT_BUFFER.length) {
                partialIndent = INDENT_BUFFER.length;
            }
            buffer2.append(INDENT_BUFFER, 0, partialIndent);
            indent -= partialIndent;
        }
    }

    private static String pascalCaseToSnakeCase(String pascalCase) {
        if (pascalCase.isEmpty()) {
            return pascalCase;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toLowerCase(pascalCase.charAt(0)));
        for (int i = 1; i < pascalCase.length(); ++i) {
            char ch = pascalCase.charAt(i);
            if (Character.isUpperCase(ch)) {
                builder.append("_");
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }

    static {
        Arrays.fill(INDENT_BUFFER, ' ');
    }
}

