/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import me.fan87.pixelmongo.ui.com.google.protobuf.ByteBufferWriter;
import me.fan87.pixelmongo.ui.com.google.protobuf.ByteOutput;
import me.fan87.pixelmongo.ui.com.google.protobuf.ByteString;
import me.fan87.pixelmongo.ui.com.google.protobuf.CodedInputStream;
import me.fan87.pixelmongo.ui.com.google.protobuf.Internal;
import me.fan87.pixelmongo.ui.com.google.protobuf.Java8Compatibility;
import me.fan87.pixelmongo.ui.com.google.protobuf.RopeByteString;
import me.fan87.pixelmongo.ui.com.google.protobuf.Utf8;

final class NioByteString
extends ByteString.LeafByteString {
    private final ByteBuffer buffer;

    NioByteString(ByteBuffer buffer2) {
        Internal.checkNotNull(buffer2, "buffer");
        this.buffer = buffer2.slice().order(ByteOrder.nativeOrder());
    }

    private Object writeReplace() {
        return ByteString.copyFrom(this.buffer.slice());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("NioByteString instances are not to be serialized directly");
    }

    @Override
    public byte byteAt(int index2) {
        try {
            return this.buffer.get(index2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public byte internalByteAt(int index2) {
        return this.byteAt(index2);
    }

    @Override
    public int size() {
        return this.buffer.remaining();
    }

    @Override
    public ByteString substring(int beginIndex, int endIndex) {
        try {
            ByteBuffer slice = this.slice(beginIndex, endIndex);
            return new NioByteString(slice);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        ByteBuffer slice = this.buffer.slice();
        Java8Compatibility.position(slice, sourceOffset);
        slice.get(target, targetOffset, numberToCopy);
    }

    @Override
    public void copyTo(ByteBuffer target) {
        target.put(this.buffer.slice());
    }

    @Override
    public void writeTo(OutputStream out2) throws IOException {
        out2.write(this.toByteArray());
    }

    @Override
    boolean equalsRange(ByteString other, int offset2, int length) {
        return this.substring(0, length).equals(other.substring(offset2, offset2 + length));
    }

    @Override
    void writeToInternal(OutputStream out2, int sourceOffset, int numberToWrite) throws IOException {
        if (this.buffer.hasArray()) {
            int bufferOffset = this.buffer.arrayOffset() + this.buffer.position() + sourceOffset;
            out2.write(this.buffer.array(), bufferOffset, numberToWrite);
            return;
        }
        ByteBufferWriter.write(this.slice(sourceOffset, sourceOffset + numberToWrite), out2);
    }

    @Override
    void writeTo(ByteOutput output) throws IOException {
        output.writeLazy(this.buffer.slice());
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    @Override
    protected String toStringInternal(Charset charset) {
        int length;
        int offset2;
        byte[] bytes;
        if (this.buffer.hasArray()) {
            bytes = this.buffer.array();
            offset2 = this.buffer.arrayOffset() + this.buffer.position();
            length = this.buffer.remaining();
        } else {
            bytes = this.toByteArray();
            offset2 = 0;
            length = bytes.length;
        }
        return new String(bytes, offset2, length, charset);
    }

    @Override
    public boolean isValidUtf8() {
        return Utf8.isValidUtf8(this.buffer);
    }

    @Override
    protected int partialIsValidUtf8(int state2, int offset2, int length) {
        return Utf8.partialIsValidUtf8(state2, this.buffer, offset2, offset2 + length);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        ByteString otherString = (ByteString)other;
        if (this.size() != otherString.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof NioByteString) {
            return this.buffer.equals(((NioByteString)other).buffer);
        }
        if (other instanceof RopeByteString) {
            return other.equals(this);
        }
        return this.buffer.equals(otherString.asReadOnlyByteBuffer());
    }

    @Override
    protected int partialHash(int h2, int offset2, int length) {
        for (int i = offset2; i < offset2 + length; ++i) {
            h2 = h2 * 31 + this.buffer.get(i);
        }
        return h2;
    }

    @Override
    public InputStream newInput() {
        return new InputStream(){
            private final ByteBuffer buf;
            {
                this.buf = NioByteString.this.buffer.slice();
            }

            @Override
            public void mark(int readlimit) {
                Java8Compatibility.mark(this.buf);
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public void reset() throws IOException {
                try {
                    Java8Compatibility.reset(this.buf);
                }
                catch (InvalidMarkException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public int available() throws IOException {
                return this.buf.remaining();
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }
        };
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.buffer, true);
    }

    private ByteBuffer slice(int beginIndex, int endIndex) {
        if (beginIndex < this.buffer.position() || endIndex > this.buffer.limit() || beginIndex > endIndex) {
            throw new IllegalArgumentException(String.format("Invalid indices [%d, %d]", beginIndex, endIndex));
        }
        ByteBuffer slice = this.buffer.slice();
        Java8Compatibility.position(slice, beginIndex - this.buffer.position());
        Java8Compatibility.limit(slice, endIndex - this.buffer.position());
        return slice;
    }
}

