/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.util.Arrays;
import java.util.RandomAccess;
import me.fan87.pixelmongo.ui.com.google.protobuf.AbstractProtobufList;

final class ProtobufArrayList<E>
extends AbstractProtobufList<E>
implements RandomAccess {
    private static final ProtobufArrayList<Object> EMPTY_LIST = new ProtobufArrayList<Object>(new Object[0], 0, false);
    private E[] array;
    private int size;

    public static <E> ProtobufArrayList<E> emptyList() {
        return EMPTY_LIST;
    }

    ProtobufArrayList() {
        this(new Object[10], 0, true);
    }

    private ProtobufArrayList(E[] array, int size2, boolean isMutable) {
        super(isMutable);
        this.array = array;
        this.size = size2;
    }

    @Override
    public ProtobufArrayList<E> mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        E[] newArray = Arrays.copyOf(this.array, capacity);
        return new ProtobufArrayList<E>(newArray, this.size, true);
    }

    @Override
    public boolean add(E element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int length = this.size * 3 / 2 + 1;
            E[] newArray = Arrays.copyOf(this.array, length);
            this.array = newArray;
        }
        this.array[this.size++] = element;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int index2, E element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length = this.size * 3 / 2 + 1;
            E[] newArray = ProtobufArrayList.createArray(length);
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public E get(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public E remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        E value = this.array[index2];
        if (index2 < this.size - 1) {
            System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2 - 1);
        }
        --this.size;
        ++this.modCount;
        return value;
    }

    @Override
    public E set(int index2, E element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        E toReturn = this.array[index2];
        this.array[index2] = element;
        ++this.modCount;
        return toReturn;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static <E> E[] createArray(int capacity) {
        return new Object[capacity];
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }
}

