/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import me.fan87.pixelmongo.ui.com.google.protobuf.CheckReturnValue;
import me.fan87.pixelmongo.ui.com.google.protobuf.MessageInfo;
import me.fan87.pixelmongo.ui.com.google.protobuf.MessageLite;
import me.fan87.pixelmongo.ui.com.google.protobuf.ProtoSyntax;

@CheckReturnValue
final class RawMessageInfo
implements MessageInfo {
    private static final int IS_PROTO2_BIT = 1;
    private static final int IS_EDITION_BIT = 4;
    private final MessageLite defaultInstance;
    private final String info;
    private final Object[] objects;
    private final int flags;

    RawMessageInfo(MessageLite defaultInstance, String info2, Object[] objects) {
        this.defaultInstance = defaultInstance;
        this.info = info2;
        this.objects = objects;
        int position = 0;
        char value = info2.charAt(position++);
        if (value < '\ud800') {
            this.flags = value;
        } else {
            int result2 = value & 0x1FFF;
            int shift = 13;
            while ((value = info2.charAt(position++)) >= '\ud800') {
                result2 |= (value & 0x1FFF) << shift;
                shift += 13;
            }
            this.flags = result2 | value << shift;
        }
    }

    String getStringInfo() {
        return this.info;
    }

    Object[] getObjects() {
        return this.objects;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public ProtoSyntax getSyntax() {
        if ((this.flags & 1) != 0) {
            return ProtoSyntax.PROTO2;
        }
        if ((this.flags & 4) == 4) {
            return ProtoSyntax.EDITIONS;
        }
        return ProtoSyntax.PROTO3;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return (this.flags & 2) == 2;
    }
}

