/*
 * Decompiled with CFR 0.152.
 */
package me.fan87.pixelmongo.ui.com.google.protobuf;

import java.nio.ByteBuffer;
import java.util.Arrays;
import me.fan87.pixelmongo.ui.com.google.protobuf.Android;
import me.fan87.pixelmongo.ui.com.google.protobuf.Internal;
import me.fan87.pixelmongo.ui.com.google.protobuf.InvalidProtocolBufferException;
import me.fan87.pixelmongo.ui.com.google.protobuf.Java8Compatibility;
import me.fan87.pixelmongo.ui.com.google.protobuf.UnsafeUtil;

final class Utf8 {
    private static final Processor processor = UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice() ? new UnsafeProcessor() : new SafeProcessor();
    private static final long ASCII_MASK_LONG = -9187201950435737472L;
    static final int MAX_BYTES_PER_CHAR = 3;
    static final int COMPLETE = 0;
    static final int MALFORMED = -1;
    private static final int UNSAFE_COUNT_ASCII_THRESHOLD = 16;

    static boolean isValidUtf8(byte[] bytes) {
        return processor.isValidUtf8(bytes, 0, bytes.length);
    }

    static boolean isValidUtf8(byte[] bytes, int index2, int limit) {
        return processor.isValidUtf8(bytes, index2, limit);
    }

    static int partialIsValidUtf8(int state2, byte[] bytes, int index2, int limit) {
        return processor.partialIsValidUtf8(state2, bytes, index2, limit);
    }

    private static int incompleteStateFor(int byte1) {
        return byte1 > -12 ? -1 : byte1;
    }

    private static int incompleteStateFor(int byte1, int byte2) {
        return byte1 > -12 || byte2 > -65 ? -1 : byte1 ^ byte2 << 8;
    }

    private static int incompleteStateFor(int byte1, int byte2, int byte3) {
        return byte1 > -12 || byte2 > -65 || byte3 > -65 ? -1 : byte1 ^ byte2 << 8 ^ byte3 << 16;
    }

    private static int incompleteStateFor(byte[] bytes, int index2, int limit) {
        byte byte1 = bytes[index2 - 1];
        switch (limit - index2) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, bytes[index2]);
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)bytes[index2], (int)bytes[index2 + 1]);
            }
        }
        throw new AssertionError();
    }

    private static int incompleteStateFor(ByteBuffer buffer2, int byte1, int index2, int remaining) {
        switch (remaining) {
            case 0: {
                return Utf8.incompleteStateFor(byte1);
            }
            case 1: {
                return Utf8.incompleteStateFor(byte1, buffer2.get(index2));
            }
            case 2: {
                return Utf8.incompleteStateFor(byte1, (int)buffer2.get(index2), (int)buffer2.get(index2 + 1));
            }
        }
        throw new AssertionError();
    }

    static int encodedLength(CharSequence sequence2) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence2.length();
        for (i = 0; i < utf16Length && sequence2.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence2.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence2, i);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence2, int start2) {
        int utf16Length = sequence2.length();
        int utf8Length = 0;
        for (int i = start2; i < utf16Length; ++i) {
            char c = sequence2.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int cp = Character.codePointAt(sequence2, i);
            if (cp < 65536) {
                throw new UnpairedSurrogateException(i, utf16Length);
            }
            ++i;
        }
        return utf8Length;
    }

    static int encode(CharSequence in, byte[] out2, int offset2, int length) {
        return processor.encodeUtf8(in, out2, offset2, length);
    }

    static boolean isValidUtf8(ByteBuffer buffer2) {
        return processor.isValidUtf8(buffer2, buffer2.position(), buffer2.remaining());
    }

    static int partialIsValidUtf8(int state2, ByteBuffer buffer2, int index2, int limit) {
        return processor.partialIsValidUtf8(state2, buffer2, index2, limit);
    }

    static String decodeUtf8(ByteBuffer buffer2, int index2, int size2) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(buffer2, index2, size2);
    }

    static String decodeUtf8(byte[] bytes, int index2, int size2) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(bytes, index2, size2);
    }

    static void encodeUtf8(CharSequence in, ByteBuffer out2) {
        processor.encodeUtf8(in, out2);
    }

    private static int estimateConsecutiveAscii(ByteBuffer buffer2, int index2, int limit) {
        int i;
        int lim = limit - 7;
        for (i = index2; i < lim && (buffer2.getLong(i) & 0x8080808080808080L) == 0L; i += 8) {
        }
        return i - index2;
    }

    private Utf8() {
    }

    private static class DecodeUtil {
        private DecodeUtil() {
        }

        private static boolean isOneByte(byte b) {
            return b >= 0;
        }

        private static boolean isTwoBytes(byte b) {
            return b < -32;
        }

        private static boolean isThreeBytes(byte b) {
            return b < -16;
        }

        private static void handleOneByte(byte byte1, char[] resultArr, int resultPos) {
            resultArr[resultPos] = (char)byte1;
        }

        private static void handleTwoBytes(byte byte1, byte byte2, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (byte1 < -62 || DecodeUtil.isNotTrailingByte(byte2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0x1F) << 6 | DecodeUtil.trailingByteValue(byte2));
        }

        private static void handleThreeBytes(byte byte1, byte byte2, byte byte3, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(byte2) || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || DecodeUtil.isNotTrailingByte(byte3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            resultArr[resultPos] = (char)((byte1 & 0xF) << 12 | DecodeUtil.trailingByteValue(byte2) << 6 | DecodeUtil.trailingByteValue(byte3));
        }

        private static void handleFourBytes(byte byte1, byte byte2, byte byte3, byte byte4, char[] resultArr, int resultPos) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(byte2) || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(byte3) || DecodeUtil.isNotTrailingByte(byte4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            int codepoint = (byte1 & 7) << 18 | DecodeUtil.trailingByteValue(byte2) << 12 | DecodeUtil.trailingByteValue(byte3) << 6 | DecodeUtil.trailingByteValue(byte4);
            resultArr[resultPos] = DecodeUtil.highSurrogate(codepoint);
            resultArr[resultPos + 1] = DecodeUtil.lowSurrogate(codepoint);
        }

        private static boolean isNotTrailingByte(byte b) {
            return b > -65;
        }

        private static int trailingByteValue(byte b) {
            return b & 0x3F;
        }

        private static char highSurrogate(int codePoint) {
            return (char)(55232 + (codePoint >>> 10));
        }

        private static char lowSurrogate(int codePoint) {
            return (char)(56320 + (codePoint & 0x3FF));
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        UnsafeProcessor() {
        }

        static boolean isAvailable() {
            return UnsafeUtil.hasUnsafeArrayOperations() && UnsafeUtil.hasUnsafeByteBufferOperations();
        }

        @Override
        int partialIsValidUtf8(int state2, byte[] bytes, int index2, int limit) {
            if ((index2 | limit | bytes.length - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", bytes.length, index2, limit));
            }
            long offset2 = index2;
            long offsetLimit = limit;
            if (state2 != 0) {
                if (offset2 >= offsetLimit) {
                    return state2;
                }
                byte byte1 = (byte)state2;
                if (byte1 < -32) {
                    if (byte1 < -62 || UnsafeUtil.getByte(bytes, offset2++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state2 >> 8));
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(bytes, offset2++);
                        if (offset2 >= offsetLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || UnsafeUtil.getByte(bytes, offset2++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state2 >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(bytes, offset2++);
                        if (offset2 >= offsetLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state2 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = UnsafeUtil.getByte(bytes, offset2++);
                        if (offset2 >= offsetLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || UnsafeUtil.getByte(bytes, offset2++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(bytes, offset2, (int)(offsetLimit - offset2));
        }

        @Override
        int partialIsValidUtf8Direct(int state2, ByteBuffer buffer2, int index2, int limit) {
            if ((index2 | limit | buffer2.limit() - limit) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer2.limit(), index2, limit));
            }
            long address = UnsafeUtil.addressOffset(buffer2) + (long)index2;
            long addressLimit = address + (long)(limit - index2);
            if (state2 != 0) {
                if (address >= addressLimit) {
                    return state2;
                }
                byte byte1 = (byte)state2;
                if (byte1 < -32) {
                    if (byte1 < -62 || UnsafeUtil.getByte(address++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state2 >> 8));
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(address++);
                        if (address >= addressLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || UnsafeUtil.getByte(address++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state2 >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = UnsafeUtil.getByte(address++);
                        if (address >= addressLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state2 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = UnsafeUtil.getByte(address++);
                        if (address >= addressLimit) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || UnsafeUtil.getByte(address++) > -65) {
                        return -1;
                    }
                }
            }
            return UnsafeProcessor.partialIsValidUtf8(address, (int)(addressLimit - address));
        }

        @Override
        String decodeUtf8(byte[] bytes, int index2, int size2) throws InvalidProtocolBufferException {
            String s2 = new String(bytes, index2, size2, Internal.UTF_8);
            if (!s2.contains("\ufffd")) {
                return s2;
            }
            if (Arrays.equals(s2.getBytes(Internal.UTF_8), Arrays.copyOfRange(bytes, index2, index2 + size2))) {
                return s2;
            }
            throw InvalidProtocolBufferException.invalidUtf8();
        }

        @Override
        String decodeUtf8Direct(ByteBuffer buffer2, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            long address;
            if ((index2 | size2 | buffer2.limit() - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer2.limit(), index2, size2));
            }
            long addressLimit = address + (long)size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (address = UnsafeUtil.addressOffset(buffer2) + (long)index2; address < addressLimit && DecodeUtil.isOneByte(b = UnsafeUtil.getByte(address)); ++address) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (address < addressLimit) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = UnsafeUtil.getByte(address++))) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (address < addressLimit && DecodeUtil.isOneByte(b2 = UnsafeUtil.getByte(address))) {
                        ++address;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (address >= addressLimit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, UnsafeUtil.getByte(address++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (address >= addressLimit - 1L) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), resultArr, resultPos++);
                    continue;
                }
                if (address >= addressLimit - 2L) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), UnsafeUtil.getByte(address++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        @Override
        int encodeUtf8(CharSequence in, byte[] out2, int offset2, int length) {
            char c;
            int inIx;
            long outIx = offset2;
            long outLimit = outIx + (long)length;
            int inLimit = in.length();
            if (inLimit > length || out2.length - length < offset2) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + (offset2 + length));
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(out2, outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                return (int)outIx;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(out2, outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(out2, outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    if (!('\ud800' > c || c > '\udfff' || inIx + 1 != inLimit && Character.isSurrogatePair(c, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + outIx);
                }
                ++inIx;
            }
            return (int)outIx;
        }

        @Override
        void encodeUtf8Direct(CharSequence in, ByteBuffer out2) {
            char c;
            int inIx;
            long address = UnsafeUtil.addressOffset(out2);
            long outIx = address + (long)out2.position();
            long outLimit = address + (long)out2.limit();
            int inLimit = in.length();
            if ((long)inLimit > outLimit - outIx) {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inLimit - 1) + " at index " + out2.limit());
            }
            for (inIx = 0; inIx < inLimit && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                UnsafeUtil.putByte(outIx++, (byte)c);
            }
            if (inIx == inLimit) {
                Java8Compatibility.position(out2, (int)(outIx - address));
                return;
            }
            while (inIx < inLimit) {
                c = in.charAt(inIx);
                if (c < '\u0080' && outIx < outLimit) {
                    UnsafeUtil.putByte(outIx++, (byte)c);
                } else if (c < '\u0800' && outIx <= outLimit - 2L) {
                    UnsafeUtil.putByte(outIx++, (byte)(0x3C0 | c >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
                } else if ((c < '\ud800' || '\udfff' < c) && outIx <= outLimit - 3L) {
                    UnsafeUtil.putByte(outIx++, (byte)(0x1E0 | c >>> 12));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & c));
                } else if (outIx <= outLimit - 4L) {
                    char low;
                    if (inIx + 1 == inLimit || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                        throw new UnpairedSurrogateException(inIx - 1, inLimit);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    UnsafeUtil.putByte(outIx++, (byte)(0xF0 | codePoint >>> 18));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                    UnsafeUtil.putByte(outIx++, (byte)(0x80 | 0x3F & codePoint));
                } else {
                    if (!('\ud800' > c || c > '\udfff' || inIx + 1 != inLimit && Character.isSurrogatePair(c, in.charAt(inIx + 1)))) {
                        throw new UnpairedSurrogateException(inIx, inLimit);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + outIx);
                }
                ++inIx;
            }
            Java8Compatibility.position(out2, (int)(outIx - address));
        }

        private static int unsafeEstimateConsecutiveAscii(byte[] bytes, long offset2, int maxChars) {
            int i;
            if (maxChars < 16) {
                return 0;
            }
            int unaligned = 8 - ((int)offset2 & 7);
            for (i = 0; i < unaligned; ++i) {
                if (UnsafeUtil.getByte(bytes, offset2++) >= 0) continue;
                return i;
            }
            while (i + 8 <= maxChars && (UnsafeUtil.getLong((Object)bytes, UnsafeUtil.BYTE_ARRAY_BASE_OFFSET + offset2) & 0x8080808080808080L) == 0L) {
                offset2 += 8L;
                i += 8;
            }
            while (i < maxChars) {
                if (UnsafeUtil.getByte(bytes, offset2++) < 0) {
                    return i;
                }
                ++i;
            }
            return maxChars;
        }

        private static int unsafeEstimateConsecutiveAscii(long address, int maxChars) {
            int unaligned;
            int remaining = maxChars;
            if (remaining < 16) {
                return 0;
            }
            for (int j = unaligned = (int)(-address & 7L); j > 0; --j) {
                if (UnsafeUtil.getByte(address++) >= 0) continue;
                return unaligned - j;
            }
            remaining -= unaligned;
            while (remaining >= 8 && (UnsafeUtil.getLong(address) & 0x8080808080808080L) == 0L) {
                address += 8L;
                remaining -= 8;
            }
            return maxChars - remaining;
        }

        private static int partialIsValidUtf8(byte[] bytes, long offset2, int remaining) {
            int skipped = UnsafeProcessor.unsafeEstimateConsecutiveAscii(bytes, offset2, remaining);
            remaining -= skipped;
            offset2 += (long)skipped;
            while (true) {
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(bytes, offset2++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(bytes, offset2++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(bytes, byte1, offset2, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(bytes, offset2++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(bytes, offset2++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(bytes, byte1, offset2, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(bytes, offset2++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || UnsafeUtil.getByte(bytes, offset2++) > -65 || UnsafeUtil.getByte(bytes, offset2++) > -65) break;
            }
            return -1;
        }

        private static int partialIsValidUtf8(long address, int remaining) {
            int skipped = UnsafeProcessor.unsafeEstimateConsecutiveAscii(address, remaining);
            address += (long)skipped;
            remaining -= skipped;
            while (true) {
                byte byte2;
                int byte1 = 0;
                while (remaining > 0) {
                    byte by = UnsafeUtil.getByte(address++);
                    byte1 = by;
                    if (by < 0) break;
                    --remaining;
                }
                if (remaining == 0) {
                    return 0;
                }
                --remaining;
                if (byte1 < -32) {
                    if (remaining == 0) {
                        return byte1;
                    }
                    --remaining;
                    if (byte1 >= -62 && UnsafeUtil.getByte(address++) <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (remaining < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(address, byte1, remaining);
                    }
                    remaining -= 2;
                    if (!((byte2 = UnsafeUtil.getByte(address++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && UnsafeUtil.getByte(address++) <= -65) continue;
                    return -1;
                }
                if (remaining < 3) {
                    return UnsafeProcessor.unsafeIncompleteStateFor(address, byte1, remaining);
                }
                remaining -= 3;
                if ((byte2 = UnsafeUtil.getByte(address++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || UnsafeUtil.getByte(address++) > -65 || UnsafeUtil.getByte(address++) > -65) break;
            }
            return -1;
        }

        private static int unsafeIncompleteStateFor(byte[] bytes, int byte1, long offset2, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(bytes, offset2));
                }
                case 2: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(bytes, offset2), UnsafeUtil.getByte(bytes, offset2 + 1L));
                }
            }
            throw new AssertionError();
        }

        private static int unsafeIncompleteStateFor(long address, int byte1, int remaining) {
            switch (remaining) {
                case 0: {
                    return Utf8.incompleteStateFor(byte1);
                }
                case 1: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(address));
                }
                case 2: {
                    return Utf8.incompleteStateFor(byte1, UnsafeUtil.getByte(address), UnsafeUtil.getByte(address + 1L));
                }
            }
            throw new AssertionError();
        }
    }

    static final class SafeProcessor
    extends Processor {
        SafeProcessor() {
        }

        @Override
        int partialIsValidUtf8(int state2, byte[] bytes, int index2, int limit) {
            if (state2 != 0) {
                if (index2 >= limit) {
                    return state2;
                }
                byte byte1 = (byte)state2;
                if (byte1 < -32) {
                    if (byte1 < -62 || bytes[index2++] > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state2 >> 8));
                    if (byte2 == 0) {
                        byte2 = bytes[index2++];
                        if (index2 >= limit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || bytes[index2++] > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state2 >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = bytes[index2++];
                        if (index2 >= limit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state2 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = bytes[index2++];
                        if (index2 >= limit) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || bytes[index2++] > -65) {
                        return -1;
                    }
                }
            }
            return SafeProcessor.partialIsValidUtf8(bytes, index2, limit);
        }

        @Override
        int partialIsValidUtf8Direct(int state2, ByteBuffer buffer2, int index2, int limit) {
            return this.partialIsValidUtf8Default(state2, buffer2, index2, limit);
        }

        @Override
        String decodeUtf8(byte[] bytes, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            int offset2;
            if ((index2 | size2 | bytes.length - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", bytes.length, index2, size2));
            }
            int limit = offset2 + size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (offset2 = index2; offset2 < limit && DecodeUtil.isOneByte(b = bytes[offset2]); ++offset2) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (offset2 < limit) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = bytes[offset2++])) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (offset2 < limit && DecodeUtil.isOneByte(b2 = bytes[offset2])) {
                        ++offset2;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (offset2 >= limit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, bytes[offset2++], resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (offset2 >= limit - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, bytes[offset2++], bytes[offset2++], resultArr, resultPos++);
                    continue;
                }
                if (offset2 >= limit - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, bytes[offset2++], bytes[offset2++], bytes[offset2++], resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        @Override
        String decodeUtf8Direct(ByteBuffer buffer2, int index2, int size2) throws InvalidProtocolBufferException {
            return this.decodeUtf8Default(buffer2, index2, size2);
        }

        @Override
        int encodeUtf8(CharSequence in, byte[] out2, int offset2, int length) {
            char c;
            int i;
            int utf16Length = in.length();
            int j = offset2;
            int limit = offset2 + length;
            for (i = 0; i < utf16Length && i + j < limit && (c = in.charAt(i)) < '\u0080'; ++i) {
                out2[j + i] = (byte)c;
            }
            if (i == utf16Length) {
                return j + utf16Length;
            }
            j += i;
            while (i < utf16Length) {
                c = in.charAt(i);
                if (c < '\u0080' && j < limit) {
                    out2[j++] = (byte)c;
                } else if (c < '\u0800' && j <= limit - 2) {
                    out2[j++] = (byte)(0x3C0 | c >>> 6);
                    out2[j++] = (byte)(0x80 | 0x3F & c);
                } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                    out2[j++] = (byte)(0x1E0 | c >>> 12);
                    out2[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                    out2[j++] = (byte)(0x80 | 0x3F & c);
                } else if (j <= limit - 4) {
                    char low;
                    if (i + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(++i))) {
                        throw new UnpairedSurrogateException(i - 1, utf16Length);
                    }
                    int codePoint = Character.toCodePoint(c, low);
                    out2[j++] = (byte)(0xF0 | codePoint >>> 18);
                    out2[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    out2[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    out2[j++] = (byte)(0x80 | 0x3F & codePoint);
                } else {
                    if (!('\ud800' > c || c > '\udfff' || i + 1 != in.length() && Character.isSurrogatePair(c, in.charAt(i + 1)))) {
                        throw new UnpairedSurrogateException(i, utf16Length);
                    }
                    throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
                }
                ++i;
            }
            return j;
        }

        @Override
        void encodeUtf8Direct(CharSequence in, ByteBuffer out2) {
            this.encodeUtf8Default(in, out2);
        }

        private static int partialIsValidUtf8(byte[] bytes, int index2, int limit) {
            while (index2 < limit && bytes[index2] >= 0) {
                ++index2;
            }
            return index2 >= limit ? 0 : SafeProcessor.partialIsValidUtf8NonAscii(bytes, index2, limit);
        }

        private static int partialIsValidUtf8NonAscii(byte[] bytes, int index2, int limit) {
            while (true) {
                byte byte2;
                byte byte1;
                if (index2 >= limit) {
                    return 0;
                }
                if ((byte1 = bytes[index2++]) >= 0) continue;
                if (byte1 < -32) {
                    if (index2 >= limit) {
                        return byte1;
                    }
                    if (byte1 >= -62 && bytes[index2++] <= -65) continue;
                    return -1;
                }
                if (byte1 < -16) {
                    if (index2 >= limit - 1) {
                        return Utf8.incompleteStateFor(bytes, index2, limit);
                    }
                    if (!((byte2 = bytes[index2++]) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96) && bytes[index2++] <= -65) continue;
                    return -1;
                }
                if (index2 >= limit - 2) {
                    return Utf8.incompleteStateFor(bytes, index2, limit);
                }
                if ((byte2 = bytes[index2++]) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || bytes[index2++] > -65 || bytes[index2++] > -65) break;
            }
            return -1;
        }
    }

    static abstract class Processor {
        Processor() {
        }

        final boolean isValidUtf8(byte[] bytes, int index2, int limit) {
            return this.partialIsValidUtf8(0, bytes, index2, limit) == 0;
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        final boolean isValidUtf8(ByteBuffer buffer2, int index2, int limit) {
            return this.partialIsValidUtf8(0, buffer2, index2, limit) == 0;
        }

        final int partialIsValidUtf8(int state2, ByteBuffer buffer2, int index2, int limit) {
            if (buffer2.hasArray()) {
                int offset2 = buffer2.arrayOffset();
                return this.partialIsValidUtf8(state2, buffer2.array(), offset2 + index2, offset2 + limit);
            }
            if (buffer2.isDirect()) {
                return this.partialIsValidUtf8Direct(state2, buffer2, index2, limit);
            }
            return this.partialIsValidUtf8Default(state2, buffer2, index2, limit);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        final int partialIsValidUtf8Default(int state2, ByteBuffer buffer2, int index2, int limit) {
            if (state2 != 0) {
                if (index2 >= limit) {
                    return state2;
                }
                byte byte1 = (byte)state2;
                if (byte1 < -32) {
                    if (byte1 < -62 || buffer2.get(index2++) > -65) {
                        return -1;
                    }
                } else if (byte1 < -16) {
                    byte byte2 = (byte)(~(state2 >> 8));
                    if (byte2 == 0) {
                        byte2 = buffer2.get(index2++);
                        if (index2 >= limit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    }
                    if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || buffer2.get(index2++) > -65) {
                        return -1;
                    }
                } else {
                    byte byte2 = (byte)(~(state2 >> 8));
                    byte byte3 = 0;
                    if (byte2 == 0) {
                        byte2 = buffer2.get(index2++);
                        if (index2 >= limit) {
                            return Utf8.incompleteStateFor(byte1, byte2);
                        }
                    } else {
                        byte3 = (byte)(state2 >> 16);
                    }
                    if (byte3 == 0) {
                        byte3 = buffer2.get(index2++);
                        if (index2 >= limit) {
                            return Utf8.incompleteStateFor(byte1, byte2, byte3);
                        }
                    }
                    if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || buffer2.get(index2++) > -65) {
                        return -1;
                    }
                }
            }
            return Processor.partialIsValidUtf8(buffer2, index2, limit);
        }

        private static int partialIsValidUtf8(ByteBuffer buffer2, int index2, int limit) {
            index2 += Utf8.estimateConsecutiveAscii(buffer2, index2, limit);
            while (true) {
                byte byte2;
                byte byte1;
                if (index2 >= limit) {
                    return 0;
                }
                if ((byte1 = buffer2.get(index2++)) >= 0) continue;
                if (byte1 < -32) {
                    if (index2 >= limit) {
                        return byte1;
                    }
                    if (byte1 < -62 || buffer2.get(index2) > -65) {
                        return -1;
                    }
                    ++index2;
                    continue;
                }
                if (byte1 < -16) {
                    if (index2 >= limit - 1) {
                        return Utf8.incompleteStateFor(buffer2, byte1, index2, limit - index2);
                    }
                    if ((byte2 = buffer2.get(index2++)) > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || buffer2.get(index2) > -65) {
                        return -1;
                    }
                    ++index2;
                    continue;
                }
                if (index2 >= limit - 2) {
                    return Utf8.incompleteStateFor(buffer2, byte1, index2, limit - index2);
                }
                if ((byte2 = buffer2.get(index2++)) > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || buffer2.get(index2++) > -65 || buffer2.get(index2++) > -65) break;
            }
            return -1;
        }

        abstract String decodeUtf8(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;

        final String decodeUtf8(ByteBuffer buffer2, int index2, int size2) throws InvalidProtocolBufferException {
            if (buffer2.hasArray()) {
                int offset2 = buffer2.arrayOffset();
                return this.decodeUtf8(buffer2.array(), offset2 + index2, size2);
            }
            if (buffer2.isDirect()) {
                return this.decodeUtf8Direct(buffer2, index2, size2);
            }
            return this.decodeUtf8Default(buffer2, index2, size2);
        }

        abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3) throws InvalidProtocolBufferException;

        final String decodeUtf8Default(ByteBuffer buffer2, int index2, int size2) throws InvalidProtocolBufferException {
            byte b;
            int offset2;
            if ((index2 | size2 | buffer2.limit() - index2 - size2) < 0) {
                throw new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", buffer2.limit(), index2, size2));
            }
            int limit = offset2 + size2;
            char[] resultArr = new char[size2];
            int resultPos = 0;
            for (offset2 = index2; offset2 < limit && DecodeUtil.isOneByte(b = buffer2.get(offset2)); ++offset2) {
                DecodeUtil.handleOneByte(b, resultArr, resultPos++);
            }
            while (offset2 < limit) {
                byte byte1;
                if (DecodeUtil.isOneByte(byte1 = buffer2.get(offset2++))) {
                    byte b2;
                    DecodeUtil.handleOneByte(byte1, resultArr, resultPos++);
                    while (offset2 < limit && DecodeUtil.isOneByte(b2 = buffer2.get(offset2))) {
                        ++offset2;
                        DecodeUtil.handleOneByte(b2, resultArr, resultPos++);
                    }
                    continue;
                }
                if (DecodeUtil.isTwoBytes(byte1)) {
                    if (offset2 >= limit) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleTwoBytes(byte1, buffer2.get(offset2++), resultArr, resultPos++);
                    continue;
                }
                if (DecodeUtil.isThreeBytes(byte1)) {
                    if (offset2 >= limit - 1) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    DecodeUtil.handleThreeBytes(byte1, buffer2.get(offset2++), buffer2.get(offset2++), resultArr, resultPos++);
                    continue;
                }
                if (offset2 >= limit - 2) {
                    throw InvalidProtocolBufferException.invalidUtf8();
                }
                DecodeUtil.handleFourBytes(byte1, buffer2.get(offset2++), buffer2.get(offset2++), buffer2.get(offset2++), resultArr, resultPos++);
                ++resultPos;
            }
            return new String(resultArr, 0, resultPos);
        }

        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

        final void encodeUtf8(CharSequence in, ByteBuffer out2) {
            if (out2.hasArray()) {
                int offset2 = out2.arrayOffset();
                int endIndex = Utf8.encode(in, out2.array(), offset2 + out2.position(), out2.remaining());
                Java8Compatibility.position(out2, endIndex - offset2);
            } else if (out2.isDirect()) {
                this.encodeUtf8Direct(in, out2);
            } else {
                this.encodeUtf8Default(in, out2);
            }
        }

        abstract void encodeUtf8Direct(CharSequence var1, ByteBuffer var2);

        final void encodeUtf8Default(CharSequence in, ByteBuffer out2) {
            int inIx;
            int inLength = in.length();
            int outIx = out2.position();
            try {
                char c;
                for (inIx = 0; inIx < inLength && (c = in.charAt(inIx)) < '\u0080'; ++inIx) {
                    out2.put(outIx + inIx, (byte)c);
                }
                if (inIx == inLength) {
                    Java8Compatibility.position(out2, outIx + inIx);
                    return;
                }
                outIx += inIx;
                while (inIx < inLength) {
                    c = in.charAt(inIx);
                    if (c < '\u0080') {
                        out2.put(outIx, (byte)c);
                    } else if (c < '\u0800') {
                        out2.put(outIx++, (byte)(0xC0 | c >>> 6));
                        out2.put(outIx, (byte)(0x80 | 0x3F & c));
                    } else if (c < '\ud800' || '\udfff' < c) {
                        out2.put(outIx++, (byte)(0xE0 | c >>> 12));
                        out2.put(outIx++, (byte)(0x80 | 0x3F & c >>> 6));
                        out2.put(outIx, (byte)(0x80 | 0x3F & c));
                    } else {
                        char low;
                        if (inIx + 1 == inLength || !Character.isSurrogatePair(c, low = in.charAt(++inIx))) {
                            throw new UnpairedSurrogateException(inIx, inLength);
                        }
                        int codePoint = Character.toCodePoint(c, low);
                        out2.put(outIx++, (byte)(0xF0 | codePoint >>> 18));
                        out2.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                        out2.put(outIx++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                        out2.put(outIx, (byte)(0x80 | 0x3F & codePoint));
                    }
                    ++inIx;
                    ++outIx;
                }
                Java8Compatibility.position(out2, outIx);
            }
            catch (IndexOutOfBoundsException e) {
                int badWriteIndex = out2.position() + Math.max(inIx, outIx - out2.position() + 1);
                throw new ArrayIndexOutOfBoundsException("Failed writing " + in.charAt(inIx) + " at index " + badWriteIndex);
            }
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int index2, int length) {
            super("Unpaired surrogate at index " + index2 + " of " + length);
        }
    }
}

