/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.internal.parser.node;

import net.kyori.adventure.text.minimessage.internal.parser.Token;
import net.kyori.adventure.text.minimessage.internal.parser.TokenParser;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.jetbrains.annotations.NotNull;

public final class TagPart
implements Tag.Argument {
    private final String value;
    private final Token token;

    public TagPart(@NotNull String sourceMessage, @NotNull Token token2, @NotNull TokenParser.TagProvider tagResolver) {
        String v = TagPart.unquoteAndEscape(sourceMessage, token2.startIndex(), token2.endIndex());
        this.value = v = TokenParser.resolvePreProcessTags(v, tagResolver);
        this.token = token2;
    }

    @Override
    @NotNull
    public String value() {
        return this.value;
    }

    @NotNull
    public Token token() {
        return this.token;
    }

    @NotNull
    public static String unquoteAndEscape(@NotNull String text2, int start2, int end2) {
        if (start2 == end2) {
            return "";
        }
        int startIndex = start2;
        int endIndex = end2;
        char firstChar = text2.charAt(startIndex);
        char lastChar = text2.charAt(endIndex - 1);
        if (firstChar == '\'' || firstChar == '\"') {
            ++startIndex;
        } else {
            return text2.substring(startIndex, endIndex);
        }
        if (lastChar == '\'' || lastChar == '\"') {
            --endIndex;
        }
        return TokenParser.unescape(text2, startIndex, endIndex, i -> i == firstChar || i == 92);
    }

    public String toString() {
        return this.value;
    }
}

