/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.resolver;

import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public final class Formatter {
    private Formatter() {
    }

    @NotNull
    public static TagResolver number(@TagPattern @NotNull String key, @NotNull Number number) {
        return TagResolver.resolver(key, (argumentQueue, context2) -> {
            NumberFormat decimalFormat;
            if (argumentQueue.hasNext()) {
                String locale = argumentQueue.pop().value();
                if (argumentQueue.hasNext()) {
                    String format2 = argumentQueue.pop().value();
                    decimalFormat = new DecimalFormat(format2, new DecimalFormatSymbols(Locale.forLanguageTag(locale)));
                } else {
                    decimalFormat = locale.contains(".") ? new DecimalFormat(locale, DecimalFormatSymbols.getInstance()) : DecimalFormat.getInstance(Locale.forLanguageTag(locale));
                }
            } else {
                decimalFormat = DecimalFormat.getInstance();
            }
            return Tag.inserting(context2.deserialize(decimalFormat.format(number)));
        });
    }

    @NotNull
    public static TagResolver date(@TagPattern @NotNull String key, @NotNull TemporalAccessor time) {
        return TagResolver.resolver(key, (argumentQueue, context2) -> {
            String format2 = argumentQueue.popOr("Format expected.").value();
            return Tag.inserting(context2.deserialize(DateTimeFormatter.ofPattern(format2).format(time)));
        });
    }

    @NotNull
    public static TagResolver choice(@TagPattern @NotNull String key, Number number) {
        return TagResolver.resolver(key, (argumentQueue, context2) -> {
            String format2 = argumentQueue.popOr("Format expected.").value();
            ChoiceFormat choiceFormat = new ChoiceFormat(format2);
            return Tag.inserting(context2.deserialize(choiceFormat.format(number)));
        });
    }

    public static TagResolver booleanChoice(@TagPattern @NotNull String key, boolean value) {
        return TagResolver.resolver(key, (argumentQueue, context2) -> {
            String trueCase = argumentQueue.popOr("True format expected.").value();
            String falseCase = argumentQueue.popOr("False format expected.").value();
            return Tag.inserting(context2.deserialize(value ? trueCase : falseCase));
        });
    }
}

