/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.renderer;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.renderer.AbstractComponentRenderer;
import net.kyori.adventure.translation.Translator;
import net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranslatableComponentRenderer<C>
extends AbstractComponentRenderer<C> {
    private static final Set<Style.Merge> MERGES = Style.Merge.merges(Style.Merge.COLOR, Style.Merge.DECORATIONS, Style.Merge.INSERTION, Style.Merge.FONT);

    @NotNull
    public static TranslatableComponentRenderer<Locale> usingTranslationSource(final @NotNull Translator source2) {
        Objects.requireNonNull(source2, "source");
        return new TranslatableComponentRenderer<Locale>(){

            @Override
            @Nullable
            protected MessageFormat translate(@NotNull String key, @NotNull Locale context2) {
                return source2.translate(key, context2);
            }

            @Override
            @NotNull
            protected Component renderTranslatable(@NotNull TranslatableComponent component, @NotNull Locale context2) {
                TriState anyTranslations = source2.hasAnyTranslations();
                if (anyTranslations == TriState.TRUE || anyTranslations == TriState.NOT_SET) {
                    @Nullable Component translated = source2.translate(component, context2);
                    if (translated != null) {
                        return translated;
                    }
                    return super.renderTranslatable(component, context2);
                }
                return component;
            }
        };
    }

    @Nullable
    protected MessageFormat translate(@NotNull String key, @NotNull C context2) {
        return null;
    }

    @Nullable
    protected MessageFormat translate(@NotNull String key, @Nullable String fallback, @NotNull C context2) {
        return this.translate(key, context2);
    }

    @Override
    @NotNull
    protected Component renderBlockNbt(@NotNull BlockNBTComponent component, @NotNull C context2) {
        BlockNBTComponent.Builder builder = this.nbt(context2, Component.blockNBT(), component).pos(component.pos());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderEntityNbt(@NotNull EntityNBTComponent component, @NotNull C context2) {
        EntityNBTComponent.Builder builder = this.nbt(context2, Component.entityNBT(), component).selector(component.selector());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderStorageNbt(@NotNull StorageNBTComponent component, @NotNull C context2) {
        StorageNBTComponent.Builder builder = this.nbt(context2, Component.storageNBT(), component).storage(component.storage());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    protected <O extends NBTComponent<O, B>, B extends NBTComponentBuilder<O, B>> B nbt(@NotNull C context2, B builder, O oldComponent) {
        builder.nbtPath(oldComponent.nbtPath()).interpret(oldComponent.interpret());
        @Nullable Component separator = oldComponent.separator();
        if (separator != null) {
            builder.separator(this.render(separator, context2));
        }
        return builder;
    }

    @Override
    @NotNull
    protected Component renderKeybind(@NotNull KeybindComponent component, @NotNull C context2) {
        KeybindComponent.Builder builder = Component.keybind().keybind(component.keybind());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderScore(@NotNull ScoreComponent component, @NotNull C context2) {
        ScoreComponent.Builder builder = Component.score().name(component.name()).objective(component.objective()).value(component.value());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderSelector(@NotNull SelectorComponent component, @NotNull C context2) {
        SelectorComponent.Builder builder = Component.selector().pattern(component.pattern());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderText(@NotNull TextComponent component, @NotNull C context2) {
        TextComponent.Builder builder = Component.text().content(component.content());
        return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
    }

    @Override
    @NotNull
    protected Component renderTranslatable(@NotNull TranslatableComponent component, @NotNull C context2) {
        @Nullable MessageFormat format2 = this.translate(component.key(), component.fallback(), context2);
        if (format2 == null) {
            TranslatableComponent.Builder builder = Component.translatable().key(component.key()).fallback(component.fallback());
            if (!component.arguments().isEmpty()) {
                ArrayList<TranslationArgument> args2 = new ArrayList<TranslationArgument>(component.arguments());
                int size2 = args2.size();
                for (int i = 0; i < size2; ++i) {
                    TranslationArgument arg = (TranslationArgument)args2.get(i);
                    if (!(arg.value() instanceof Component)) continue;
                    args2.set(i, TranslationArgument.component(this.render((Component)arg.value(), context2)));
                }
                builder.arguments(args2);
            }
            return this.mergeStyleAndOptionallyDeepRender(component, builder, context2);
        }
        List<TranslationArgument> args3 = component.arguments();
        TextComponent.Builder builder = Component.text();
        this.mergeStyle(component, builder, context2);
        if (args3.isEmpty()) {
            builder.content(format2.format(null, new StringBuffer(), null).toString());
            return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context2);
        }
        Object[] nulls = new Object[args3.size()];
        StringBuffer sb = format2.format(nulls, new StringBuffer(), (FieldPosition)null);
        AttributedCharacterIterator it = format2.formatToCharacterIterator(nulls);
        while (it.getIndex() < it.getEndIndex()) {
            int end2 = it.getRunLimit();
            Integer index2 = (Integer)it.getAttribute(MessageFormat.Field.ARGUMENT);
            if (index2 != null) {
                TranslationArgument arg = args3.get(index2);
                if (arg.value() instanceof Component) {
                    builder.append(this.render(arg.asComponent(), context2));
                } else {
                    builder.append(arg.asComponent());
                }
            } else {
                builder.append((Component)Component.text(sb.substring(it.getIndex(), end2)));
            }
            it.setIndex(end2);
        }
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O mergeStyleAndOptionallyDeepRender(Component component, B builder, C context2) {
        this.mergeStyle(component, builder, context2);
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), builder, context2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O optionallyRenderChildrenAppendAndBuild(List<Component> children2, B builder, C context2) {
        if (!children2.isEmpty()) {
            children2.forEach(child2 -> builder.append(this.render((Component)child2, context2)));
        }
        return (O)builder.build();
    }

    protected <B extends ComponentBuilder<?, ?>> void mergeStyle(Component component, B builder, C context2) {
        builder.mergeStyle(component, MERGES);
        builder.clickEvent(component.clickEvent());
        @Nullable HoverEvent<?> hoverEvent = component.hoverEvent();
        if (hoverEvent != null) {
            builder.hoverEvent(hoverEvent.withRenderedValue(this, context2));
        }
    }
}

