/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class MonkeyBars {
    private MonkeyBars() {
    }

    @SafeVarargs
    @NotNull
    public static <E extends Enum<E>> Set<E> enumSet(Class<E> type2, E ... constants) {
        EnumSet<E> set2 = EnumSet.noneOf(type2);
        Collections.addAll(set2, constants);
        return Collections.unmodifiableSet(set2);
    }

    @NotNull
    public static <T> List<T> addOne(@NotNull List<T> oldList, T newElement) {
        if (oldList.isEmpty()) {
            return Collections.singletonList(newElement);
        }
        ArrayList<T> newList = new ArrayList<T>(oldList.size() + 1);
        newList.addAll(oldList);
        newList.add(newElement);
        return Collections.unmodifiableList(newList);
    }

    @SafeVarargs
    @NotNull
    public static <I, O> List<O> nonEmptyArrayToList(@NotNull Function<I, O> mapper, @NotNull I first2, I ... others) {
        ArrayList<O> ret = new ArrayList<O>(others.length + 1);
        ret.add(mapper.apply(first2));
        for (I other : others) {
            ret.add(Objects.requireNonNull(mapper.apply(Objects.requireNonNull(other, "source[?]")), "mapper(source[?])"));
        }
        return Collections.unmodifiableList(ret);
    }

    @NotNull
    public static <I, O> List<O> toUnmodifiableList(@NotNull Function<I, O> mapper, @NotNull Iterable<? extends I> source2) {
        ArrayList<O> ret = source2 instanceof Collection ? new ArrayList<O>(((Collection)source2).size()) : new ArrayList();
        for (I el : source2) {
            ret.add(Objects.requireNonNull(mapper.apply(Objects.requireNonNull(el, "source[?]")), "mapper(source[?])"));
        }
        return Collections.unmodifiableList(ret);
    }
}

