/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.RRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\r\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/skia/Rect;", "", "left", "", "top", "right", "bottom", "(FFFF)V", "getBottom", "()F", "height", "getHeight", "isEmpty", "", "()Z", "getLeft", "getRight", "getTop", "width", "getWidth", "equals", "other", "hashCode", "", "inflate", "spread", "intersect", "offset", "dx", "dy", "vec", "Lorg/jetbrains/skia/Point;", "scale", "sx", "sy", "serializeToFloatArray", "", "serializeToFloatArray$skiko", "toIRect", "Lorg/jetbrains/skia/IRect;", "toString", "", "Companion", "skiko"})
public class Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    public Rect(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    public final float getWidth() {
        return this.right - this.left;
    }

    public final float getHeight() {
        return this.bottom - this.top;
    }

    @Nullable
    public final Rect intersect(@NotNull Rect other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.right <= other.left || other.right <= this.left || this.bottom <= other.top || other.bottom <= this.top ? null : new Rect(Math.max(this.left, other.left), Math.max(this.top, other.top), Math.min(this.right, other.right), Math.min(this.bottom, other.bottom));
    }

    @NotNull
    public final Rect scale(float scale2) {
        return this.scale(scale2, scale2);
    }

    @NotNull
    public final Rect scale(float sx, float sy) {
        return new Rect(this.left * sx, this.top * sy, this.right * sx, this.bottom * sy);
    }

    @NotNull
    public final Rect offset(float dx, float dy) {
        return new Rect(this.left + dx, this.top + dy, this.right + dx, this.bottom + dy);
    }

    @NotNull
    public final Rect offset(@NotNull Point vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return this.offset(vec.getX(), vec.getY());
    }

    @NotNull
    public final IRect toIRect() {
        return new IRect((int)this.left, (int)this.top, (int)this.right, (int)this.bottom);
    }

    @NotNull
    public Rect inflate(float spread) {
        return spread <= 0.0f ? Companion.makeLTRB(this.left - spread, this.top - spread, Math.max(this.left - spread, this.right + spread), Math.max(this.top - spread, this.bottom + spread)) : (Rect)RRect.Companion.makeLTRB(this.left - spread, this.top - spread, Math.max(this.left - spread, this.right + spread), Math.max(this.top - spread, this.bottom + spread), spread);
    }

    @NotNull
    public final float[] serializeToFloatArray$skiko() {
        float[] fArray = new float[]{this.left, this.top, this.right, this.bottom};
        return fArray;
    }

    public final boolean isEmpty() {
        return this.right == this.left || this.top == this.bottom;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rect)) {
            return false;
        }
        if (Float.compare(this.left, ((Rect)other).left) != 0) {
            return false;
        }
        if (Float.compare(this.top, ((Rect)other).top) != 0) {
            return false;
        }
        if (Float.compare(this.right, ((Rect)other).right) != 0) {
            return false;
        }
        return Float.compare(this.bottom, ((Rect)other).bottom) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * PRIME + Float.floatToIntBits(this.left);
        result2 = result2 * PRIME + Float.floatToIntBits(this.top);
        result2 = result2 * PRIME + Float.floatToIntBits(this.right);
        result2 = result2 * PRIME + Float.floatToIntBits(this.bottom);
        return result2;
    }

    @NotNull
    public String toString() {
        return "Rect(_left=" + this.left + ", _top=" + this.top + ", _right=" + this.right + ", _bottom=" + this.bottom + ')';
    }

    @JvmStatic
    @NotNull
    public static final Rect makeLTRB(float l, float t2, float r, float b) {
        return Companion.makeLTRB(l, t2, r, b);
    }

    @JvmStatic
    @NotNull
    public static final Rect makeWH(float w, float h2) {
        return Companion.makeWH(w, h2);
    }

    @JvmStatic
    @NotNull
    public static final Rect makeWH(@NotNull Point size2) {
        return Companion.makeWH(size2);
    }

    @JvmStatic
    @NotNull
    public static final Rect makeXYWH(float l, float t2, float w, float h2) {
        return Companion.makeXYWH(l, t2, w, h2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ2\u0010\u0003\u001a\u00020\u00052#\u0010\b\u001a\u001f\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\b\rH\u0000\u00a2\u0006\u0002\b\u000eJ)\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0018\u0010\b\u001a\u0014\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J(\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001dH\u0007J(\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/Rect$Companion;", "", "()V", "fromInteropPointer", "", "Lorg/jetbrains/skia/Rect;", "size", "", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "(ILkotlin/jvm/functions/Function2;)[Lorg/jetbrains/skia/Rect;", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "makeLTRB", "l", "", "t", "r", "b", "makeWH", "w", "h", "Lorg/jetbrains/skia/Point;", "makeXYWH", "skiko"})
    @SourceDebugExtension(value={"SMAP\nRect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rect.kt\norg/jetbrains/skia/Rect$Companion\n+ 2 Native.kt\norg/jetbrains/skia/impl/NativeKt\n+ 3 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,128:1\n96#2:129\n97#2,5:131\n96#2:136\n97#2,5:138\n56#3:130\n56#3:137\n1549#4:143\n1620#4,3:144\n37#5,2:147\n*S KotlinDebug\n*F\n+ 1 Rect.kt\norg/jetbrains/skia/Rect$Companion\n*L\n110#1:129\n110#1:131,5\n115#1:136\n115#1:138,5\n110#1:130\n115#1:137\n116#1:143\n116#1:144,3\n118#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Rect makeLTRB(float l, float t2, float r, float b) {
            return new Rect(l, t2, r, b);
        }

        @JvmStatic
        @NotNull
        public final Rect makeWH(float w, float h2) {
            return new Rect(0.0f, 0.0f, w, h2);
        }

        @JvmStatic
        @NotNull
        public final Rect makeWH(@NotNull Point size2) {
            Intrinsics.checkNotNullParameter(size2, "size");
            return this.makeWH(size2.getX(), size2.getY());
        }

        @JvmStatic
        @NotNull
        public final Rect makeXYWH(float l, float t2, float w, float h2) {
            return new Rect(l, t2, l + w, t2 + h2);
        }

        @NotNull
        public final Rect fromInteropPointer$skiko(@NotNull Function2<? super InteropScope, Object, Unit> block2) {
            Intrinsics.checkNotNullParameter(block2, "block");
            float[] result$iv = new float[4];
            boolean $i$f$withResult = false;
            boolean $i$f$interopScope = false;
            InteropScope $this$withResult_u24lambda_u242$iv = theScope.INSTANCE;
            boolean bl = false;
            Object handle$iv = $this$withResult_u24lambda_u242$iv.toInteropForResult(result$iv);
            block2.invoke($this$withResult_u24lambda_u242$iv, handle$iv);
            $this$withResult_u24lambda_u242$iv.fromInterop(handle$iv, result$iv);
            float[] result2 = result$iv;
            return new Rect(result2[0], result2[1], result2[2], result2[3]);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Rect[] fromInteropPointer$skiko(int size2, @NotNull Function2<? super InteropScope, Object, Unit> block2) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(block2, "block");
            float[] result$iv = new float[size2];
            boolean $i$f$withResult = false;
            boolean $i$f$interopScope22 = false;
            InteropScope $this$withResult_u24lambda_u242$iv = theScope.INSTANCE;
            boolean bl = false;
            Object handle$iv = $this$withResult_u24lambda_u242$iv.toInteropForResult(result$iv);
            block2.invoke($this$withResult_u24lambda_u242$iv, handle$iv);
            $this$withResult_u24lambda_u242$iv.fromInterop(handle$iv, result$iv);
            float[] result2 = result$iv;
            Iterable $this$map$iv = CollectionsKt.chunked((Iterable)ArraysKt.toList(result2), 4);
            boolean $i$f$map = false;
            Iterable $i$f$interopScope22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                float left = ((Number)list2.get(0)).floatValue();
                float top = ((Number)list2.get(1)).floatValue();
                float right = ((Number)list2.get(2)).floatValue();
                float bottom = ((Number)list2.get(3)).floatValue();
                collection.add(new Rect(left, right, top, bottom));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Rect[0]);
        }

        @Nullable
        public final Rect fromInteropPointerNullable$skiko(@NotNull Function1<Object, Boolean> block2) {
            Intrinsics.checkNotNullParameter(block2, "block");
            Ref.BooleanRef result2 = new Ref.BooleanRef();
            result2.element = true;
            Rect rect2 = this.fromInteropPointer$skiko((Function2<? super InteropScope, Object, Unit>)new Function2<InteropScope, Object, Unit>(result2, block2){
                final /* synthetic */ Ref.BooleanRef $result;
                final /* synthetic */ Function1<Object, Boolean> $block;
                {
                    this.$result = $result;
                    this.$block = $block;
                    super(2);
                }

                public final void invoke(@NotNull InteropScope $this$fromInteropPointer, @Nullable Object it) {
                    Intrinsics.checkNotNullParameter($this$fromInteropPointer, "$this$fromInteropPointer");
                    this.$result.element = this.$block.invoke(it);
                }
            });
            return result2.element ? rect2 : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

