/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.impl.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0018R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/skia/impl/Stats;", "", "()V", "allocated", "", "", "", "getAllocated", "()Ljava/util/Map;", "setAllocated", "(Ljava/util/Map;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "nativeCalls", "", "getNativeCalls", "()J", "setNativeCalls", "(J)V", "onAllocated", "", "className", "onDeallocated", "onNativeCall", "skiko"})
public final class Stats {
    @NotNull
    public static final Stats INSTANCE = new Stats();
    private static boolean enabled;
    private static long nativeCalls;
    @NotNull
    private static Map<String, Integer> allocated;

    private Stats() {
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void setEnabled(boolean bl) {
        enabled = bl;
    }

    public final long getNativeCalls() {
        return nativeCalls;
    }

    public final void setNativeCalls(long l) {
        nativeCalls = l;
    }

    @NotNull
    public final Map<String, Integer> getAllocated() {
        return allocated;
    }

    public final void setAllocated(@NotNull Map<String, Integer> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        allocated = map2;
    }

    public final void onNativeCall() {
        if (enabled) {
            long l = nativeCalls;
            nativeCalls = l + 1L;
        }
    }

    public final void onAllocated(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        if (enabled) {
            allocated.merge(className, 1, (arg_0, arg_1) -> Stats.onAllocated$lambda$0(onAllocated.1.INSTANCE, arg_0, arg_1));
        }
    }

    public final void onDeallocated(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        if (enabled) {
            allocated.merge(className, -1, (arg_0, arg_1) -> Stats.onDeallocated$lambda$1(onDeallocated.1.INSTANCE, arg_0, arg_1));
        }
    }

    private static final Integer onAllocated$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    private static final Integer onDeallocated$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    static {
        String string = System.getProperty("skiko.collect.stat");
        enabled = string != null ? Boolean.parseBoolean(string) : false;
        allocated = new ConcurrentHashMap();
    }
}

