/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.Actuals_awtKt;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.PredefinedCursorsId;
import org.jetbrains.skiko.RenderFactory;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.Direct3DRedrawer;
import org.jetbrains.skiko.redrawer.LinuxOpenGLRedrawer;
import org.jetbrains.skiko.redrawer.LinuxSoftwareRedrawer;
import org.jetbrains.skiko.redrawer.MetalRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.SoftwareRedrawer;
import org.jetbrains.skiko.redrawer.WindowsOpenGLRedrawer;
import org.jetbrains.skiko.redrawer.WindowsSoftwareRedrawer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001c\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0013\u001a\u00060\u000ej\u0002`\u000fH\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0016\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\b\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0006\u0010\u001b\u001a\u00020\u000b\"\u001d\u0010\u0000\u001a\u0004\u0018\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003*\n\u0010\u001c\"\u00020\u000e2\u00020\u000e\u00a8\u0006\u001d"}, d2={"systemClipboard", "Ljava/awt/datatransfer/Clipboard;", "getSystemClipboard", "()Ljava/awt/datatransfer/Clipboard;", "systemClipboard$delegate", "Lkotlin/Lazy;", "ClipboardManager_getText", "", "ClipboardManager_hasText", "", "ClipboardManager_setText", "", "text", "CursorManager_getCursor", "Ljava/awt/Cursor;", "Lorg/jetbrains/skiko/Cursor;", "component", "", "CursorManager_setCursor", "cursor", "URIHandler_openUri", "uri", "getCursorById", "id", "Lorg/jetbrains/skiko/PredefinedCursorsId;", "makeDefaultRenderFactory", "Lorg/jetbrains/skiko/RenderFactory;", "setSystemLookAndFeel", "Cursor", "skiko"})
public final class Actuals_awtKt {
    @NotNull
    private static final Lazy systemClipboard$delegate = LazyKt.lazy(systemClipboard.2.INSTANCE);

    public static final void setSystemLookAndFeel() {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    @NotNull
    public static final RenderFactory makeDefaultRenderFactory() {
        return new RenderFactory(){

            @NotNull
            public Redrawer createRedrawer(@NotNull SkiaLayer layer, @NotNull GraphicsApi renderApi, @NotNull SkiaLayerAnalytics analytics, @NotNull SkiaLayerProperties properties) {
                Redrawer redrawer;
                Intrinsics.checkNotNullParameter(layer, "layer");
                Intrinsics.checkNotNullParameter((Object)((Object)renderApi), "renderApi");
                Intrinsics.checkNotNullParameter(analytics, "analytics");
                Intrinsics.checkNotNullParameter(properties, "properties");
                switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$1[OsArch_jvmKt.getHostOs().ordinal()]) {
                    case 1: {
                        AWTRedrawer aWTRedrawer;
                        switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$0[renderApi.ordinal()]) {
                            case 1: 
                            case 2: {
                                aWTRedrawer = new SoftwareRedrawer(layer, analytics, properties);
                                break;
                            }
                            default: {
                                aWTRedrawer = new MetalRedrawer(layer, analytics, properties);
                            }
                        }
                        redrawer = aWTRedrawer;
                        break;
                    }
                    case 2: {
                        AWTRedrawer aWTRedrawer;
                        switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$0[renderApi.ordinal()]) {
                            case 1: {
                                aWTRedrawer = new SoftwareRedrawer(layer, analytics, properties);
                                break;
                            }
                            case 2: {
                                aWTRedrawer = new WindowsSoftwareRedrawer(layer, analytics, properties);
                                break;
                            }
                            case 3: {
                                aWTRedrawer = new WindowsOpenGLRedrawer(layer, analytics, properties);
                                break;
                            }
                            default: {
                                aWTRedrawer = new Direct3DRedrawer(layer, analytics, properties);
                            }
                        }
                        redrawer = aWTRedrawer;
                        break;
                    }
                    case 3: {
                        AWTRedrawer aWTRedrawer;
                        switch (makeDefaultRenderFactory.WhenMappings.$EnumSwitchMapping$0[renderApi.ordinal()]) {
                            case 1: {
                                aWTRedrawer = new SoftwareRedrawer(layer, analytics, properties);
                                break;
                            }
                            case 2: {
                                aWTRedrawer = new LinuxSoftwareRedrawer(layer, analytics, properties);
                                break;
                            }
                            default: {
                                aWTRedrawer = new LinuxOpenGLRedrawer(layer, analytics, properties);
                            }
                        }
                        redrawer = aWTRedrawer;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        throw new UnsupportedOperationException("The awt target doesn't support " + (Object)((Object)OsArch_jvmKt.getHostOs()));
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return redrawer;
            }
        };
    }

    public static final void URIHandler_openUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(uri));
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[OsArch_jvmKt.getHostOs().ordinal()]) {
                case 1: {
                    new URI(uri);
                    Runtime runtime = Runtime.getRuntime();
                    String[] stringArray = new String[2];
                    stringArray[0] = "xdg-open";
                    Intrinsics.checkNotNullExpressionValue(new URL(uri).toString(), "toString(...)");
                    runtime.exec(stringArray);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    throw new UnsupportedOperationException("AWT does not support the BROWSE action on this platform");
                }
            }
        }
    }

    private static final Clipboard getSystemClipboard() {
        Lazy lazy = systemClipboard$delegate;
        return (Clipboard)lazy.getValue();
    }

    public static final void ClipboardManager_setText(@NotNull String text2) {
        block0: {
            Intrinsics.checkNotNullParameter(text2, "text");
            Clipboard clipboard = Actuals_awtKt.getSystemClipboard();
            if (clipboard == null) break block0;
            clipboard.setContents(new StringSelection(text2), null);
        }
    }

    @Nullable
    public static final String ClipboardManager_getText() {
        String string;
        try {
            Clipboard clipboard = Actuals_awtKt.getSystemClipboard();
            string = (String)(clipboard != null ? clipboard.getData(DataFlavor.stringFlavor) : null);
        }
        catch (UnsupportedFlavorException _) {
            string = null;
        }
        catch (IllegalStateException _) {
            string = null;
        }
        catch (IOException _) {
            string = null;
        }
        return string;
    }

    public static final boolean ClipboardManager_hasText() {
        CharSequence charSequence = Actuals_awtKt.ClipboardManager_getText();
        return !(charSequence == null || charSequence.length() == 0);
    }

    public static final void CursorManager_setCursor(@NotNull Object component, @NotNull Cursor cursor2) {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(cursor2, "cursor");
        if (component instanceof Component) {
            ((Component)component).setCursor(cursor2);
        }
    }

    @Nullable
    public static final Cursor CursorManager_getCursor(@NotNull Object component) {
        Intrinsics.checkNotNullParameter(component, "component");
        return component instanceof Component ? ((Component)component).getCursor() : null;
    }

    @NotNull
    public static final Cursor getCursorById(@NotNull PredefinedCursorsId id) {
        Cursor cursor2;
        Intrinsics.checkNotNullParameter((Object)id, "id");
        switch (WhenMappings.$EnumSwitchMapping$1[id.ordinal()]) {
            case 1: {
                cursor2 = new Cursor(0);
                break;
            }
            case 2: {
                cursor2 = new Cursor(1);
                break;
            }
            case 3: {
                cursor2 = new Cursor(12);
                break;
            }
            case 4: {
                cursor2 = new Cursor(2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cursor2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Android.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Ios.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Tvos.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.JS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Unknown.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PredefinedCursorsId.values().length];
            try {
                nArray[PredefinedCursorsId.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedCursorsId.CROSSHAIR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedCursorsId.HAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedCursorsId.TEXT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

