/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0011\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0011\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\fH\u0082 J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0011\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\fH\u0082 J)\u0010$\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0082 J\t\u0010&\u001a\u00020\fH\u0082 J(\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\fH\u0014J\u0019\u0010)\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0082 J\u0011\u0010*\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\fH\u0082 R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/skiko/swing/LinuxOpenGLSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "bytesToDraw", "", "offScreenBufferPtr", "", "offScreenContextPtr", "storage", "Lorg/jetbrains/skia/Bitmap;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "createAndBindTexture", "width", "", "height", "dispose", "", "disposeOffScreenBuffer", "bufferPtr", "disposeOffScreenContext", "contextPtr", "finishRendering", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "getFboId", "texturePtr", "makeOffScreenBuffer", "oldBufferPtr", "makeOffScreenContext", "onRender", "nanoTime", "startRendering", "unbindAndDisposeTexture", "skiko"})
public final class LinuxOpenGLSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    private final SkikoRenderDelegate renderDelegate;
    @NotNull
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    private final long offScreenContextPtr;
    private long offScreenBufferPtr;
    @NotNull
    private final Bitmap storage;
    @NotNull
    private byte[] bytesToDraw;

    /*
     * WARNING - void declaration
     */
    public LinuxOpenGLSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoRenderDelegate renderDelegate2, @NotNull SkiaLayerAnalytics analytics) {
        void it;
        long l;
        Intrinsics.checkNotNullParameter(swingLayerProperties2, "swingLayerProperties");
        Intrinsics.checkNotNullParameter(renderDelegate2, "renderDelegate");
        Intrinsics.checkNotNullParameter(analytics, "analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.OPENGL);
        this.renderDelegate = renderDelegate2;
        this.onDeviceChosen("OpenGL OffScreen");
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
        long l2 = l = this.makeOffScreenContext();
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        boolean bl = false;
        if (it == 0L) {
            throw new RenderException("Cannot create OpenGL context", null, 2, null);
        }
        linuxOpenGLSwingRedrawer.offScreenContextPtr = l;
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        this.disposeOffScreenBuffer(this.offScreenBufferPtr);
        this.disposeOffScreenContext(this.offScreenContextPtr);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRender(@NotNull Graphics2D g2, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter(g2, "g");
        this.offScreenBufferPtr = this.makeOffScreenBuffer(this.offScreenContextPtr, this.offScreenBufferPtr, width2, height2);
        if (this.offScreenBufferPtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL buffer", null, 2, null);
        }
        this.startRendering(this.offScreenContextPtr, this.offScreenBufferPtr);
        try {
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)new Function1<CloseScope, Unit>(this, width2, height2, nanoTime, g2){
                final /* synthetic */ LinuxOpenGLSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    this.this$0 = $receiver;
                    this.$width = $width;
                    this.$height = $height;
                    this.$nanoTime = $nanoTime;
                    this.$g = $g;
                    super(1);
                }

                public final void invoke(@NotNull CloseScope $this$autoCloseScope) {
                    Surface surface2;
                    Intrinsics.checkNotNullParameter($this$autoCloseScope, "$this$autoCloseScope");
                    long texturePtr = LinuxOpenGLSwingRedrawer.access$createAndBindTexture(this.this$0, this.$width, this.$height);
                    if (texturePtr == 0L) {
                        throw new RenderException("Cannot create offScreen OpenGL texture", null, 2, null);
                    }
                    int fbId = LinuxOpenGLSwingRedrawer.access$getFboId(this.this$0, texturePtr);
                    BackendRenderTarget renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLRenderTarget(this.$width, this.$height, 0, 8, fbId, 32856));
                    DirectContext directContext = (DirectContext)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLContext());
                    Surface surface3 = Surface.Companion.makeFromBackendRenderTarget(directContext, renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (surface3 == null || (surface2 = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)surface3)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    Surface surface4 = surface2;
                    Canvas canvas = surface4.getCanvas();
                    canvas.clear(0);
                    LinuxOpenGLSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                    LinuxOpenGLSwingRedrawer.access$flush(this.this$0, surface4, this.$g);
                    LinuxOpenGLSwingRedrawer.access$unbindAndDisposeTexture(this.this$0, texturePtr);
                }
            });
        }
        finally {
            this.finishRendering(this.offScreenContextPtr);
        }
    }

    private final void flush(Surface surface2, Graphics2D g2) {
        surface2.flushAndSubmit(true);
        int width2 = surface2.getWidth();
        int height2 = surface2.getHeight();
        int dstRowBytes = width2 * 4;
        if (this.storage.getWidth() != width2 || this.storage.getHeight() != height2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, dstRowBytes, 0, 5, null)];
        }
        surface2.readPixels(this.storage, 0, 0);
        boolean successfulRead = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, dstRowBytes, 0, 0, 26, null);
        if (successfulRead) {
            this.swingOffscreenDrawer.draw(g2, this.bytesToDraw, width2, height2);
        }
    }

    private final native long makeOffScreenContext();

    private final native long disposeOffScreenContext(long var1);

    private final native long makeOffScreenBuffer(long var1, long var3, int var5, int var6);

    private final native void disposeOffScreenBuffer(long var1);

    private final native void startRendering(long var1, long var3);

    private final native void finishRendering(long var1);

    private final native long createAndBindTexture(int var1, int var2);

    private final native int getFboId(long var1);

    private final native void unbindAndDisposeTexture(long var1);

    public static final /* synthetic */ long access$createAndBindTexture(LinuxOpenGLSwingRedrawer $this, int width2, int height2) {
        return $this.createAndBindTexture(width2, height2);
    }

    public static final /* synthetic */ int access$getFboId(LinuxOpenGLSwingRedrawer $this, long texturePtr) {
        return $this.getFboId(texturePtr);
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(LinuxOpenGLSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(LinuxOpenGLSwingRedrawer $this, Surface surface2, Graphics2D g2) {
        $this.flush(surface2, g2);
    }

    public static final /* synthetic */ void access$unbindAndDisposeTexture(LinuxOpenGLSwingRedrawer $this, long texturePtr) {
        $this.unbindAndDisposeTexture(texturePtr);
    }
}

