/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "storage", "Lorg/jetbrains/skia/Bitmap;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "dispose", "", "flush", "g", "Ljava/awt/Graphics2D;", "onRender", "width", "", "height", "nanoTime", "", "skiko"})
public final class SoftwareSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    private final SkikoRenderDelegate renderDelegate;
    @NotNull
    private final SwingOffscreenDrawer swingOffscreenDrawer;
    @NotNull
    private final Bitmap storage;

    public SoftwareSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoRenderDelegate renderDelegate2, @NotNull SkiaLayerAnalytics analytics) {
        Intrinsics.checkNotNullParameter(swingLayerProperties2, "swingLayerProperties");
        Intrinsics.checkNotNullParameter(renderDelegate2, "renderDelegate");
        Intrinsics.checkNotNullParameter(analytics, "analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.SOFTWARE_FAST);
        this.renderDelegate = renderDelegate2;
        this.onDeviceChosen("Software");
        this.swingOffscreenDrawer = new SwingOffscreenDrawer(swingLayerProperties2);
        this.storage = new Bitmap();
        this.onContextInit();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.storage.close();
    }

    @Override
    protected void onRender(@NotNull Graphics2D g2, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter(g2, "g");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)new Function1<CloseScope, Unit>(this, width2, height2, nanoTime, g2){
            final /* synthetic */ SoftwareSwingRedrawer this$0;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ long $nanoTime;
            final /* synthetic */ Graphics2D $g;
            {
                this.this$0 = $receiver;
                this.$width = $width;
                this.$height = $height;
                this.$nanoTime = $nanoTime;
                this.$g = $g;
                super(1);
            }

            public final void invoke(@NotNull CloseScope $this$autoCloseScope) {
                Intrinsics.checkNotNullParameter($this$autoCloseScope, "$this$autoCloseScope");
                if (SoftwareSwingRedrawer.access$getStorage$p(this.this$0).getWidth() != this.$width || SoftwareSwingRedrawer.access$getStorage$p(this.this$0).getHeight() != this.$height) {
                    SoftwareSwingRedrawer.access$getStorage$p(this.this$0).allocPixelsFlags(ImageInfo.Companion.makeS32(this.$width, this.$height, ColorAlphaType.PREMUL), false);
                }
                Canvas canvas = (Canvas)$this$autoCloseScope.autoClose((AutoCloseable)new Canvas(SoftwareSwingRedrawer.access$getStorage$p(this.this$0), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null)));
                canvas.clear(0);
                SoftwareSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                SoftwareSwingRedrawer.access$flush(this.this$0, this.$g);
            }
        });
    }

    private final void flush(Graphics2D g2) {
        int width2 = this.storage.getWidth();
        int height2 = this.storage.getHeight();
        byte[] bytes = this.storage.readPixels(this.storage.getImageInfo(), width2 * 4, 0, 0);
        if (bytes != null) {
            this.swingOffscreenDrawer.draw(g2, bytes, width2, height2);
        }
    }

    public static final /* synthetic */ Bitmap access$getStorage$p(SoftwareSwingRedrawer $this) {
        return $this.storage;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(SoftwareSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(SoftwareSwingRedrawer $this, Graphics2D g2) {
        $this.flush(g2);
    }
}

