/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.grpcpacketchannel;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import me.fan87.pixelmongo.ui.com.google.protobuf.ByteString;
import org.jetbrains.annotations.NotNull;
import tech.fandiful.grpcpacketchannel.proto.CallIdKt;
import tech.fandiful.grpcpacketchannel.proto.Packets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\tH\u0002J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u00130\u0012j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltech/fandiful/grpcpacketchannel/WrappedPacketHandler;", "", "maxPacketSize", "", "timeOutTime", "", "sendData", "Lkotlin/Function1;", "", "", "submitData", "(IJLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "incomingTransactions", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Ljava/io/ByteArrayOutputStream;", "Lkotlin/collections/HashMap;", "transactionClearQueue", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lkotlin/collections/ArrayList;", "refreshQueue", "send", "data", "submit", "bytes", "grpc-java-packet-channel"})
@SourceDebugExtension(value={"SMAP\nWrappedPacketHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrappedPacketHandler.kt\ntech/fandiful/grpcpacketchannel/WrappedPacketHandler\n+ 2 CallIdKt.kt\ntech/fandiful/grpcpacketchannel/proto/CallIdKtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n10#2:90\n1#3:91\n*S KotlinDebug\n*F\n+ 1 WrappedPacketHandler.kt\ntech/fandiful/grpcpacketchannel/WrappedPacketHandler\n*L\n65#1:90\n65#1:91\n*E\n"})
public final class WrappedPacketHandler {
    private final int maxPacketSize;
    private final long timeOutTime;
    @NotNull
    private final Function1<byte[], Unit> sendData;
    @NotNull
    private final Function1<byte[], Unit> submitData;
    @NotNull
    private final HashMap<UUID, ByteArrayOutputStream> incomingTransactions;
    @NotNull
    private final ArrayList<Pair<Long, UUID>> transactionClearQueue;

    public WrappedPacketHandler(int maxPacketSize, long timeOutTime, @NotNull Function1<? super byte[], Unit> sendData, @NotNull Function1<? super byte[], Unit> submitData) {
        Intrinsics.checkNotNullParameter(sendData, "sendData");
        Intrinsics.checkNotNullParameter(submitData, "submitData");
        this.maxPacketSize = maxPacketSize;
        this.timeOutTime = timeOutTime;
        this.sendData = sendData;
        this.submitData = submitData;
        this.incomingTransactions = new HashMap();
        this.transactionClearQueue = new ArrayList();
    }

    private final void refreshQueue() {
        Iterator<Pair<Long, UUID>> iterator2 = this.transactionClearQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Pair<Long, UUID>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Pair<Long, UUID> next2;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (System.currentTimeMillis() - ((Number)next2.getFirst()).longValue() > this.timeOutTime) {
                this.incomingTransactions.remove(next2.getSecond());
                iterator3.remove();
                continue;
            }
            return;
        }
    }

    public final void submit(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Packets.PacketWrapper data2 = Packets.PacketWrapper.parseFrom(bytes);
        this.refreshQueue();
        UUID uuid = new UUID(data2.getPacketId().getMost(), data2.getPacketId().getLeast());
        if (((Map)this.incomingTransactions).containsKey(uuid) == data2.getStartOfMessage()) {
            throw new IllegalStateException("duplicated transaction id or not found");
        }
        ByteArrayOutputStream byteArrayOutputStream = this.incomingTransactions.get(uuid);
        if (byteArrayOutputStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        ByteArrayOutputStream stream = byteArrayOutputStream;
        stream.write(data2.getData().toByteArray());
        if (data2.getEndOfMessage()) {
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            this.submitData.invoke(byArray);
            this.incomingTransactions.remove(uuid);
            Iterator<Pair<Long, UUID>> iterator2 = this.transactionClearQueue.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Pair<Long, UUID>> iter = iterator2;
            while (iter.hasNext()) {
                Pair<Long, UUID> next2;
                Intrinsics.checkNotNullExpressionValue(iter.next(), "next(...)");
                if (!Intrinsics.areEqual(next2.getSecond(), uuid)) continue;
                iter.remove();
                return;
            }
        } else if (data2.getStartOfMessage()) {
            ((Map)this.incomingTransactions).put(uuid, stream);
            this.transactionClearQueue.add(TuplesKt.to(System.currentTimeMillis(), uuid));
        }
    }

    public final void send(@NotNull byte[] data2) {
        CallIdKt.Dsl dsl;
        Intrinsics.checkNotNullParameter(data2, "data");
        boolean bl = false;
        Packets.CallId.Builder builder = Packets.CallId.newBuilder();
        Intrinsics.checkNotNullExpressionValue(builder, "newBuilder(...)");
        CallIdKt.Dsl $this$callId_u24lambda_u240$iv = dsl = CallIdKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        CallIdKt.Dsl $this$send_u24lambda_u240 = $this$callId_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$send_u24lambda_u240.setMost(Random.Default.nextLong());
        $this$send_u24lambda_u240.setLeast(Random.Default.nextLong());
        Packets.CallId packetId = dsl._build();
        int amountOfPackets = (int)Math.ceil((float)data2.length / (float)(this.maxPacketSize - 40));
        int perPacket = this.maxPacketSize - 40;
        int offset2 = 0;
        for (int i = 0; i < amountOfPackets; ++i) {
            boolean isLastPacket = i == amountOfPackets - 1;
            int packetSize = isLastPacket ? data2.length - offset2 : perPacket;
            byte[] byArray = Packets.PacketWrapper.newBuilder().setPacketId(packetId).setData(ByteString.copyFrom(data2, offset2, packetSize)).setEndOfMessage(isLastPacket).setStartOfMessage(i == 0).build().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            this.sendData.invoke(byArray);
            offset2 += packetSize;
        }
    }
}

