/*
 * Decompiled with CFR 0.152.
 */
package tech.fandiful.grpcpacketchannel.impl.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.fandiful.grpcpacketchannel.WrappedPacketHandler;
import tech.fandiful.grpcpacketchannel.impl.client.ClientCallImpl;
import tech.fandiful.grpcpacketchannel.packets.PacketTypes;
import tech.fandiful.grpcpacketchannel.proto.Packets;
import tech.fandiful.grpcpacketchannel.utils.GrpcConversionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J<\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ltech/fandiful/grpcpacketchannel/impl/client/GrpcPacketChannel;", "Lio/grpc/Channel;", "authority", "", "maxPacketSize", "", "dataSubmitter", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "calls", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Ltech/fandiful/grpcpacketchannel/impl/client/ClientCallImpl;", "getCalls$grpc_java_packet_channel", "()Ljava/util/HashMap;", "wrapper", "Ltech/fandiful/grpcpacketchannel/WrappedPacketHandler;", "newCall", "Lio/grpc/ClientCall;", "RequestT", "ResponseT", "methodDescriptor", "Lio/grpc/MethodDescriptor;", "callOptions", "Lio/grpc/CallOptions;", "readAndHandleData", "data", "Ljava/io/InputStream;", "submitData", "grpc-java-packet-channel"})
public final class GrpcPacketChannel
extends Channel {
    @NotNull
    private final String authority;
    @NotNull
    private final Function1<byte[], Unit> dataSubmitter;
    @NotNull
    private final HashMap<UUID, ClientCallImpl<?, ?>> calls;
    @NotNull
    private final WrappedPacketHandler wrapper;

    public GrpcPacketChannel(@NotNull String authority2, int maxPacketSize, @NotNull Function1<? super byte[], Unit> dataSubmitter) {
        Intrinsics.checkNotNullParameter(authority2, "authority");
        Intrinsics.checkNotNullParameter(dataSubmitter, "dataSubmitter");
        this.authority = authority2;
        this.dataSubmitter = dataSubmitter;
        this.calls = new HashMap();
        this.wrapper = new WrappedPacketHandler(maxPacketSize, 10000L, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(this){
            final /* synthetic */ GrpcPacketChannel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull byte[] it) {
                Intrinsics.checkNotNullParameter(it, "it");
                GrpcPacketChannel.access$getDataSubmitter$p(this.this$0).invoke(it);
            }
        }, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(this){
            final /* synthetic */ GrpcPacketChannel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull byte[] it) {
                Intrinsics.checkNotNullParameter(it, "it");
                GrpcPacketChannel.access$readAndHandleData(this.this$0, new ByteArrayInputStream(it));
            }
        });
    }

    public /* synthetic */ GrpcPacketChannel(String string, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(string, n, function1);
    }

    @NotNull
    public final HashMap<UUID, ClientCallImpl<?, ?>> getCalls$grpc_java_packet_channel() {
        return this.calls;
    }

    public final void submitData(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        this.wrapper.submit(data2);
    }

    private final void readAndHandleData(InputStream data2) {
        Packets.PacketData packetData = Packets.PacketData.parser().parseFrom(data2);
        PacketTypes.PacketType<?> packetType = PacketTypes.INSTANCE.getPackets().get(packetData.getPacketType());
        if (packetType == null) {
            return;
        }
        PacketTypes.PacketType<?> packetType2 = packetType;
        Object packet = packetType2.getRead().parseFrom(packetData.getData());
        if (packet instanceof Packets.S2CPacketHeader) {
            ClientCallImpl<?, ?> clientCallImpl2 = this.calls.get(new UUID(((Packets.S2CPacketHeader)packet).getCallId().getMost(), ((Packets.S2CPacketHeader)packet).getCallId().getLeast()));
            if (clientCallImpl2 == null) {
                return;
            }
            ClientCallImpl<?, ?> call = clientCallImpl2;
            Packets.Metadata metadata = ((Packets.S2CPacketHeader)packet).getHeader();
            Intrinsics.checkNotNullExpressionValue(metadata, "getHeader(...)");
            call.handleHeader$grpc_java_packet_channel(GrpcConversionKt.toGrpc(metadata));
        } else if (packet instanceof Packets.S2CPacketCallResponse) {
            ClientCallImpl<?, ?> clientCallImpl3 = this.calls.get(new UUID(((Packets.S2CPacketCallResponse)packet).getCallId().getMost(), ((Packets.S2CPacketCallResponse)packet).getCallId().getLeast()));
            if (clientCallImpl3 == null) {
                return;
            }
            ClientCallImpl<?, ?> call = clientCallImpl3;
            byte[] byArray = ((Packets.S2CPacketCallResponse)packet).getData().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            call.handleResponse$grpc_java_packet_channel(byArray);
        } else if (packet instanceof Packets.S2CPacketClose) {
            ClientCallImpl<?, ?> clientCallImpl4 = this.calls.get(new UUID(((Packets.S2CPacketClose)packet).getCallId().getMost(), ((Packets.S2CPacketClose)packet).getCallId().getLeast()));
            if (clientCallImpl4 == null) {
                return;
            }
            ClientCallImpl<?, ?> call = clientCallImpl4;
            Status status = Status.fromCodeValue(((Packets.S2CPacketClose)packet).getStatusCode());
            Intrinsics.checkNotNullExpressionValue(status, "fromCodeValue(...)");
            Packets.Metadata metadata = ((Packets.S2CPacketClose)packet).getTrailers();
            Intrinsics.checkNotNullExpressionValue(metadata, "getTrailers(...)");
            call.onClose$grpc_java_packet_channel(status, GrpcConversionKt.toGrpc(metadata));
        }
    }

    @Override
    @NotNull
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(@NotNull MethodDescriptor<RequestT, ResponseT> methodDescriptor, @NotNull CallOptions callOptions) {
        Intrinsics.checkNotNullParameter(methodDescriptor, "methodDescriptor");
        Intrinsics.checkNotNullParameter(callOptions, "callOptions");
        ClientCallImpl<RequestT, ResponseT> clientCallImpl2 = new ClientCallImpl<RequestT, ResponseT>(this, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(this){
            final /* synthetic */ GrpcPacketChannel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull byte[] it) {
                Intrinsics.checkNotNullParameter(it, "it");
                GrpcPacketChannel.access$getWrapper$p(this.this$0).send(it);
            }
        }, methodDescriptor, callOptions);
        return clientCallImpl2;
    }

    @Override
    @NotNull
    public String authority() {
        return this.authority;
    }

    public static final /* synthetic */ WrappedPacketHandler access$getWrapper$p(GrpcPacketChannel $this) {
        return $this.wrapper;
    }

    public static final /* synthetic */ Function1 access$getDataSubmitter$p(GrpcPacketChannel $this) {
        return $this.dataSubmitter;
    }

    public static final /* synthetic */ void access$readAndHandleData(GrpcPacketChannel $this, InputStream data2) {
        $this.readAndHandleData(data2);
    }
}

